/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.i18n.inspections;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.i18n.JavaI18nUtil;
import com.intellij.lang.properties.ResourceBundleReference;
import com.intellij.lang.properties.psi.Property;
import com.intellij.lang.properties.references.PropertyReference;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.calls.model.ExpressionValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.VarargValueArgument;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/i18n/inspections/KotlinInvalidBundleOrPropertyInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "getDisplayName", "", "idea-jvm"})
public final class KotlinInvalidBundleOrPropertyInspection
extends AbstractKotlinInspection {
    @NotNull
    public String getDisplayName() {
        String string = CodeInsightBundle.message((String)"inspection.unresolved.property.key.reference.name", (Object[])new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"CodeInsightBundle.messag\u2026erty.key.reference.name\")");
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder2, boolean isOnTheFly) {
        Intrinsics.checkParameterIsNotNull((Object)holder2, (String)"holder");
        return new KtVisitorVoid(holder2){
            final /* synthetic */ ProblemsHolder $holder;

            private final void processResourceBundleReference(ResourceBundleReference ref2, KtStringTemplateExpression template2) {
                ResolveResult[] resolveResultArray = ref2.multiResolve(true);
                Intrinsics.checkExpressionValueIsNotNull((Object)resolveResultArray, (String)"ref.multiResolve(true)");
                ResolveResult[] resolveResultArray2 = resolveResultArray;
                boolean bl = false;
                if (resolveResultArray2.length == 0) {
                    this.$holder.registerProblem((PsiElement)template2, CodeInsightBundle.message((String)"inspection.invalid.resource.bundle.reference", (Object[])new Object[]{ref2.getCanonicalText()}), ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, new TextRange(0, template2.getTextLength()), new LocalQuickFix[0]);
                }
            }

            private final void processPropertyReference(PropertyReference ref2, KtStringTemplateExpression template2) {
                int keyArgumentIndex;
                List<ResolvedValueArgument> resolvedArguments;
                ResolvedCall resolvedCall2;
                Property property2;
                block19: {
                    int n;
                    Object v4;
                    block18: {
                        Object[] objectArray = ref2.multiResolve(true);
                        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"ref.multiResolve(true)");
                        ResolveResult resolveResult = (ResolveResult)ArraysKt.firstOrNull((Object[])objectArray);
                        Object object = resolveResult != null ? resolveResult.getElement() : null;
                        if (!(object instanceof Property)) {
                            object = null;
                        }
                        if ((property2 = (Property)object) == null) {
                            if (!ref2.isSoft()) {
                                LocalQuickFix[] localQuickFixArray = ref2.getQuickFixes();
                                this.$holder.registerProblem((PsiElement)template2, CodeInsightBundle.message((String)"inspection.unresolved.property.key.reference.message", (Object[])new Object[]{ref2.getCanonicalText()}), ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, new TextRange(0, template2.getTextLength()), Arrays.copyOf(localQuickFixArray, localQuickFixArray.length));
                            }
                            return;
                        }
                        Sequence<PsiElement> $this$firstIsInstanceOrNull$iv = PsiUtilsKt.getParents((PsiElement)template2);
                        boolean $i$f$firstIsInstanceOrNull = false;
                        for (E element$iv : $this$firstIsInstanceOrNull$iv) {
                            if (!(element$iv instanceof KtValueArgument)) continue;
                            v4 = element$iv;
                            break block18;
                        }
                        v4 = null;
                    }
                    KtValueArgument ktValueArgument = v4;
                    if (ktValueArgument == null) {
                        return;
                    }
                    KtValueArgument argument2 = ktValueArgument;
                    if (Intrinsics.areEqual((Object)argument2.getArgumentExpression(), (Object)KtPsiUtil.deparenthesize(template2)) ^ true) {
                        return;
                    }
                    PsiElement $this$getStrictParentOfType$iv = (PsiElement)argument2;
                    boolean $i$f$getStrictParentOfType = false;
                    KtCallExpression ktCallExpression = (KtCallExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtCallExpression.class, (boolean)true);
                    if (ktCallExpression == null) {
                        return;
                    }
                    KtCallExpression callExpression2 = ktCallExpression;
                    ResolvedCall resolvedCall3 = ResolutionUtils.resolveToCall$default((KtElement)callExpression2, null, (int)1, null);
                    if (resolvedCall3 == null) {
                        return;
                    }
                    resolvedCall2 = resolvedCall3;
                    List<ResolvedValueArgument> list2 = resolvedCall2.getValueArgumentsByIndex();
                    if (list2 == null) {
                        return;
                    }
                    Intrinsics.checkExpressionValueIsNotNull(list2, (String)"resolvedCall.valueArgumentsByIndex ?: return");
                    List<ResolvedValueArgument> $this$indexOfFirst$iv = resolvedArguments = list2;
                    boolean $i$f$indexOfFirst = false;
                    int index$iv = 0;
                    Iterator<ResolvedValueArgument> iterator2 = $this$indexOfFirst$iv.iterator();
                    while (iterator2.hasNext()) {
                        ResolvedValueArgument item$iv;
                        ResolvedValueArgument it = item$iv = iterator2.next();
                        boolean bl = false;
                        if (it instanceof ExpressionValueArgument && Intrinsics.areEqual((Object)((ExpressionValueArgument)it).getValueArgument(), (Object)argument2)) {
                            n = index$iv;
                            break block19;
                        }
                        ++index$iv;
                    }
                    n = keyArgumentIndex = -1;
                }
                if (keyArgumentIndex < 0) {
                    return;
                }
                D callable2 = resolvedCall2.getResultingDescriptor();
                if (callable2.getValueParameters().size() != keyArgumentIndex + 2) {
                    return;
                }
                ResolvedValueArgument resolvedValueArgument = resolvedArguments.get(keyArgumentIndex + 1);
                if (!(resolvedValueArgument instanceof VarargValueArgument)) {
                    resolvedValueArgument = null;
                }
                VarargValueArgument varargValueArgument = (VarargValueArgument)resolvedValueArgument;
                if (varargValueArgument == null) {
                    return;
                }
                VarargValueArgument messageArgument = varargValueArgument;
                List<ValueArgument> list3 = messageArgument.getArguments();
                Intrinsics.checkExpressionValueIsNotNull(list3, (String)"messageArgument.arguments");
                ValueArgument valueArgument = (ValueArgument)CollectionsKt.singleOrNull(list3);
                if ((valueArgument != null ? valueArgument.getSpreadElement() : null) != null) {
                    return;
                }
                String string = property2.getValue();
                if (string == null) {
                    string = "";
                }
                int expectedArgumentCount = JavaI18nUtil.getPropertyValuePlaceholdersCount((String)string);
                int actualArgumentCount = messageArgument.getArguments().size();
                if (actualArgumentCount < expectedArgumentCount) {
                    String string2 = CodeInsightBundle.message((String)"property.has.more.parameters.than.passed", (Object[])new Object[]{ref2.getCanonicalText(), expectedArgumentCount, actualArgumentCount});
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"CodeInsightBundle.messag\u2026unt\n                    )");
                    String description2 = string2;
                    this.$holder.registerProblem((PsiElement)template2, description2, ProblemHighlightType.GENERIC_ERROR, new LocalQuickFix[0]);
                }
            }

            public void visitStringTemplateExpression(@NotNull KtStringTemplateExpression expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                for (PsiReference ref2 : expression2.getReferences()) {
                    PsiReference psiReference = ref2;
                    if (psiReference instanceof ResourceBundleReference) {
                        this.processResourceBundleReference((ResourceBundleReference)ref2, expression2);
                        continue;
                    }
                    if (!(psiReference instanceof PropertyReference)) continue;
                    this.processPropertyReference((PropertyReference)ref2, expression2);
                }
            }
            {
                this.$holder = $captured_local_variable$0;
            }
        };
    }
}

