/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.DefaultBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.PsiModificationUtilsKt;
import org.jetbrains.kotlin.idea.inspections.AbstractApplicabilityBasedInspection;
import org.jetbrains.kotlin.idea.inspections.collections.FunctionUtilsKt;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.idea.util.ExpressionExtKt;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.synthetic.SyntheticExtensionsUtilsKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\"\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0010\u0010\u0011\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u000e\u0010\u0014\u001a\u0004\u0018\u00010\u0015*\u00020\u0016H\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/JavaMapForEachInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractApplicabilityBasedInspection;", "Lorg/jetbrains/kotlin/psi/KtDotQualifiedExpression;", "()V", "defaultFixText", "", "getDefaultFixText", "()Ljava/lang/String;", "applyTo", "", "element", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "inspectionHighlightRangeInElement", "Lcom/intellij/openapi/util/TextRange;", "inspectionText", "isApplicable", "", "lambda", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "idea"})
public final class JavaMapForEachInspection
extends AbstractApplicabilityBasedInspection<KtDotQualifiedExpression> {
    @NotNull
    private final String defaultFixText = KotlinBundle.message("replace.with.kotlin.s.foreach", new Object[0]);

    @Override
    public boolean isApplicable(@NotNull KtDotQualifiedExpression element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        KtCallExpression ktCallExpression = UtilsKt.getCallExpression(element3);
        if (ktCallExpression == null) {
            return false;
        }
        KtCallExpression callExpression2 = ktCallExpression;
        KtExpression ktExpression = callExpression2.getCalleeExpression();
        if (ktExpression == null) {
            return false;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"callExpression.calleeExpression ?: return false");
        KtExpression calleeExpression2 = ktExpression;
        if (Intrinsics.areEqual((Object)calleeExpression2.getText(), (Object)"forEach") ^ true) {
            return false;
        }
        KtLambdaExpression ktLambdaExpression = this.lambda(callExpression2);
        if (ktLambdaExpression == null) {
            return false;
        }
        KtLambdaExpression lambda2 = ktLambdaExpression;
        if (lambda2.getValueParameters().size() != 2) {
            return false;
        }
        BindingContext context2 = ResolutionUtils.analyze((KtElement)element3, (BodyResolveMode)BodyResolveMode.PARTIAL);
        if (!FunctionUtilsKt.isMap(CallUtilKt.getType(element3.getReceiverExpression(), context2), DefaultBuiltIns.Companion.getInstance())) {
            return false;
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(callExpression2, context2);
        if (resolvedCall2 == null) {
            return false;
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
        return SyntheticExtensionsUtilsKt.isResolvedWithSamConversions(resolvedCall3);
    }

    @Override
    @Nullable
    public TextRange inspectionHighlightRangeInElement(@NotNull KtDotQualifiedExpression element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        return ExpressionExtKt.calleeTextRangeInThis(element3);
    }

    @Override
    @NotNull
    public String inspectionText(@NotNull KtDotQualifiedExpression element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        return KotlinBundle.message("java.map.foreach.method.call.should.be.replaced.with.kotlin.s.foreach", new Object[0]);
    }

    @Override
    @NotNull
    public String getDefaultFixText() {
        return this.defaultFixText;
    }

    @Override
    public void applyTo(@NotNull KtDotQualifiedExpression element3, @NotNull Project project2, @Nullable Editor editor2) {
        block2: {
            Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
            Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
            KtCallExpression ktCallExpression = UtilsKt.getCallExpression(element3);
            if (ktCallExpression == null) {
                return;
            }
            KtCallExpression call2 = ktCallExpression;
            KtLambdaExpression ktLambdaExpression = this.lambda(call2);
            if (ktLambdaExpression == null) {
                return;
            }
            KtLambdaExpression lambda2 = ktLambdaExpression;
            List<KtParameter> list2 = lambda2.getValueParameters();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"lambda.valueParameters");
            List<KtParameter> valueParameters2 = list2;
            KtFunctionLiteral ktFunctionLiteral = lambda2.getFunctionLiteral();
            Intrinsics.checkExpressionValueIsNotNull((Object)ktFunctionLiteral, (String)"lambda.functionLiteral");
            KtParameterList ktParameterList = ktFunctionLiteral.getValueParameterList();
            if (ktParameterList == null) break block2;
            KtPsiFactory ktPsiFactory = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)call2, false, 2, null);
            StringBuilder stringBuilder2 = new StringBuilder().append('(');
            KtParameter ktParameter = valueParameters2.get(0);
            Intrinsics.checkExpressionValueIsNotNull((Object)ktParameter, (String)"valueParameters[0]");
            StringBuilder stringBuilder3 = stringBuilder2.append(ktParameter.getText()).append(", ");
            KtParameter ktParameter2 = valueParameters2.get(1);
            Intrinsics.checkExpressionValueIsNotNull((Object)ktParameter2, (String)"valueParameters[1]");
            ktParameterList.replace((PsiElement)ktPsiFactory.createLambdaParameterList(stringBuilder3.append(ktParameter2.getText()).append(')').toString()));
        }
    }

    private final KtLambdaExpression lambda(@NotNull KtCallExpression $this$lambda) {
        KtLambdaExpression ktLambdaExpression;
        List<KtLambdaArgument> list2 = $this$lambda.getLambdaArguments();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"lambdaArguments");
        KtLambdaArgument ktLambdaArgument = (KtLambdaArgument)CollectionsKt.singleOrNull(list2);
        KtExpression ktExpression = ktLambdaArgument != null ? ktLambdaArgument.getArgumentExpression() : null;
        if (!(ktExpression instanceof KtLambdaExpression)) {
            ktExpression = null;
        }
        if ((ktLambdaExpression = (KtLambdaExpression)ktExpression) == null) {
            ktLambdaExpression = PsiModificationUtilsKt.getLastLambdaExpression($this$lambda);
        }
        return ktLambdaExpression;
    }

    public JavaMapForEachInspection() {
        super(KtDotQualifiedExpression.class);
    }
}

