/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.inspections.AbstractPrimitiveRangeToInspection;
import org.jetbrains.kotlin.idea.inspections.ReplaceRangeToWithUntilInspectionKt;
import org.jetbrains.kotlin.idea.intentions.ReplaceUntilWithRangeToIntentionKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \t2\u00020\u0001:\u0002\t\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ReplaceRangeToWithUntilInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractPrimitiveRangeToInspection;", "()V", "visitRangeToExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "Companion", "ReplaceWithUntilQuickFix", "idea"})
public final class ReplaceRangeToWithUntilInspection
extends AbstractPrimitiveRangeToInspection {
    public static final Companion Companion = new Companion(null);

    @Override
    public void visitRangeToExpression(@NotNull KtExpression expression2, @NotNull ProblemsHolder holder2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)holder2, (String)"holder");
        if (!ReplaceRangeToWithUntilInspection.Companion.isApplicable(expression2)) {
            return;
        }
        holder2.registerProblem((PsiElement)expression2, KotlinBundle.message("rangeto.or.the.call.should.be.replaced.with.until", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new ReplaceWithUntilQuickFix()});
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ReplaceRangeToWithUntilInspection$ReplaceWithUntilQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "getName", "idea"})
    public static final class ReplaceWithUntilQuickFix
    implements LocalQuickFix {
        @NotNull
        public String getName() {
            return KotlinBundle.message("replace.with.until.quick.fix.text", new Object[0]);
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
            Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            PsiElement psiElement2 = descriptor2.getPsiElement();
            if (psiElement2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
            }
            KtExpression element3 = (KtExpression)psiElement2;
            Companion.applyFix(element3);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u0006H\u0002J\f\u0010\u000b\u001a\u00020\n*\u00020\u0006H\u0002\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ReplaceRangeToWithUntilInspection$Companion;", "", "()V", "applyFix", "", "element", "Lorg/jetbrains/kotlin/psi/KtExpression;", "applyFixIfApplicable", "expression", "isApplicable", "", "isMinusOne", "idea"})
    public static final class Companion {
        public final void applyFixIfApplicable(@NotNull KtExpression expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            if (this.isApplicable(expression2)) {
                this.applyFix(expression2);
            }
        }

        private final boolean isApplicable(KtExpression expression2) {
            Object object = ReplaceUntilWithRangeToIntentionKt.getArguments(expression2);
            return object != null && (object = (KtExpression)object.getSecond()) != null && (object = ReplaceRangeToWithUntilInspectionKt.access$deparenthesize(object)) != null && this.isMinusOne((KtExpression)object);
        }

        private final void applyFix(KtExpression element3) {
            KtExpression ktExpression;
            Pair<KtExpression, KtExpression> pair2 = ReplaceUntilWithRangeToIntentionKt.getArguments(element3);
            if (pair2 == null) {
                return;
            }
            Pair<KtExpression, KtExpression> args = pair2;
            KtPsiFactory ktPsiFactory = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)element3, false, 2, null);
            Object[] objectArray = new Object[2];
            KtExpression ktExpression2 = (KtExpression)args.getFirst();
            if (ktExpression2 == null) {
                return;
            }
            objectArray[0] = ktExpression2;
            KtExpression ktExpression3 = (KtExpression)args.getSecond();
            KtExpression ktExpression4 = ktExpression3 != null ? ReplaceRangeToWithUntilInspectionKt.access$deparenthesize(ktExpression3) : null;
            if (!(ktExpression4 instanceof KtBinaryExpression)) {
                ktExpression4 = null;
            }
            if ((ktExpression = (KtBinaryExpression)ktExpression4) == null || (ktExpression = ktExpression.getLeft()) == null) {
                return;
            }
            objectArray[1] = ktExpression;
            element3.replace((PsiElement)CreateByPatternKt.createExpressionByPattern$default(ktPsiFactory, "$0 until $1", objectArray, false, 4, null));
        }

        private final boolean isMinusOne(@NotNull KtExpression $this$isMinusOne) {
            ConstantValue constantValue;
            if (!($this$isMinusOne instanceof KtBinaryExpression)) {
                return false;
            }
            if (Intrinsics.areEqual((Object)((KtBinaryExpression)$this$isMinusOne).getOperationToken(), (Object)((Object)KtTokens.MINUS)) ^ true) {
                return false;
            }
            KtExpression ktExpression = ((KtBinaryExpression)$this$isMinusOne).getRight();
            ConstantValue constantValue2 = constantValue = ktExpression != null ? AbstractPrimitiveRangeToInspection.Companion.constantValueOrNull$default(AbstractPrimitiveRangeToInspection.Companion, ktExpression, null, 1, null) : null;
            Object object = constantValue2 != null ? constantValue2.getValue() : null;
            if (!(object instanceof Number)) {
                object = null;
            }
            Number number = (Number)object;
            if (number == null) {
                return false;
            }
            int rightValue = number.intValue();
            return rightValue == 1;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

