/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.inspections.ReplaceWithEnumMapInspectionKt;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.idea.util.ImportInsertHelper;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.platform.jvm.JvmPlatformKt;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ReplaceWithEnumMapInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "ReplaceWithEnumMapFix", "idea"})
public final class ReplaceWithEnumMapInspection
extends AbstractKotlinInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder2, boolean isOnTheFly) {
        Intrinsics.checkParameterIsNotNull((Object)holder2, (String)"holder");
        return VisitorWrappersKt.callExpressionVisitor((Function1<? super KtCallExpression, Unit>)((Function1)new Function1<KtCallExpression, Unit>(holder2){
            final /* synthetic */ ProblemsHolder $holder;

            public final void invoke(@NotNull KtCallExpression element3) {
                Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                if (!JvmPlatformKt.isJvm(PlatformKt.getPlatform(element3))) {
                    return;
                }
                BindingContext context2 = ResolutionUtils.analyze$default((KtElement)element3, null, (int)1, null);
                ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(element3, context2);
                if (resolvedCall2 == null || (resolvedCall2 = resolvedCall2.getResultingDescriptor()) == null || (resolvedCall2 = DescriptorUtilsKt.getFqNameUnsafe((DeclarationDescriptor)((Object)resolvedCall2))) == null || (resolvedCall2 = ((FqNameUnsafe)((Object)resolvedCall2)).asString()) == null) {
                    return;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)resolvedCall2, (String)"element.getResolvedCall(\u2026afe?.asString() ?: return");
                ResolvedCall<? extends CallableDescriptor> fqName2 = resolvedCall2;
                if (!ReplaceWithEnumMapInspectionKt.access$getHashMapCreationFqNames$p().contains(fqName2)) {
                    return;
                }
                List<KtValueArgument> list2 = element3.getValueArguments();
                Intrinsics.checkExpressionValueIsNotNull(list2, (String)"element.valueArguments");
                Collection collection = list2;
                boolean bl = false;
                if (!collection.isEmpty()) {
                    return;
                }
                KotlinType kotlinType = (KotlinType)context2.get(BindingContext.EXPECTED_EXPRESSION_TYPE, element3);
                if (kotlinType == null) {
                    return;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"context[BindingContext.E\u2026_TYPE, element] ?: return");
                KotlinType expectedType = kotlinType;
                Object object = (TypeProjection)CollectionsKt.firstOrNull(expectedType.getArguments());
                if (object == null || (object = object.getType()) == null) {
                    return;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"expectedType.arguments.f\u2026tOrNull()?.type ?: return");
                Object firstArgType = object;
                if (!TypeUtilsKt.isEnum((KotlinType)firstArgType)) {
                    return;
                }
                Object object2 = ((KotlinType)firstArgType).getConstructor().getDeclarationDescriptor();
                if (object2 == null || (object2 = DescriptorUtilsKt.getFqNameUnsafe((DeclarationDescriptor)object2)) == null || (object2 = ((FqNameUnsafe)object2).asString()) == null) {
                    return;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"firstArgType.constructor\u2026afe?.asString() ?: return");
                Object enumClassName = object2;
                this.$holder.registerProblem((PsiElement)element3, KotlinBundle.message("replaceable.with.enummap", new Object[0]), new LocalQuickFix[]{new ReplaceWithEnumMapFix((String)enumClassName)});
            }
            {
                this.$holder = problemsHolder;
                super(1);
            }
        }));
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\u0003H\u0016J\b\u0010\f\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ReplaceWithEnumMapInspection$ReplaceWithEnumMapFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "enumClassName", "", "(Ljava/lang/String;)V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "getName", "idea"})
    private static final class ReplaceWithEnumMapFix
    implements LocalQuickFix {
        private final String enumClassName;

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        @NotNull
        public String getName() {
            return KotlinBundle.message("replace.with.enum.map.fix.text", new Object[0]);
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
            Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            PsiElement psiElement2 = descriptor2.getPsiElement();
            if (!(psiElement2 instanceof KtCallExpression)) {
                psiElement2 = null;
            }
            KtCallExpression ktCallExpression = (KtCallExpression)psiElement2;
            if (ktCallExpression == null) {
                return;
            }
            KtCallExpression call2 = ktCallExpression;
            KtPsiFactory factory2 = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)call2, false, 2, null);
            KtFile ktFile = call2.getContainingKtFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)ktFile, (String)"call.containingKtFile");
            KtFile file2 = ktFile;
            DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)CollectionsKt.firstOrNull((Iterable)ResolutionUtils.resolveImportReference((KtFile)file2, (FqName)new FqName("java.util.EnumMap")));
            if (declarationDescriptor == null) {
                return;
            }
            DeclarationDescriptor enumMapDescriptor = declarationDescriptor;
            ImportInsertHelper importInsertHelper = ImportInsertHelper.Companion.getInstance(project2);
            KtFile ktFile2 = call2.getContainingKtFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)ktFile2, (String)"call.containingKtFile");
            ImportInsertHelper.importDescriptor$default((ImportInsertHelper)importInsertHelper, (KtFile)ktFile2, (DeclarationDescriptor)enumMapDescriptor, (boolean)false, (int)4, null);
            call2.replace((PsiElement)CreateByPatternKt.createExpressionByPattern$default(factory2, "EnumMap($0::class.java)", new Object[]{this.enumClassName}, false, 4, null));
        }

        public ReplaceWithEnumMapFix(@NotNull String enumClassName) {
            Intrinsics.checkParameterIsNotNull((Object)enumClassName, (String)"enumClassName");
            this.enumClassName = enumClassName;
        }
    }
}

