/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\f\u0010\u000f\u001a\u00020\u000e*\u00020\u0005H\u0002R\u001f\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/WrapUnaryOperatorInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "()V", "numberTypes", "", "Lcom/intellij/psi/tree/IElementType;", "kotlin.jvm.PlatformType", "getNumberTypes", "()Ljava/util/List;", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "isUnaryMinusOrPlus", "WrapUnaryOperatorQuickfix", "idea"})
public final class WrapUnaryOperatorInspection
extends AbstractKotlinInspection {
    @NotNull
    private final List<IElementType> numberTypes = CollectionsKt.listOf((Object[])new IElementType[]{KtNodeTypes.INTEGER_CONSTANT, KtNodeTypes.FLOAT_CONSTANT});

    @NotNull
    public final List<IElementType> getNumberTypes() {
        return this.numberTypes;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder2, boolean isOnTheFly) {
        Intrinsics.checkParameterIsNotNull((Object)holder2, (String)"holder");
        return VisitorWrappersKt.prefixExpressionVisitor((Function1<? super KtPrefixExpression, Unit>)((Function1)new Function1<KtPrefixExpression, Unit>(this, holder2){
            final /* synthetic */ WrapUnaryOperatorInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;

            public final void invoke(@NotNull KtPrefixExpression expression2) {
                KtExpression receiverExpression;
                KtExpression baseExpression;
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                IElementType iElementType = expression2.getOperationToken();
                Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"expression.operationToken");
                if (WrapUnaryOperatorInspection.access$isUnaryMinusOrPlus(this.this$0, iElementType) && (baseExpression = expression2.getBaseExpression()) instanceof KtDotQualifiedExpression && (receiverExpression = ((KtDotQualifiedExpression)baseExpression).getReceiverExpression()) instanceof KtConstantExpression) {
                    List<IElementType> list2 = this.this$0.getNumberTypes();
                    ASTNode aSTNode = ((KtConstantExpression)receiverExpression).getNode();
                    Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"receiverExpression.node");
                    if (list2.contains(aSTNode.getElementType())) {
                        this.$holder.registerProblem((PsiElement)expression2, KotlinBundle.message("wrap.unary.operator.quickfix.text", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new WrapUnaryOperatorQuickfix()});
                    }
                }
            }
            {
                this.this$0 = wrapUnaryOperatorInspection;
                this.$holder = problemsHolder;
                super(1);
            }
        }));
    }

    private final boolean isUnaryMinusOrPlus(@NotNull IElementType $this$isUnaryMinusOrPlus) {
        return Intrinsics.areEqual((Object)$this$isUnaryMinusOrPlus, (Object)((Object)KtTokens.MINUS)) || Intrinsics.areEqual((Object)$this$isUnaryMinusOrPlus, (Object)((Object)KtTokens.PLUS));
    }

    public static final /* synthetic */ boolean access$isUnaryMinusOrPlus(WrapUnaryOperatorInspection $this, IElementType $this$access_u24isUnaryMinusOrPlus) {
        return $this.isUnaryMinusOrPlus($this$access_u24isUnaryMinusOrPlus);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/WrapUnaryOperatorInspection$WrapUnaryOperatorQuickfix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "getName", "idea"})
    private static final class WrapUnaryOperatorQuickfix
    implements LocalQuickFix {
        @NotNull
        public String getName() {
            return KotlinBundle.message("wrap.unary.operator.quickfix.text", new Object[0]);
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
            Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            PsiElement psiElement2 = descriptor2.getPsiElement();
            if (!(psiElement2 instanceof KtPrefixExpression)) {
                psiElement2 = null;
            }
            KtPrefixExpression ktPrefixExpression = (KtPrefixExpression)psiElement2;
            if (ktPrefixExpression == null) {
                return;
            }
            KtPrefixExpression expression2 = ktPrefixExpression;
            KtExpression ktExpression = expression2.getBaseExpression();
            if (!(ktExpression instanceof KtDotQualifiedExpression)) {
                ktExpression = null;
            }
            KtDotQualifiedExpression ktDotQualifiedExpression = (KtDotQualifiedExpression)ktExpression;
            if (ktDotQualifiedExpression == null) {
                return;
            }
            KtDotQualifiedExpression dotQualifiedExpression = ktDotQualifiedExpression;
            KtPsiFactory factory2 = new KtPsiFactory(project2, false, 2, null);
            Object[] objectArray = new Object[2];
            KtSimpleNameExpression ktSimpleNameExpression = expression2.getOperationReference();
            Intrinsics.checkExpressionValueIsNotNull((Object)ktSimpleNameExpression, (String)"expression.operationReference");
            String string = ktSimpleNameExpression.getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"expression.operationReference.text");
            objectArray[0] = string;
            objectArray[1] = UtilsKt.getLeftMostReceiverExpression(dotQualifiedExpression);
            KtExpression newReceiver = CreateByPatternKt.createExpressionByPattern$default(factory2, "($0$1)", objectArray, false, 4, null);
            KtExpression newExpression2 = UtilsKt.replaceFirstReceiver$default(dotQualifiedExpression, factory2, newReceiver, false, 4, null);
            expression2.replace((PsiElement)newExpression2);
        }
    }
}

