/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.project;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.compiler.IDELanguageSettingsProviderKt;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.idea.project.ProjectStructureUtil;
import org.jetbrains.kotlin.platform.CommonPlatforms;
import org.jetbrains.kotlin.platform.DefaultIdeTargetPlatformKindProvider;
import org.jetbrains.kotlin.platform.SimplePlatform;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.TargetPlatformVersion;
import org.jetbrains.kotlin.platform.jvm.JvmPlatforms;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.scripting.definitions.DefinitionsKt;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinition;

public class TargetPlatformDetector {
    public static final TargetPlatformDetector INSTANCE = new TargetPlatformDetector();
    private static final Logger LOG = Logger.getInstance(TargetPlatformDetector.class);

    private TargetPlatformDetector() {
    }

    @NotNull
    public static TargetPlatform getPlatform(@NotNull KtFile file2) {
        Module moduleForFile;
        KtFile contextFile;
        TargetPlatform explicitPlatform;
        if (file2 == null) {
            TargetPlatformDetector.$$$reportNull$$$1(0);
        }
        if (file2 == null) {
            TargetPlatformDetector.$$$reportNull$$$0(0);
        }
        if ((explicitPlatform = PlatformKt.getForcedTargetPlatform(file2)) != null) {
            TargetPlatform targetPlatform = explicitPlatform;
            if (targetPlatform == null) {
                TargetPlatformDetector.$$$reportNull$$$0(1);
            }
            if (targetPlatform == null) {
                TargetPlatformDetector.$$$reportNull$$$1(1);
            }
            return targetPlatform;
        }
        if (file2 instanceof KtCodeFragment && (contextFile = ((KtCodeFragment)file2).getContextContainingFile()) != null) {
            return TargetPlatformDetector.getPlatform(contextFile);
        }
        PsiElement context2 = KtPsiFactoryKt.getAnalysisContext(file2);
        if (context2 != null) {
            PsiFile contextFile2 = context2.getContainingFile();
            TargetPlatform targetPlatform = contextFile2 instanceof KtFile ? TargetPlatformDetector.getPlatform((KtFile)contextFile2) : JvmPlatforms.INSTANCE.getUnspecifiedJvmPlatform();
            if (targetPlatform == null) {
                TargetPlatformDetector.$$$reportNull$$$0(2);
            }
            if (targetPlatform == null) {
                TargetPlatformDetector.$$$reportNull$$$1(2);
            }
            return targetPlatform;
        }
        ScriptDefinition scriptDefinition = (ScriptDefinition)ReadAction.compute(() -> file2.isScript() ? DefinitionsKt.findScriptDefinition((PsiFile)file2) : null);
        if (scriptDefinition != null) {
            return TargetPlatformDetector.getPlatform(file2.getProject(), scriptDefinition);
        }
        VirtualFile virtualFile2 = file2.getOriginalFile().getVirtualFile();
        if (virtualFile2 != null && (moduleForFile = ProjectFileIndex.SERVICE.getInstance((Project)file2.getProject()).getModuleForFile(virtualFile2)) != null) {
            return TargetPlatformDetector.getPlatform(moduleForFile);
        }
        TargetPlatform targetPlatform = DefaultIdeTargetPlatformKindProvider.Companion.getDefaultPlatform();
        if (targetPlatform == null) {
            TargetPlatformDetector.$$$reportNull$$$0(3);
        }
        if (targetPlatform == null) {
            TargetPlatformDetector.$$$reportNull$$$1(3);
        }
        return targetPlatform;
    }

    @NotNull
    public static TargetPlatform getPlatform(@NotNull Module module) {
        if (module == null) {
            TargetPlatformDetector.$$$reportNull$$$1(4);
        }
        if (module == null) {
            TargetPlatformDetector.$$$reportNull$$$0(4);
        }
        TargetPlatform targetPlatform = ProjectStructureUtil.getCachedPlatformForModule(module);
        if (targetPlatform == null) {
            TargetPlatformDetector.$$$reportNull$$$0(5);
        }
        if (targetPlatform == null) {
            TargetPlatformDetector.$$$reportNull$$$1(5);
        }
        return targetPlatform;
    }

    @NotNull
    public static TargetPlatform getPlatform(@NotNull Project project2, @NotNull ScriptDefinition scriptDefinition) {
        SimplePlatform simplePlatform;
        if (project2 == null) {
            TargetPlatformDetector.$$$reportNull$$$1(6);
        }
        if (scriptDefinition == null) {
            TargetPlatformDetector.$$$reportNull$$$1(7);
        }
        if (project2 == null) {
            TargetPlatformDetector.$$$reportNull$$$0(6);
        }
        if (scriptDefinition == null) {
            TargetPlatformDetector.$$$reportNull$$$0(7);
        }
        String platformNameFromScriptDefinition = scriptDefinition.getPlatform();
        TargetPlatformVersion targetPlatformVersion = IDELanguageSettingsProviderKt.getTargetPlatformVersionForScripts(project2, scriptDefinition);
        if (!targetPlatformVersion.equals(TargetPlatformVersion.NoVersion.INSTANCE)) {
            for (TargetPlatform compilerPlatform : CommonPlatforms.INSTANCE.getAllSimplePlatforms()) {
                simplePlatform = (SimplePlatform)CollectionsKt.single((Iterable)compilerPlatform);
                if (simplePlatform.getTargetPlatformVersion() != targetPlatformVersion) continue;
                TargetPlatform targetPlatform = compilerPlatform;
                if (targetPlatform == null) {
                    TargetPlatformDetector.$$$reportNull$$$0(8);
                }
                if (targetPlatform == null) {
                    TargetPlatformDetector.$$$reportNull$$$1(8);
                }
                return targetPlatform;
            }
        }
        for (TargetPlatform compilerPlatform : CommonPlatforms.INSTANCE.getAllSimplePlatforms()) {
            simplePlatform = (SimplePlatform)CollectionsKt.single((Iterable)compilerPlatform);
            if (!simplePlatform.getPlatformName().equals(platformNameFromScriptDefinition)) continue;
            TargetPlatform targetPlatform = compilerPlatform;
            if (targetPlatform == null) {
                TargetPlatformDetector.$$$reportNull$$$0(9);
            }
            if (targetPlatform == null) {
                TargetPlatformDetector.$$$reportNull$$$1(9);
            }
            return targetPlatform;
        }
        TargetPlatform targetPlatform = DefaultIdeTargetPlatformKindProvider.Companion.getDefaultPlatform();
        if (targetPlatform == null) {
            TargetPlatformDetector.$$$reportNull$$$0(10);
        }
        if (targetPlatform == null) {
            TargetPlatformDetector.$$$reportNull$$$1(10);
        }
        return targetPlatform;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/idea/project/TargetPlatformDetector";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptDefinition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/idea/project/TargetPlatformDetector";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlatform";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPlatform";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static /* synthetic */ void $$$reportNull$$$1(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/idea/project/TargetPlatformDetector";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptDefinition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/idea/project/TargetPlatformDetector";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlatform";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPlatform";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

