/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.intentions.branchedTransformations.BranchedTransformationUtilsKt;
import org.jetbrains.kotlin.idea.quickfix.CleanupFix;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtWhenCondition;
import org.jetbrains.kotlin.psi.KtWhenConditionWithExpression;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00112\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001\u0011B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0016J#\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0094\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/CommaInWhenConditionWithoutArgumentFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lcom/intellij/psi/PsiElement;", "Lorg/jetbrains/kotlin/idea/quickfix/CleanupFix;", "element", "(Lcom/intellij/psi/PsiElement;)V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "Companion", "idea"})
public final class CommaInWhenConditionWithoutArgumentFix
extends KotlinQuickFixAction<PsiElement>
implements CleanupFix {
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @NotNull
    public String getText() {
        return KotlinBundle.message("replace.with.in.when", new Object[0]);
    }

    @Override
    protected void invoke(@NotNull Project project2, @Nullable Editor editor2, @NotNull KtFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Object t = this.getElement();
        if (!(t instanceof KtWhenExpression)) {
            t = null;
        }
        KtWhenExpression ktWhenExpression = (KtWhenExpression)t;
        if (ktWhenExpression == null) {
            return;
        }
        KtWhenExpression whenExpression2 = ktWhenExpression;
        CommaInWhenConditionWithoutArgumentFix.Companion.replaceCommasWithOrsInWhenExpression(whenExpression2);
    }

    public CommaInWhenConditionWithoutArgumentFix(@NotNull PsiElement element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        super(element3);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u000fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/CommaInWhenConditionWithoutArgumentFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "getConditionsDataOrNull", "Lorg/jetbrains/kotlin/idea/quickfix/CommaInWhenConditionWithoutArgumentFix$Companion$WhenEntryConditionsData;", "whenEntry", "Lorg/jetbrains/kotlin/psi/KtWhenEntry;", "replaceCommasWithOrsInWhenExpression", "", "whenExpression", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "WhenEntryConditionsData", "idea"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactory {
        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            CommaInWhenConditionWithoutArgumentFix commaInWhenConditionWithoutArgumentFix;
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            PsiElement psiElement2 = diagnostic.getPsiElement();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"diagnostic.psiElement");
            PsiElement psiElement3 = psiElement2.getParent();
            if (psiElement3 != null && (psiElement3 = psiElement3.getParent()) != null) {
                PsiElement psiElement4 = psiElement3;
                boolean bl = false;
                boolean bl2 = false;
                PsiElement p1 = psiElement4;
                boolean bl3 = false;
                commaInWhenConditionWithoutArgumentFix = new CommaInWhenConditionWithoutArgumentFix(p1);
            } else {
                commaInWhenConditionWithoutArgumentFix = null;
            }
            return commaInWhenConditionWithoutArgumentFix;
        }

        private final void replaceCommasWithOrsInWhenExpression(KtWhenExpression whenExpression2) {
            Iterator<KtWhenEntry> iterator2 = whenExpression2.getEntries().iterator();
            while (iterator2.hasNext()) {
                KtExpression replacement2;
                WhenEntryConditionsData conditionsData;
                KtWhenEntry whenEntry;
                KtWhenEntry ktWhenEntry = whenEntry = iterator2.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)ktWhenEntry, (String)"whenEntry");
                if (ktWhenEntry.getConditions().length <= 1) continue;
                if (this.getConditionsDataOrNull(whenEntry) == null) {
                    return;
                }
                if (BranchedTransformationUtilsKt.combineWhenConditions(KtPsiFactoryKt.KtPsiFactory$default((PsiElement)whenEntry, false, 2, null), conditionsData.getConditions(), null) == null) {
                    return;
                }
                whenEntry.deleteChildRange(conditionsData.getFirst(), conditionsData.getLast());
                whenEntry.addBefore((PsiElement)replacement2, conditionsData.getArrow());
            }
        }

        private final WhenEntryConditionsData getConditionsDataOrNull(KtWhenEntry whenEntry) {
            WhenEntryConditionsData whenEntryConditionsData;
            PsiElement last;
            PsiElement child;
            ArrayList<PsiElement> conditions2 = new ArrayList<PsiElement>();
            PsiElement arrow = null;
            for (child = whenEntry.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child instanceof KtWhenConditionWithExpression) {
                    conditions2.add(child);
                    continue;
                }
                ASTNode aSTNode = child.getNode();
                Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"child.node");
                if (!Intrinsics.areEqual((Object)aSTNode.getElementType(), (Object)((Object)KtTokens.ARROW))) continue;
                arrow = child;
                break;
            }
            PsiElement psiElement2 = child;
            Object object = last = psiElement2 != null ? psiElement2.getPrevSibling() : null;
            if (arrow != null && last != null) {
                Collection $this$toTypedArray$iv = conditions2;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                KtWhenCondition[] ktWhenConditionArray = thisCollection$iv.toArray(new KtWhenCondition[0]);
                if (ktWhenConditionArray == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                KtWhenCondition[] ktWhenConditionArray2 = ktWhenConditionArray;
                PsiElement psiElement3 = whenEntry.getFirstChild();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"whenEntry.firstChild");
                PsiElement psiElement4 = arrow;
                PsiElement psiElement5 = last;
                PsiElement psiElement6 = psiElement3;
                KtWhenCondition[] ktWhenConditionArray3 = ktWhenConditionArray2;
                whenEntryConditionsData = new WhenEntryConditionsData(ktWhenConditionArray3, psiElement6, psiElement5, psiElement4);
            } else {
                whenEntryConditionsData = null;
            }
            return whenEntryConditionsData;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0002\u0018\u00002\u00020\u0001B+\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\tR\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0019\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000b\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/CommaInWhenConditionWithoutArgumentFix$Companion$WhenEntryConditionsData;", "", "conditions", "", "Lorg/jetbrains/kotlin/psi/KtWhenCondition;", "first", "Lcom/intellij/psi/PsiElement;", "last", "arrow", "([Lorg/jetbrains/kotlin/psi/KtWhenCondition;Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/PsiElement;)V", "getArrow", "()Lcom/intellij/psi/PsiElement;", "getConditions", "()[Lorg/jetbrains/kotlin/psi/KtWhenCondition;", "[Lorg/jetbrains/kotlin/psi/KtWhenCondition;", "getFirst", "getLast", "idea"})
        private static final class WhenEntryConditionsData {
            @NotNull
            private final KtWhenCondition[] conditions;
            @NotNull
            private final PsiElement first;
            @NotNull
            private final PsiElement last;
            @NotNull
            private final PsiElement arrow;

            @NotNull
            public final KtWhenCondition[] getConditions() {
                return this.conditions;
            }

            @NotNull
            public final PsiElement getFirst() {
                return this.first;
            }

            @NotNull
            public final PsiElement getLast() {
                return this.last;
            }

            @NotNull
            public final PsiElement getArrow() {
                return this.arrow;
            }

            public WhenEntryConditionsData(@NotNull KtWhenCondition[] conditions2, @NotNull PsiElement first2, @NotNull PsiElement last, @NotNull PsiElement arrow) {
                Intrinsics.checkParameterIsNotNull((Object)conditions2, (String)"conditions");
                Intrinsics.checkParameterIsNotNull((Object)first2, (String)"first");
                Intrinsics.checkParameterIsNotNull((Object)last, (String)"last");
                Intrinsics.checkParameterIsNotNull((Object)arrow, (String)"arrow");
                this.conditions = conditions2;
                this.first = first2;
                this.last = last;
                this.arrow = arrow;
            }
        }
    }
}

