/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPsiFactory;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00102\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0010B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016J#\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0094\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/RenameToUnderscoreFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "element", "(Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;)V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "Factory", "idea"})
public final class RenameToUnderscoreFix
extends KotlinQuickFixAction<KtCallableDeclaration> {
    public static final Factory Factory = new Factory(null);

    @NotNull
    public String getText() {
        return KotlinBundle.message("rename.to.underscore", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @Override
    protected void invoke(@NotNull Project project2, @Nullable Editor editor2, @NotNull KtFile file2) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            KtCallableDeclaration ktCallableDeclaration = (KtCallableDeclaration)this.getElement();
            if (ktCallableDeclaration == null || (ktCallableDeclaration = ktCallableDeclaration.getNameIdentifier()) == null) break block0;
            ktCallableDeclaration.replace(new KtPsiFactory(project2, false, 2, null).createIdentifier("_"));
        }
    }

    public RenameToUnderscoreFix(@NotNull KtCallableDeclaration element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        super((PsiElement)element3);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/RenameToUnderscoreFix$Factory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "idea"})
    public static final class Factory
    extends KotlinSingleIntentionActionFactory {
        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            KtCallableDeclaration declaration2;
            KtCallableDeclaration ktCallableDeclaration;
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            DiagnosticFactory<?> diagnosticFactory = diagnostic.getFactory();
            if (Intrinsics.areEqual(diagnosticFactory, Errors.UNUSED_ANONYMOUS_PARAMETER)) {
                KtParameter parameter;
                KtParameter ktParameter;
                PsiElement psiElement2 = diagnostic.getPsiElement();
                if (!(psiElement2 instanceof KtParameter)) {
                    psiElement2 = null;
                }
                PsiElement owner = (ktParameter = (parameter = (KtParameter)psiElement2)) != null && (ktParameter = ktParameter.getParent()) != null ? ktParameter.getParent() : null;
                ktCallableDeclaration = owner instanceof KtFunctionLiteral || owner instanceof KtNamedFunction && ((KtNamedFunction)owner).getName() == null ? parameter : null;
            } else if (Intrinsics.areEqual(diagnosticFactory, Errors.UNUSED_VARIABLE) || Intrinsics.areEqual(diagnosticFactory, Errors.UNUSED_DESTRUCTURED_PARAMETER_ENTRY)) {
                PsiElement psiElement3 = diagnostic.getPsiElement();
                if (!(psiElement3 instanceof KtDestructuringDeclarationEntry)) {
                    psiElement3 = null;
                }
                ktCallableDeclaration = (KtDestructuringDeclarationEntry)psiElement3;
            } else {
                ktCallableDeclaration = null;
            }
            KtCallableDeclaration ktCallableDeclaration2 = declaration2 = ktCallableDeclaration;
            if ((ktCallableDeclaration2 != null ? ktCallableDeclaration2.getNameIdentifier() : null) == null || !PlatformKt.getLanguageVersionSettings(declaration2).supportsFeature(LanguageFeature.SingleUnderscoreForParameterName)) {
                return null;
            }
            return new RenameToUnderscoreFix(declaration2);
        }

        private Factory() {
        }

        public /* synthetic */ Factory(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

