/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.ui;

import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPackage;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.MoveDestination;
import com.intellij.refactoring.PackageWrapper;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.moveClassesOrPackages.AutocreatingSingleSourceRootMoveDestination;
import com.intellij.refactoring.move.moveClassesOrPackages.MultipleRootsMoveDestination;
import com.intellij.util.IncorrectOperationException;
import java.io.File;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.core.util.PhysicalFileSystemUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.idea.refactoring.move.MoveUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.KotlinAwareMoveFilesOrDirectoriesProcessor;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.KotlinMoveTarget;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.KotlinMoveTargetForDeferredFile;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.KotlinMoveTargetForExistingElement;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.MoveDeclarationsDelegate;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.MoveDeclarationsDescriptor;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.MoveKotlinDeclarationsProcessor;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.MoveKotlinDeclarationsProcessorKt;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.MoveToKotlinFileProcessor;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.Mover;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.ui.Model;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.ui.MoveKotlinTopLevelDeclarationsModel;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001@B\u007f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\t\u0012\u0006\u0010\r\u001a\u00020\t\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u000f\u0012\u0006\u0010\u0011\u001a\u00020\u000f\u0012\u0006\u0010\u0012\u001a\u00020\u000f\u0012\u0006\u0010\u0013\u001a\u00020\u000f\u0012\u0006\u0010\u0014\u001a\u00020\u000f\u0012\u0006\u0010\u0015\u001a\u00020\u000f\u0012\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017\u00a2\u0006\u0002\u0010\u0018J\u0010\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\tH\u0002J\b\u00103\u001a\u00020\u0002H\u0016J\u0010\u00103\u001a\u00020\u00022\u0006\u00104\u001a\u00020\u000fH\u0016J\"\u00105\u001a\b\u0012\u0004\u0012\u0002060\u00062\b\u00107\u001a\u0004\u0018\u00010\t2\b\u00108\u001a\u0004\u0018\u00010\u000bH\u0002J\b\u00109\u001a\u00020-H\u0002J\b\u0010:\u001a\u00020-H\u0002J\b\u0010;\u001a\u00020-H\u0002J\b\u0010<\u001a\u00020=H\u0002J\u0010\u0010>\u001a\u0002012\u0006\u0010?\u001a\u00020-H\u0002R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\f\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0013\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u001dR\u0011\u0010\u0015\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u001dR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u001dR\u0011\u0010\u0011\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u001dR\u0011\u0010\u0012\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u001dR\u0011\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u001dR\u0011\u0010\u0014\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u001dR\u0013\u0010\u0016\u001a\u0004\u0018\u00010\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u001b\u0010$\u001a\u00020\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b&\u0010'\u001a\u0004\b%\u0010#R\u0014\u0010(\u001a\b\u0012\u0004\u0012\u00020)0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010\u001cR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010\u001cR\u0014\u0010,\u001a\u00020-8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010/\u00a8\u0006A"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/ui/MoveKotlinTopLevelDeclarationsModel;", "Lorg/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/ui/Model;", "Lcom/intellij/refactoring/BaseRefactoringProcessor;", "project", "Lcom/intellij/openapi/project/Project;", "elementsToMove", "", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "targetPackage", "", "selectedPsiDirectory", "Lcom/intellij/psi/PsiDirectory;", "fileNameInPackage", "targetFilePath", "isMoveToPackage", "", "isSearchReferences", "isSearchInComments", "isSearchInNonJavaFiles", "isDeleteEmptyFiles", "isUpdatePackageDirective", "isFullFileMove", "moveCallback", "Lcom/intellij/refactoring/move/MoveCallback;", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;Ljava/lang/String;Lcom/intellij/psi/PsiDirectory;Ljava/lang/String;Ljava/lang/String;ZZZZZZZLcom/intellij/refactoring/move/MoveCallback;)V", "getElementsToMove", "()Ljava/util/List;", "getFileNameInPackage", "()Ljava/lang/String;", "()Z", "getMoveCallback", "()Lcom/intellij/refactoring/move/MoveCallback;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getSelectedPsiDirectory", "()Lcom/intellij/psi/PsiDirectory;", "sourceDirectory", "getSourceDirectory", "sourceDirectory$delegate", "Lkotlin/Lazy;", "sourceFiles", "Lorg/jetbrains/kotlin/psi/KtFile;", "getTargetFilePath", "getTargetPackage", "verifiedMoveTarget", "Lorg/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/KotlinMoveTarget;", "getVerifiedMoveTarget", "()Lorg/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/KotlinMoveTarget;", "checkTargetFileName", "", "fileName", "computeModelResult", "throwOnConflicts", "getFilesExistingInTargetDir", "Lcom/intellij/psi/PsiFile;", "targetFileName", "targetDirectory", "selectMoveTarget", "selectMoveTargetToFile", "selectMoveTargetToPackage", "selectPackageBasedTargetDirAndDestination", "Lorg/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/ui/MoveKotlinTopLevelDeclarationsModel$TargetDirAndDestination;", "verifyBeforeRun", "target", "TargetDirAndDestination", "idea"})
public final class MoveKotlinTopLevelDeclarationsModel
implements Model<BaseRefactoringProcessor> {
    private final Lazy sourceDirectory$delegate;
    private final List<KtFile> sourceFiles;
    @NotNull
    private final Project project;
    @NotNull
    private final List<KtNamedDeclaration> elementsToMove;
    @NotNull
    private final String targetPackage;
    @Nullable
    private final PsiDirectory selectedPsiDirectory;
    @NotNull
    private final String fileNameInPackage;
    @NotNull
    private final String targetFilePath;
    private final boolean isMoveToPackage;
    private final boolean isSearchReferences;
    private final boolean isSearchInComments;
    private final boolean isSearchInNonJavaFiles;
    private final boolean isDeleteEmptyFiles;
    private final boolean isUpdatePackageDirective;
    private final boolean isFullFileMove;
    @Nullable
    private final MoveCallback moveCallback;

    private final PsiDirectory getSourceDirectory() {
        Lazy lazy = this.sourceDirectory$delegate;
        MoveKotlinTopLevelDeclarationsModel moveKotlinTopLevelDeclarationsModel = this;
        Object var3_3 = null;
        boolean bl = false;
        return (PsiDirectory)lazy.getValue();
    }

    private final TargetDirAndDestination selectPackageBasedTargetDirAndDestination() {
        PackageWrapper targetPackageWrapper = new PackageWrapper(PsiManager.getInstance((Project)this.project), this.targetPackage);
        return this.selectedPsiDirectory == null ? new TargetDirAndDestination(null, (MoveDestination)new MultipleRootsMoveDestination(targetPackageWrapper)) : new TargetDirAndDestination(this.selectedPsiDirectory.getVirtualFile(), (MoveDestination)new AutocreatingSingleSourceRootMoveDestination(targetPackageWrapper, this.selectedPsiDirectory.getVirtualFile()));
    }

    private final void checkTargetFileName(String fileName) {
        if (Intrinsics.areEqual((Object)FileTypeManager.getInstance().getFileTypeByFileName(fileName), (Object)((Object)KotlinFileType.INSTANCE)) ^ true) {
            throw (Throwable)new ConfigurationException(KotlinBundle.message("refactoring.move.non.kotlin.file", new Object[0]));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<PsiFile> getFilesExistingInTargetDir(String targetFileName, PsiDirectory targetDirectory2) {
        void $this$mapNotNullTo$iv$iv;
        Object object;
        Collection destination$iv$iv;
        Object object2;
        block7: {
            void $this$mapTo$iv$iv;
            block6: {
                if (targetDirectory2 == null) {
                    return CollectionsKt.emptyList();
                }
                object2 = targetFileName;
                if (object2 == null) break block6;
                String string = object2;
                boolean bl = false;
                boolean bl2 = false;
                String it = string;
                boolean bl3 = false;
                object2 = CollectionsKt.listOf((Object)it);
                if (object2 != null) break block7;
            }
            Iterable $this$map$iv = this.sourceFiles;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                object = (KtFile)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                void v1 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
                String string = v1.getName();
                collection.add(string);
            }
            object2 = (List)destination$iv$iv;
        }
        Object fileNames = object2;
        Iterable $this$mapNotNull$iv = CollectionsKt.distinct((Iterable)((Iterable)fileNames));
        boolean $i$f$mapNotNull = false;
        Iterable $this$mapTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        object = $this$forEach$iv$iv$iv.iterator();
        while (object.hasNext()) {
            PsiFile psiFile2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = object.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl4 = false;
            if (targetDirectory2.findFile(it) == null) continue;
            boolean bl5 = false;
            boolean bl6 = false;
            PsiFile it$iv$iv = psiFile2;
            boolean bl7 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final KotlinMoveTarget selectMoveTargetToPackage() {
        void targetDir;
        if (this.sourceFiles.size() > 1) {
            throw (Throwable)new ConfigurationException(KotlinBundle.message("text.cannot.move.from.multiple.files", new Object[0]));
        }
        this.checkTargetFileName(this.fileNameInPackage);
        TargetDirAndDestination targetDirAndDestination = this.selectPackageBasedTargetDirAndDestination();
        VirtualFile virtualFile2 = targetDirAndDestination.component1();
        MoveDestination moveDestination = targetDirAndDestination.component2();
        PsiDirectory targetDirectory2 = moveDestination.getTargetIfExists(this.getSourceDirectory());
        List<PsiFile> filesExistingInTargetDir = this.getFilesExistingInTargetDir(this.fileNameInPackage, targetDirectory2);
        Object object = filesExistingInTargetDir;
        boolean bl = false;
        if (!object.isEmpty()) {
            if (filesExistingInTargetDir.size() > 1) {
                String filePathsToReport2 = KotlinBundle.message("text.move.refactoring.conflict.0", CollectionsKt.joinToString$default((Iterable)filesExistingInTargetDir, (CharSequence)"\n", null, null, (int)0, null, (Function1)selectMoveTargetToPackage.filePathsToReport.1.INSTANCE, (int)30, null));
                throw (Throwable)new ConfigurationException(filePathsToReport2);
            }
            PsiFile psiFile2 = filesExistingInTargetDir.get(0);
            if (!(psiFile2 instanceof KtFile)) {
                psiFile2 = null;
            }
            KtFile ktFile = (KtFile)psiFile2;
            if (ktFile != null) {
                object = ktFile;
                bl = false;
                boolean bl2 = false;
                Object it = object;
                boolean bl3 = false;
                return new KotlinMoveTargetForExistingElement((KtElement)it);
            }
        }
        return new KotlinMoveTargetForDeferredFile(new FqName(this.targetPackage), moveDestination.getTargetIfExists((PsiFile)this.sourceFiles.get(0)), (VirtualFile)targetDir, (Function1<? super KtFile, ? extends KtFile>)((Function1)new Function1<KtFile, KtFile>(this, moveDestination){
            final /* synthetic */ MoveKotlinTopLevelDeclarationsModel this$0;
            final /* synthetic */ MoveDestination $moveDestination;

            @Nullable
            public final KtFile invoke(@NotNull KtFile it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                String string = this.this$0.getFileNameInPackage();
                PsiDirectory psiDirectory = this.$moveDestination.getTargetDirectory((PsiFile)it);
                Intrinsics.checkExpressionValueIsNotNull((Object)psiDirectory, (String)"moveDestination.getTargetDirectory(it)");
                return KotlinRefactoringUtilKt.getOrCreateKotlinFile$default(string, psiDirectory, null, 4, null);
            }
            {
                this.this$0 = moveKotlinTopLevelDeclarationsModel;
                this.$moveDestination = moveDestination;
                super(1);
            }
        }));
    }

    private final KotlinMoveTarget selectMoveTargetToFile() {
        KtFile jetFile;
        try {
            Paths.get(this.targetFilePath, new String[0]);
        }
        catch (InvalidPathException e) {
            throw (Throwable)new ConfigurationException(KotlinBundle.message("text.invalid.target.path.0", this.targetFilePath));
        }
        File targetFile2 = new File(this.targetFilePath);
        String string = targetFile2.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"targetFile.name");
        this.checkTargetFileName(string);
        PsiFile psiFile2 = PhysicalFileSystemUtilsKt.toPsiFile(targetFile2, this.project);
        if (!(psiFile2 instanceof KtFile)) {
            psiFile2 = null;
        }
        if ((jetFile = (KtFile)psiFile2) != null) {
            if (this.sourceFiles.size() == 1 && this.sourceFiles.contains(jetFile)) {
                throw (Throwable)new ConfigurationException(KotlinBundle.message("text.cannot.move.to.original.file", new Object[0]));
            }
            return new KotlinMoveTargetForExistingElement(jetFile);
        }
        Path path2 = targetFile2.toPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"targetFile.toPath()");
        Path targetDirPath = path2.getParent();
        String string2 = this.project.getBasePath();
        if (string2 == null) {
            throw (Throwable)new ConfigurationException(KotlinBundle.message("text.cannot.move.for.current.project", new Object[0]));
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"project.basePath ?: thro\u2026ve.for.current.project\"))");
        String projectBasePath = string2;
        if (targetDirPath == null || !targetDirPath.startsWith(projectBasePath)) {
            Object[] objectArray = new Object[1];
            Path path3 = targetDirPath;
            Intrinsics.checkExpressionValueIsNotNull((Object)path3, (String)"targetDirPath");
            objectArray[0] = path3;
            throw (Throwable)new ConfigurationException(KotlinBundle.message("text.incorrect.target.path.directory.0.does.not.belong.to.current.project", objectArray));
        }
        String absoluteTargetDirPath = ((Object)targetDirPath).toString();
        PsiDirectory psiDirectory = null;
        try {
            psiDirectory = MoveUtilsKt.getOrCreateDirectory(absoluteTargetDirPath, this.project);
        }
        catch (IncorrectOperationException e) {
            throw (Throwable)new ConfigurationException(KotlinBundle.message("text.failed.to.create.parent.directory.0", absoluteTargetDirPath));
        }
        Object object = (KtFile)CollectionsKt.singleOrNull(this.sourceFiles);
        if (object == null || (object = ((KtFile)object).getPackageFqName()) == null) {
            PsiPackage psiPackage = JavaDirectoryService.getInstance().getPackage(psiDirectory);
            if (psiPackage != null) {
                PsiPackage psiPackage2 = psiPackage;
                boolean bl = false;
                boolean bl2 = false;
                PsiPackage it = psiPackage2;
                boolean bl3 = false;
                PsiPackage psiPackage3 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)psiPackage3, (String)"it");
                object = new FqName(psiPackage3.getQualifiedName());
            } else {
                object = null;
            }
        }
        if (object == null) {
            throw (Throwable)new ConfigurationException(KotlinBundle.message("text.cannot.find.package.corresponding.to.0", absoluteTargetDirPath));
        }
        Object targetPackageFqName = object;
        String string3 = ((FqName)targetPackageFqName).asString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"targetPackageFqName.asString()");
        String finalTargetPackageFqName = string3;
        return new KotlinMoveTargetForDeferredFile((FqName)targetPackageFqName, psiDirectory, null, (Function1<? super KtFile, ? extends KtFile>)((Function1)new Function1<KtFile, KtFile>(targetFile2, psiDirectory, finalTargetPackageFqName){
            final /* synthetic */ File $targetFile;
            final /* synthetic */ PsiDirectory $psiDirectory;
            final /* synthetic */ String $finalTargetPackageFqName;

            @Nullable
            public final KtFile invoke(@NotNull KtFile it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                String string = this.$targetFile.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"targetFile.name");
                return KotlinRefactoringUtilKt.getOrCreateKotlinFile(string, this.$psiDirectory, this.$finalTargetPackageFqName);
            }
            {
                this.$targetFile = file2;
                this.$psiDirectory = psiDirectory;
                this.$finalTargetPackageFqName = string;
                super(1);
            }
        }));
    }

    private final KotlinMoveTarget selectMoveTarget() {
        return this.isMoveToPackage ? this.selectMoveTargetToPackage() : this.selectMoveTargetToFile();
    }

    private final void verifyBeforeRun(KotlinMoveTarget target) {
        if (this.elementsToMove.isEmpty()) {
            throw (Throwable)new ConfigurationException(KotlinBundle.message("text.at.least.one.file.must.be.selected", new Object[0]));
        }
        for (KtNamedDeclaration charSequence : this.elementsToMove) {
            PsiFile psiFile2 = charSequence.getContainingFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiFile2, (String)"element.containingFile");
            String string = target.verify(psiFile2);
            if (string == null) continue;
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            throw (Throwable)new ConfigurationException(it);
        }
        if (this.isMoveToPackage) {
            CharSequence charSequence = this.targetPackage;
            boolean bl = false;
            if (charSequence.length() > 0 && !PsiNameHelper.getInstance((Project)this.project).isQualifiedName(this.targetPackage)) {
                throw (Throwable)new ConfigurationException(KotlinBundle.message("text.0.is.invalid.destination.package", this.targetPackage));
            }
        } else {
            PsiFile psiFile3 = PhysicalFileSystemUtilsKt.toPsiFile(new File(this.targetFilePath), this.project);
            if (psiFile3 != null && !(psiFile3 instanceof KtFile)) {
                throw (Throwable)new ConfigurationException(KotlinBundle.message("refactoring.move.non.kotlin.file", new Object[0]));
            }
        }
        if (this.sourceFiles.size() == 1) {
            CharSequence charSequence = this.fileNameInPackage;
            boolean bl = false;
            if (charSequence.length() == 0) {
                throw (Throwable)new ConfigurationException(KotlinBundle.message("text.file.name.cannot.be.empty", new Object[0]));
            }
        }
    }

    private final KotlinMoveTarget getVerifiedMoveTarget() {
        KotlinMoveTarget kotlinMoveTarget = this.selectMoveTarget();
        boolean bl = false;
        boolean bl2 = false;
        KotlinMoveTarget it = kotlinMoveTarget;
        boolean bl3 = false;
        this.verifyBeforeRun(it);
        return kotlinMoveTarget;
    }

    @Override
    @NotNull
    public BaseRefactoringProcessor computeModelResult() throws ConfigurationException {
        return this.computeModelResult(false);
    }

    @Override
    @NotNull
    public BaseRefactoringProcessor computeModelResult(boolean throwOnConflicts) throws ConfigurationException {
        KotlinMoveTarget target = this.getVerifiedMoveTarget();
        if (this.isFullFileMove && this.isMoveToPackage) {
            TargetDirAndDestination targetDirAndDestination = this.selectPackageBasedTargetDirAndDestination();
            MoveDestination moveDestination = targetDirAndDestination.component2();
            PsiDirectory targetDir = moveDestination.getTargetIfExists(this.getSourceDirectory());
            String targetFileName = this.sourceFiles.size() > 1 ? null : this.fileNameInPackage;
            List<PsiFile> filesExistingInTargetDir = this.getFilesExistingInTargetDir(targetFileName, targetDir);
            if (filesExistingInTargetDir.isEmpty() || filesExistingInTargetDir.size() == 1 && CollectionsKt.contains((Iterable)this.sourceFiles, (Object)filesExistingInTargetDir.get(0))) {
                BaseRefactoringProcessor baseRefactoringProcessor;
                String string = RefactoringBundle.message((String)"move.title");
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"RefactoringBundle.message(\"move.title\")");
                PsiDirectory targetDirectory2 = (PsiDirectory)ApplicationUtilsKt.executeCommand(this.project, string, null, (Function0)new Function0<PsiDirectory>(this, moveDestination){
                    final /* synthetic */ MoveKotlinTopLevelDeclarationsModel this$0;
                    final /* synthetic */ MoveDestination $moveDestination;

                    @NotNull
                    public final PsiDirectory invoke() {
                        return (PsiDirectory)ApplicationUtilsKt.runWriteAction((Function0)new Function0<PsiDirectory>(this){
                            final /* synthetic */ computeModelResult.targetDirectory.1 this$0;

                            public final PsiDirectory invoke() {
                                PsiDirectory psiDirectory = this.this$0.$moveDestination.getTargetDirectory(MoveKotlinTopLevelDeclarationsModel.access$getSourceDirectory$p(this.this$0.this$0));
                                Intrinsics.checkExpressionValueIsNotNull((Object)psiDirectory, (String)"moveDestination.getTarge\u2026irectory(sourceDirectory)");
                                return psiDirectory;
                            }
                            {
                                this.this$0 = var1_1;
                                super(0);
                            }
                        });
                    }
                    {
                        this.this$0 = moveKotlinTopLevelDeclarationsModel;
                        this.$moveDestination = moveDestination;
                        super(0);
                    }
                });
                Iterable $this$forEach$iv = this.sourceFiles;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    KtFile it = (KtFile)element$iv;
                    boolean bl = false;
                    KtFile ktFile = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)ktFile, (String)"it");
                    MoveUtilsKt.setUpdatePackageDirective(ktFile, this.isUpdatePackageDirective);
                }
                if (this.sourceFiles.size() == 1 && targetFileName != null) {
                    KtFile ktFile = this.sourceFiles.get(0);
                    Intrinsics.checkExpressionValueIsNotNull((Object)ktFile, (String)"sourceFiles[0]");
                    baseRefactoringProcessor = (BaseRefactoringProcessor)new MoveToKotlinFileProcessor(this.project, ktFile, targetDirectory2, targetFileName, this.isSearchInComments, this.isSearchInNonJavaFiles, this.moveCallback, null, throwOnConflicts, 128, null);
                } else {
                    baseRefactoringProcessor = (BaseRefactoringProcessor)new KotlinAwareMoveFilesOrDirectoriesProcessor(this.project, this.sourceFiles, targetDirectory2, this.isSearchReferences, this.isSearchInComments, this.isSearchInNonJavaFiles, this.moveCallback, null, throwOnConflicts, 128, null);
                }
                return baseRefactoringProcessor;
            }
        }
        MoveDeclarationsDescriptor options2 = new MoveDeclarationsDescriptor(this.project, MoveKotlinDeclarationsProcessorKt.MoveSource((Collection<? extends KtNamedDeclaration>)this.elementsToMove), target, MoveDeclarationsDelegate.TopLevel.INSTANCE, this.isSearchInComments, this.isSearchInNonJavaFiles, this.isFullFileMove && this.isDeleteEmptyFiles, this.moveCallback, false, null, true, this.isSearchReferences);
        return new MoveKotlinDeclarationsProcessor(options2, Mover.Default.INSTANCE, throwOnConflicts);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final List<KtNamedDeclaration> getElementsToMove() {
        return this.elementsToMove;
    }

    @NotNull
    public final String getTargetPackage() {
        return this.targetPackage;
    }

    @Nullable
    public final PsiDirectory getSelectedPsiDirectory() {
        return this.selectedPsiDirectory;
    }

    @NotNull
    public final String getFileNameInPackage() {
        return this.fileNameInPackage;
    }

    @NotNull
    public final String getTargetFilePath() {
        return this.targetFilePath;
    }

    public final boolean isMoveToPackage() {
        return this.isMoveToPackage;
    }

    public final boolean isSearchReferences() {
        return this.isSearchReferences;
    }

    public final boolean isSearchInComments() {
        return this.isSearchInComments;
    }

    public final boolean isSearchInNonJavaFiles() {
        return this.isSearchInNonJavaFiles;
    }

    public final boolean isDeleteEmptyFiles() {
        return this.isDeleteEmptyFiles;
    }

    public final boolean isUpdatePackageDirective() {
        return this.isUpdatePackageDirective;
    }

    public final boolean isFullFileMove() {
        return this.isFullFileMove;
    }

    @Nullable
    public final MoveCallback getMoveCallback() {
        return this.moveCallback;
    }

    /*
     * WARNING - void declaration
     */
    public MoveKotlinTopLevelDeclarationsModel(@NotNull Project project2, @NotNull List<? extends KtNamedDeclaration> elementsToMove, @NotNull String targetPackage, @Nullable PsiDirectory selectedPsiDirectory, @NotNull String fileNameInPackage, @NotNull String targetFilePath, boolean isMoveToPackage, boolean isSearchReferences, boolean isSearchInComments, boolean isSearchInNonJavaFiles, boolean isDeleteEmptyFiles, boolean isUpdatePackageDirective, boolean isFullFileMove, @Nullable MoveCallback moveCallback) {
        Collection<KtFile> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull(elementsToMove, (String)"elementsToMove");
        Intrinsics.checkParameterIsNotNull((Object)targetPackage, (String)"targetPackage");
        Intrinsics.checkParameterIsNotNull((Object)fileNameInPackage, (String)"fileNameInPackage");
        Intrinsics.checkParameterIsNotNull((Object)targetFilePath, (String)"targetFilePath");
        this.project = project2;
        this.elementsToMove = elementsToMove;
        this.targetPackage = targetPackage;
        this.selectedPsiDirectory = selectedPsiDirectory;
        this.fileNameInPackage = fileNameInPackage;
        this.targetFilePath = targetFilePath;
        this.isMoveToPackage = isMoveToPackage;
        this.isSearchReferences = isSearchReferences;
        this.isSearchInComments = isSearchInComments;
        this.isSearchInNonJavaFiles = isSearchInNonJavaFiles;
        this.isDeleteEmptyFiles = isDeleteEmptyFiles;
        this.isUpdatePackageDirective = isUpdatePackageDirective;
        this.isFullFileMove = isFullFileMove;
        this.moveCallback = moveCallback;
        this.sourceDirectory$delegate = LazyKt.lazy((Function0)((Function0)new Function0<PsiDirectory>(this){
            final /* synthetic */ MoveKotlinTopLevelDeclarationsModel this$0;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final PsiDirectory invoke() {
                KtFile ktFile;
                Object object;
                block3: {
                    void var3_3;
                    Iterable $this$singleOrNull$iv = MoveKotlinTopLevelDeclarationsModel.access$getSourceFiles$p(this.this$0);
                    boolean $i$f$singleOrNull = false;
                    Object single$iv = null;
                    boolean found$iv = false;
                    for (T element$iv : $this$singleOrNull$iv) {
                        KtFile it = (KtFile)element$iv;
                        boolean bl = false;
                        KtFile ktFile2 = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)ktFile2, (String)"it");
                        if (!(ktFile2.getParent() != null)) continue;
                        if (found$iv) {
                            object = null;
                            break block3;
                        }
                        single$iv = element$iv;
                        found$iv = true;
                    }
                    object = !found$iv ? null : var3_3;
                }
                if ((ktFile = (KtFile)object) == null || (ktFile = ktFile.getParent()) == null) {
                    throw (Throwable)new ConfigurationException(KotlinBundle.message("text.cannot.determine.source.directory", new Object[0]));
                }
                return ktFile;
            }
            {
                this.this$0 = moveKotlinTopLevelDeclarationsModel;
                super(0);
            }
        }));
        Iterable iterable = this.elementsToMove;
        MoveKotlinTopLevelDeclarationsModel moveKotlinTopLevelDeclarationsModel = this;
        boolean $i$f$map = false;
        void var17_18 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KtNamedDeclaration ktNamedDeclaration = (KtNamedDeclaration)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            KtFile ktFile = it.getContainingKtFile();
            collection.add(ktFile);
        }
        collection = (List)destination$iv$iv;
        moveKotlinTopLevelDeclarationsModel.sourceFiles = CollectionsKt.distinct((Iterable)collection);
    }

    public static final /* synthetic */ PsiDirectory access$getSourceDirectory$p(MoveKotlinTopLevelDeclarationsModel $this) {
        return $this.getSourceDirectory();
    }

    public static final /* synthetic */ List access$getSourceFiles$p(MoveKotlinTopLevelDeclarationsModel $this) {
        return $this.sourceFiles;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001f\u0010\r\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/ui/MoveKotlinTopLevelDeclarationsModel$TargetDirAndDestination;", "", "targetDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "destination", "Lcom/intellij/refactoring/MoveDestination;", "(Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/refactoring/MoveDestination;)V", "getDestination", "()Lcom/intellij/refactoring/MoveDestination;", "getTargetDir", "()Lcom/intellij/openapi/vfs/VirtualFile;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "idea"})
    private static final class TargetDirAndDestination {
        @Nullable
        private final VirtualFile targetDir;
        @NotNull
        private final MoveDestination destination;

        @Nullable
        public final VirtualFile getTargetDir() {
            return this.targetDir;
        }

        @NotNull
        public final MoveDestination getDestination() {
            return this.destination;
        }

        public TargetDirAndDestination(@Nullable VirtualFile targetDir, @NotNull MoveDestination destination) {
            Intrinsics.checkParameterIsNotNull((Object)destination, (String)"destination");
            this.targetDir = targetDir;
            this.destination = destination;
        }

        @Nullable
        public final VirtualFile component1() {
            return this.targetDir;
        }

        @NotNull
        public final MoveDestination component2() {
            return this.destination;
        }

        @NotNull
        public final TargetDirAndDestination copy(@Nullable VirtualFile targetDir, @NotNull MoveDestination destination) {
            Intrinsics.checkParameterIsNotNull((Object)destination, (String)"destination");
            return new TargetDirAndDestination(targetDir, destination);
        }

        public static /* synthetic */ TargetDirAndDestination copy$default(TargetDirAndDestination targetDirAndDestination, VirtualFile virtualFile2, MoveDestination moveDestination, int n, Object object) {
            if ((n & 1) != 0) {
                virtualFile2 = targetDirAndDestination.targetDir;
            }
            if ((n & 2) != 0) {
                moveDestination = targetDirAndDestination.destination;
            }
            return targetDirAndDestination.copy(virtualFile2, moveDestination);
        }

        @NotNull
        public String toString() {
            return "TargetDirAndDestination(targetDir=" + this.targetDir + ", destination=" + this.destination + ")";
        }

        public int hashCode() {
            VirtualFile virtualFile2 = this.targetDir;
            MoveDestination moveDestination = this.destination;
            return (virtualFile2 != null ? virtualFile2.hashCode() : 0) * 31 + (moveDestination != null ? moveDestination.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof TargetDirAndDestination)) break block3;
                    TargetDirAndDestination targetDirAndDestination = (TargetDirAndDestination)object;
                    if (!Intrinsics.areEqual((Object)this.targetDir, (Object)targetDirAndDestination.targetDir) || !Intrinsics.areEqual((Object)this.destination, (Object)targetDirAndDestination.destination)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

