/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.run;

import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.JavaTestConfigurationBase;
import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.junit.InheritorChooser;
import com.intellij.execution.junit2.info.MethodLocation;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiClassUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.theoryinpractice.testng.configuration.TestNGConfiguration;
import com.theoryinpractice.testng.configuration.TestNGConfigurationProducer;
import com.theoryinpractice.testng.util.TestNGUtil;
import java.util.List;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.idea.project.TargetPlatformDetector;
import org.jetbrains.kotlin.idea.run.JavaRunConfigurationExtensionManagerUtil;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtil;
import org.jetbrains.kotlin.platform.jvm.JvmPlatformKt;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;

public class KotlinTestNgConfigurationProducer
extends TestNGConfigurationProducer {
    public boolean shouldReplace(ConfigurationFromContext self, ConfigurationFromContext other) {
        return other.isProducedBy(TestNGConfigurationProducer.class);
    }

    public boolean isConfigurationFromContext(TestNGConfiguration configuration2, ConfigurationContext context2) {
        String vmParameters;
        if (this.isMultipleElementsSelected(context2)) {
            return false;
        }
        RunConfiguration predefinedConfiguration = context2.getOriginalConfiguration(this.getConfigurationType());
        Location contextLocation = context2.getLocation();
        if (contextLocation == null) {
            return false;
        }
        Location location2 = JavaExecutionUtil.stepIntoSingleClass((Location)contextLocation);
        if (location2 == null) {
            return false;
        }
        PsiElement element3 = location2.getPsiElement();
        RunnerAndConfigurationSettings template2 = RunManager.getInstance((Project)location2.getProject()).getConfigurationTemplate(this.getConfigurationFactory());
        Module predefinedModule = ((JavaRunConfigurationModule)((TestNGConfiguration)template2.getConfiguration()).getConfigurationModule()).getModule();
        String string = vmParameters = predefinedConfiguration instanceof CommonJavaRunConfigurationParameters ? ((CommonJavaRunConfigurationParameters)predefinedConfiguration).getVMParameters() : null;
        if (vmParameters != null && !Comparing.strEqual((String)vmParameters, (String)configuration2.getVMParameters())) {
            return false;
        }
        if (this.differentParamSet((JavaTestConfigurationBase)configuration2, contextLocation)) {
            return false;
        }
        KtNamedDeclaration declarationToRun = KotlinTestNgConfigurationProducer.getDeclarationToRun(element3);
        if (declarationToRun == null) {
            return false;
        }
        PsiNamedElement lightElement = (PsiNamedElement)CollectionsKt.firstOrNull(LightClassUtilsKt.toLightElements(declarationToRun));
        if (lightElement != null && configuration2.isConfiguredByElement((PsiElement)lightElement)) {
            Module configurationModule = ((JavaRunConfigurationModule)configuration2.getConfigurationModule()).getModule();
            if (Comparing.equal((Object)location2.getModule(), (Object)configurationModule)) {
                return true;
            }
            if (Comparing.equal((Object)predefinedModule, (Object)configurationModule)) {
                return true;
            }
        }
        return false;
    }

    protected boolean setupConfigurationFromContext(TestNGConfiguration configuration2, ConfigurationContext context2, Ref<PsiElement> sourceElement) {
        Location location2 = context2.getLocation();
        if (location2 == null) {
            return false;
        }
        Project project2 = context2.getProject();
        PsiElement leaf = location2.getPsiElement();
        if (!ProjectRootsUtil.isInProjectOrLibSource(leaf, false)) {
            return false;
        }
        if (!(leaf.getContainingFile() instanceof KtFile)) {
            return false;
        }
        KtFile ktFile = (KtFile)leaf.getContainingFile();
        if (!JvmPlatformKt.isJvm(TargetPlatformDetector.getPlatform(ktFile))) {
            return false;
        }
        Pair<PsiClass, PsiMethod> classAndMethod = KotlinTestNgConfigurationProducer.getTestClassAndMethod(leaf);
        if (classAndMethod == null) {
            return false;
        }
        PsiClass testClass = (PsiClass)classAndMethod.getFirst();
        if (testClass == null) {
            return false;
        }
        PsiMethod testMethod = (PsiMethod)classAndMethod.getSecond();
        return this.configure(configuration2, location2, context2, project2, testClass, testMethod);
    }

    public void onFirstRun(ConfigurationFromContext configuration2, ConfigurationContext context2, Runnable startRunnable) {
        KtNamedDeclaration declarationToRun = KotlinTestNgConfigurationProducer.getDeclarationToRun(configuration2.getSourceElement());
        final PsiNamedElement lightElement = (PsiNamedElement)CollectionsKt.firstOrNull(LightClassUtilsKt.toLightElements(declarationToRun));
        if (lightElement instanceof PsiMethod || lightElement instanceof PsiClass) {
            PsiClass containingClass2;
            PsiMethod psiMethod;
            if (lightElement instanceof PsiMethod) {
                psiMethod = (PsiMethod)lightElement;
                containingClass2 = psiMethod.getContainingClass();
            } else {
                psiMethod = null;
                containingClass2 = (PsiClass)lightElement;
            }
            InheritorChooser inheritorChooser2 = new InheritorChooser(){

                protected void runForClasses(List<PsiClass> classes2, PsiMethod method, ConfigurationContext context2, Runnable performRunnable) {
                    ((TestNGConfiguration)context2.getConfiguration().getConfiguration()).bePatternConfiguration(classes2, method);
                    super.runForClasses(classes2, method, context2, performRunnable);
                }

                protected void runForClass(PsiClass aClass2, PsiMethod psiMethod, ConfigurationContext context2, Runnable performRunnable) {
                    if (lightElement instanceof PsiMethod) {
                        Project project2 = psiMethod.getProject();
                        MethodLocation methodLocation = new MethodLocation(project2, psiMethod, PsiLocation.fromPsiElement((PsiElement)aClass2));
                        ((TestNGConfiguration)context2.getConfiguration().getConfiguration()).setMethodConfiguration((Location)methodLocation);
                    } else {
                        ((TestNGConfiguration)context2.getConfiguration().getConfiguration()).setClassConfiguration(aClass2);
                    }
                    super.runForClass(aClass2, psiMethod, context2, performRunnable);
                }
            };
            if (inheritorChooser2.runMethodInAbstractClass(context2, startRunnable, psiMethod, containingClass2, (Condition)new Condition<PsiClass>(){

                public boolean value(PsiClass aClass2) {
                    return aClass2.hasModifierProperty("abstract") && TestNGUtil.hasTest((PsiModifierListOwner)aClass2);
                }
            })) {
                return;
            }
        }
        super.onFirstRun(configuration2, context2, startRunnable);
    }

    @Nullable
    private static KtNamedDeclaration getDeclarationToRun(@NotNull PsiElement leaf) {
        if (leaf == null) {
            KotlinTestNgConfigurationProducer.$$$reportNull$$$0(0);
        }
        if (!(leaf.getContainingFile() instanceof KtFile)) {
            return null;
        }
        KtFile jetFile = (KtFile)leaf.getContainingFile();
        KtNamedFunction function2 = (KtNamedFunction)PsiTreeUtil.getParentOfType((PsiElement)leaf, KtNamedFunction.class, (boolean)false);
        if (function2 != null) {
            return function2;
        }
        KtClass ktClass2 = (KtClass)PsiTreeUtil.getParentOfType((PsiElement)leaf, KtClass.class, (boolean)false);
        if (ktClass2 != null) {
            return ktClass2;
        }
        return KotlinTestNgConfigurationProducer.getClassDeclarationInFile(jetFile);
    }

    private boolean configure(TestNGConfiguration configuration2, Location location2, ConfigurationContext context2, Project project2, @Nullable PsiClass delegate2, @Nullable PsiMethod method) {
        if (delegate2 == null) {
            return false;
        }
        this.setupConfigurationModule(context2, (ModuleBasedConfiguration)configuration2);
        Module originalModule = ((JavaRunConfigurationModule)configuration2.getConfigurationModule()).getModule();
        configuration2.setClassConfiguration(delegate2);
        if (method != null) {
            configuration2.setMethodConfiguration(PsiLocation.fromPsiElement((Project)project2, (PsiElement)method));
        }
        configuration2.restoreOriginalModule(originalModule);
        configuration2.setName(configuration2.getName());
        JavaRunConfigurationExtensionManagerUtil.getInstance().extendCreatedConfiguration((RunConfigurationBase)configuration2, location2);
        return true;
    }

    private static boolean isTestNGClass(PsiClass psiClass2) {
        return psiClass2 != null && PsiClassUtil.isRunnableClass((PsiClass)psiClass2, (boolean)true, (boolean)false) && TestNGUtil.hasTest((PsiModifierListOwner)psiClass2);
    }

    @Nullable
    static KtClass getClassDeclarationInFile(KtFile jetFile) {
        KtClass tempSingleDeclaration = null;
        for (KtDeclaration ktDeclaration : jetFile.getDeclarations()) {
            if (!(ktDeclaration instanceof KtClass)) continue;
            KtClass declaration2 = (KtClass)ktDeclaration;
            if (tempSingleDeclaration == null) {
                tempSingleDeclaration = declaration2;
                continue;
            }
            return null;
        }
        return tempSingleDeclaration;
    }

    @Nullable
    public static Pair<PsiClass, PsiMethod> getTestClassAndMethod(@NotNull PsiElement leaf) {
        KtLightClass delegate2;
        KtLightClass delegate3;
        KtNamedFunction function2;
        KtElement owner;
        KtNamedDeclaration declarationToRun;
        if (leaf == null) {
            KotlinTestNgConfigurationProducer.$$$reportNull$$$0(1);
        }
        if ((declarationToRun = KotlinTestNgConfigurationProducer.getDeclarationToRun(leaf)) instanceof KtNamedFunction && (owner = (KtElement)PsiTreeUtil.getParentOfType((PsiElement)(function2 = (KtNamedFunction)declarationToRun), (Class[])new Class[]{KtFunction.class, KtClass.class})) instanceof KtClass && (delegate3 = LightClassUtilsKt.toLightClass((KtClass)owner)) != null) {
            for (PsiMethod method : delegate3.getMethods()) {
                if (method.getNavigationElement() != function2) continue;
                if (!TestNGUtil.hasTest((PsiModifierListOwner)method)) break;
                return new Pair((Object)delegate3, (Object)method);
            }
        }
        if (declarationToRun instanceof KtClass && KotlinTestNgConfigurationProducer.isTestNGClass(delegate2 = LightClassUtilsKt.toLightClass((KtClassOrObject)declarationToRun))) {
            return new Pair((Object)delegate2, null);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "leaf";
        objectArray2[1] = "org/jetbrains/kotlin/idea/run/KotlinTestNgConfigurationProducer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getDeclarationToRun";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getTestClassAndMethod";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

