/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.scratch.output;

import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.ide.scratch.ScratchFileType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiFile;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.scratch.ScratchExpression;
import org.jetbrains.kotlin.idea.scratch.ScratchFile;
import org.jetbrains.kotlin.idea.scratch.output.ScratchOutput;
import org.jetbrains.kotlin.idea.scratch.output.ScratchOutputHandlerAdapter;
import org.jetbrains.kotlin.idea.scratch.output.ScratchOutputType;
import org.jetbrains.kotlin.idea.scratch.output.ScratchToolWindowFactory;
import org.jetbrains.kotlin.idea.scratch.output.ToolWindowScratchOutputHandler$WhenMappings;
import org.jetbrains.kotlin.idea.scratch.output.ToolWindowScratchOutputHandlerKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J \u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J)\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0017\u0010\u0017\u001a\u0013\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00060\u0018\u00a2\u0006\u0002\b\u001aH\u0002J\u0014\u0010\u001b\u001a\n \u001d*\u0004\u0018\u00010\u001c0\u001c*\u00020\u001eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/output/ToolWindowScratchOutputHandler;", "Lorg/jetbrains/kotlin/idea/scratch/output/ScratchOutputHandlerAdapter;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "(Lcom/intellij/openapi/Disposable;)V", "clear", "", "file", "Lorg/jetbrains/kotlin/idea/scratch/ScratchFile;", "createToolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "error", "message", "", "getToolWindow", "project", "Lcom/intellij/openapi/project/Project;", "handle", "expression", "Lorg/jetbrains/kotlin/idea/scratch/ScratchExpression;", "output", "Lorg/jetbrains/kotlin/idea/scratch/output/ScratchOutput;", "printToConsole", "print", "Lkotlin/Function1;", "Lcom/intellij/execution/impl/ConsoleViewImpl;", "Lkotlin/ExtensionFunctionType;", "convert", "Lcom/intellij/execution/ui/ConsoleViewContentType;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/kotlin/idea/scratch/output/ScratchOutputType;", "idea-jvm"})
final class ToolWindowScratchOutputHandler
extends ScratchOutputHandlerAdapter {
    private final Disposable parentDisposable;

    @Override
    public void handle(@NotNull ScratchFile file2, @NotNull ScratchExpression expression2, @NotNull ScratchOutput output) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
        this.printToConsole(file2, (Function1<? super ConsoleViewImpl, Unit>)((Function1)new Function1<ConsoleViewImpl, Unit>(this, file2, expression2, output){
            final /* synthetic */ ToolWindowScratchOutputHandler this$0;
            final /* synthetic */ ScratchFile $file;
            final /* synthetic */ ScratchExpression $expression;
            final /* synthetic */ ScratchOutput $output;

            public final void invoke(@NotNull ConsoleViewImpl $this$printToConsole) {
                Intrinsics.checkParameterIsNotNull((Object)$this$printToConsole, (String)"$receiver");
                PsiFile psiFile2 = this.$file.getPsiFile();
                if (psiFile2 != null) {
                    $this$printToConsole.printHyperlink(ToolWindowScratchOutputHandlerKt.access$getLineInfo(psiFile2, this.$expression), (HyperlinkInfo)new OpenFileHyperlinkInfo($this$printToConsole.getProject(), psiFile2.getVirtualFile(), this.$expression.getLineStart()));
                    $this$printToConsole.print(" ", ConsoleViewContentType.NORMAL_OUTPUT);
                }
                $this$printToConsole.print(this.$output.getText(), ToolWindowScratchOutputHandler.access$convert(this.this$0, this.$output.getType()));
            }
            {
                this.this$0 = toolWindowScratchOutputHandler;
                this.$file = scratchFile;
                this.$expression = scratchExpression;
                this.$output = scratchOutput;
                super(1);
            }
        }));
    }

    @Override
    public void error(@NotNull ScratchFile file2, @NotNull String message2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)message2, (String)"message");
        this.printToConsole(file2, (Function1<? super ConsoleViewImpl, Unit>)((Function1)new Function1<ConsoleViewImpl, Unit>(message2){
            final /* synthetic */ String $message;

            public final void invoke(@NotNull ConsoleViewImpl $this$printToConsole) {
                Intrinsics.checkParameterIsNotNull((Object)$this$printToConsole, (String)"$receiver");
                $this$printToConsole.print(this.$message, ConsoleViewContentType.ERROR_OUTPUT);
            }
            {
                this.$message = string;
                super(1);
            }
        }));
    }

    private final void printToConsole(ScratchFile file2, Function1<? super ConsoleViewImpl, Unit> print2) {
        ApplicationManager.getApplication().invokeLater(new Runnable(this, file2, print2){
            final /* synthetic */ ToolWindowScratchOutputHandler this$0;
            final /* synthetic */ ScratchFile $file;
            final /* synthetic */ Function1 $print;

            public final void run() {
                Content[] contents;
                Project project2 = this.$file.getProject();
                boolean bl = false;
                boolean bl2 = false;
                Project it = project2;
                boolean bl3 = false;
                Object object = !it.isDisposed() ? project2 : null;
                if (object == null) {
                    return;
                }
                Project project3 = object;
                ToolWindow toolWindow = ToolWindowScratchOutputHandler.access$getToolWindow(this.this$0, project3);
                if (toolWindow == null) {
                    toolWindow = ToolWindowScratchOutputHandler.access$createToolWindow(this.this$0, this.$file);
                }
                ToolWindow toolWindow2 = toolWindow;
                ContentManager contentManager = toolWindow2.getContentManager();
                Intrinsics.checkExpressionValueIsNotNull((Object)contentManager, (String)"toolWindow.contentManager");
                Content[] contentArray = contents = contentManager.getContents();
                int n = contentArray.length;
                for (int j = 0; j < n; ++j) {
                    JComponent component2;
                    Content content2;
                    Content content3 = content2 = contentArray[j];
                    Intrinsics.checkExpressionValueIsNotNull((Object)content3, (String)"content");
                    Intrinsics.checkExpressionValueIsNotNull((Object)content3.getComponent(), (String)"content.component");
                    if (!(component2 instanceof ConsoleViewImpl)) continue;
                    this.$print.invoke((Object)component2);
                    ((ConsoleViewImpl)component2).print("\n", ConsoleViewContentType.NORMAL_OUTPUT);
                }
                toolWindow2.setAvailable(true, null);
                if (!this.$file.getOptions().isInteractiveMode()) {
                    toolWindow2.show(null);
                }
                LanguageFileType languageFileType = ScratchFileType.INSTANCE;
                Intrinsics.checkExpressionValueIsNotNull((Object)languageFileType, (String)"ScratchFileType.INSTANCE");
                toolWindow2.setIcon(ExecutionUtil.getLiveIndicator((Icon)languageFileType.getIcon()));
            }
            {
                this.this$0 = toolWindowScratchOutputHandler;
                this.$file = scratchFile;
                this.$print = function1;
            }
        });
    }

    @Override
    public void clear(@NotNull ScratchFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        ApplicationManager.getApplication().invokeLater(new Runnable(this, file2){
            final /* synthetic */ ToolWindowScratchOutputHandler this$0;
            final /* synthetic */ ScratchFile $file;

            public final void run() {
                int n;
                Content[] contents;
                ToolWindow toolWindow = ToolWindowScratchOutputHandler.access$getToolWindow(this.this$0, this.$file.getProject());
                if (toolWindow == null) {
                    return;
                }
                ToolWindow toolWindow2 = toolWindow;
                ContentManager contentManager = toolWindow2.getContentManager();
                Intrinsics.checkExpressionValueIsNotNull((Object)contentManager, (String)"toolWindow.contentManager");
                Content[] contentArray = contents = contentManager.getContents();
                int n2 = contentArray.length;
                for (n = 0; n < n2; ++n) {
                    JComponent component2;
                    Content content2;
                    Content content3 = content2 = contentArray[n];
                    Intrinsics.checkExpressionValueIsNotNull((Object)content3, (String)"content");
                    Intrinsics.checkExpressionValueIsNotNull((Object)content3.getComponent(), (String)"content.component");
                    if (!(component2 instanceof ConsoleViewImpl)) continue;
                    ((ConsoleViewImpl)component2).clear();
                }
                if (!this.$file.getOptions().isInteractiveMode()) {
                    toolWindow2.hide(null);
                }
                ToolWindow toolWindow3 = toolWindow2;
                LanguageFileType languageFileType = ScratchFileType.INSTANCE;
                Intrinsics.checkExpressionValueIsNotNull((Object)languageFileType, (String)"ScratchFileType.INSTANCE");
                Icon icon = languageFileType.getIcon();
                if (icon == null) {
                    String string = "Text icon is expected to be present";
                    ToolWindow toolWindow4 = toolWindow3;
                    n = 0;
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                toolWindow3.setIcon(icon);
            }
            {
                this.this$0 = toolWindowScratchOutputHandler;
                this.$file = scratchFile;
            }
        });
    }

    private final ConsoleViewContentType convert(@NotNull ScratchOutputType $this$convert) {
        ConsoleViewContentType consoleViewContentType;
        switch (ToolWindowScratchOutputHandler$WhenMappings.$EnumSwitchMapping$0[$this$convert.ordinal()]) {
            case 1: {
                consoleViewContentType = ConsoleViewContentType.SYSTEM_OUTPUT;
                break;
            }
            case 2: {
                consoleViewContentType = ConsoleViewContentType.NORMAL_OUTPUT;
                break;
            }
            case 3: {
                consoleViewContentType = ConsoleViewContentType.ERROR_OUTPUT;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return consoleViewContentType;
    }

    private final ToolWindow getToolWindow(Project project2) {
        ToolWindowManager toolWindowManager = ToolWindowManager.Companion.getInstance(project2);
        return toolWindowManager.getToolWindow("Scratch Output");
    }

    private final ToolWindow createToolWindow(ScratchFile file2) {
        Project project2 = file2.getProject();
        ToolWindowManager toolWindowManager = ToolWindowManager.Companion.getInstance(project2);
        ToolWindowAnchor toolWindowAnchor = ToolWindowAnchor.BOTTOM;
        Intrinsics.checkExpressionValueIsNotNull((Object)toolWindowAnchor, (String)"ToolWindowAnchor.BOTTOM");
        toolWindowManager.registerToolWindow("Scratch Output", true, toolWindowAnchor);
        ToolWindow toolWindow = toolWindowManager.getToolWindow("Scratch Output");
        if (toolWindow == null) {
            String string = "ScratchToolWindowFactory.ID should be registered";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        ToolWindow window2 = toolWindow;
        new ScratchToolWindowFactory().createToolWindowContent(project2, window2);
        Disposer.register((Disposable)this.parentDisposable, (Disposable)new Disposable(toolWindowManager){
            final /* synthetic */ ToolWindowManager $toolWindowManager;

            public final void dispose() {
                this.$toolWindowManager.unregisterToolWindow("Scratch Output");
            }
            {
                this.$toolWindowManager = toolWindowManager;
            }
        });
        return window2;
    }

    public ToolWindowScratchOutputHandler(@NotNull Disposable parentDisposable) {
        Intrinsics.checkParameterIsNotNull((Object)parentDisposable, (String)"parentDisposable");
        this.parentDisposable = parentDisposable;
    }

    public static final /* synthetic */ ConsoleViewContentType access$convert(ToolWindowScratchOutputHandler $this, ScratchOutputType $this$access_u24convert) {
        return $this.convert($this$access_u24convert);
    }

    public static final /* synthetic */ ToolWindow access$getToolWindow(ToolWindowScratchOutputHandler $this, Project project2) {
        return $this.getToolWindow(project2);
    }

    public static final /* synthetic */ ToolWindow access$createToolWindow(ToolWindowScratchOutputHandler $this, ScratchFile file2) {
        return $this.createToolWindow(file2);
    }
}

