/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.statistics;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.statistics.CompletionTypeStats;
import org.jetbrains.kotlin.idea.statistics.FileTypeStats;
import org.jetbrains.kotlin.idea.statistics.FinishReasonStats;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0017B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/statistics/CompletionFUSCollector;", "", "()V", "ChoiceAtPositionAttribute", "", "Chosen", "CompletionEventAttribute", "CompletionTypeAttribute", "EventName", "FileTypeAttribute", "FinishReason", "InvocationCount", "NotChosen", "WindowAppearanceTimeAttribute", "WindowPopulationTimeAttribute", "completionStatsData", "Lorg/jetbrains/kotlin/idea/statistics/CompletionFUSCollector$CompletionStatsData;", "getCompletionStatsData", "()Lorg/jetbrains/kotlin/idea/statistics/CompletionFUSCollector$CompletionStatsData;", "setCompletionStatsData", "(Lorg/jetbrains/kotlin/idea/statistics/CompletionFUSCollector$CompletionStatsData;)V", "log", "", "CompletionStatsData", "idea-core"})
public final class CompletionFUSCollector {
    private static final String WindowPopulationTimeAttribute = "window_population_time";
    private static final String WindowAppearanceTimeAttribute = "window_appearance_time";
    private static final String CompletionTypeAttribute = "completion_type";
    private static final String FileTypeAttribute = "file_type";
    private static final String FinishReason = "finish_reason";
    private static final String ChoiceAtPositionAttribute = "choice_at_position";
    private static final String InvocationCount = "invocation_count";
    private static final String CompletionEventAttribute = "completion_event";
    private static final String Chosen = "chosen";
    private static final String NotChosen = "not_chosen";
    private static final String EventName = "Completion";
    @Nullable
    private static volatile CompletionStatsData completionStatsData;
    public static final CompletionFUSCollector INSTANCE;

    @Nullable
    public final CompletionStatsData getCompletionStatsData() {
        return completionStatsData;
    }

    public final void setCompletionStatsData(@Nullable CompletionStatsData completionStatsData) {
        CompletionFUSCollector.completionStatsData = completionStatsData;
    }

    public final void log(@Nullable CompletionStatsData completionStatsData) {
        CompletionStatsData completionStatsData2 = completionStatsData;
        if ((completionStatsData2 != null ? completionStatsData2.getFileType() : null) == null) {
            return;
        }
        boolean bl = false;
        Map data2 = new LinkedHashMap();
        data2.put(FileTypeAttribute, completionStatsData.getFileType().toString());
        data2.put(CompletionTypeAttribute, String.valueOf((Object)completionStatsData.getCompletionType()));
        if (completionStatsData.getFinishTime() != null) {
            String populationTime = String.valueOf(completionStatsData.getFinishTime() - completionStatsData.getStartTime());
            data2.put(WindowPopulationTimeAttribute, populationTime);
        }
        if (completionStatsData.getShownTime() != null) {
            String appearanceTime = String.valueOf(completionStatsData.getShownTime() - completionStatsData.getStartTime());
            data2.put(WindowAppearanceTimeAttribute, appearanceTime);
        }
        if (completionStatsData.getFinishReason() != null) {
            data2.put(FinishReason, completionStatsData.getFinishReason().toString());
        }
        if (completionStatsData.getInvocationCount() != null) {
            data2.put(InvocationCount, String.valueOf(completionStatsData.getInvocationCount()));
        }
        if (completionStatsData.getSelectedItem() != null) {
            data2.put(ChoiceAtPositionAttribute, String.valueOf(completionStatsData.getSelectedItem()));
            data2.put(CompletionEventAttribute, Chosen);
        } else {
            data2.put(CompletionEventAttribute, NotChosen);
        }
    }

    private CompletionFUSCollector() {
    }

    static {
        CompletionFUSCollector completionFUSCollector;
        INSTANCE = completionFUSCollector = new CompletionFUSCollector();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u001d\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001Ba\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000fJ\t\u0010 \u001a\u00020\u0003H\u00c6\u0003J\u0010\u0010!\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0017J\u0010\u0010\"\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0017J\u000b\u0010#\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\u000b\u0010$\u001a\u0004\u0018\u00010\tH\u00c6\u0003J\u000b\u0010%\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003J\u0010\u0010&\u001a\u0004\u0018\u00010\rH\u00c6\u0003\u00a2\u0006\u0002\u0010\u001aJ\u0010\u0010'\u001a\u0004\u0018\u00010\rH\u00c6\u0003\u00a2\u0006\u0002\u0010\u001aJl\u0010(\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\rH\u00c6\u0001\u00a2\u0006\u0002\u0010)J\u0013\u0010*\u001a\u00020+2\b\u0010,\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010-\u001a\u00020\rH\u00d6\u0001J\t\u0010.\u001a\u00020/H\u00d6\u0001R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0015\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\u0018\u001a\u0004\b\u0016\u0010\u0017R\u0015\u0010\u000e\u001a\u0004\u0018\u00010\r\u00a2\u0006\n\n\u0002\u0010\u001b\u001a\u0004\b\u0019\u0010\u001aR\u0015\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\n\n\u0002\u0010\u001b\u001a\u0004\b\u001c\u0010\u001aR\u0015\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\u0018\u001a\u0004\b\u001d\u0010\u0017R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u00060"}, d2={"Lorg/jetbrains/kotlin/idea/statistics/CompletionFUSCollector$CompletionStatsData;", "", "startTime", "", "shownTime", "finishTime", "completionType", "Lorg/jetbrains/kotlin/idea/statistics/CompletionTypeStats;", "fileType", "Lorg/jetbrains/kotlin/idea/statistics/FileTypeStats;", "finishReason", "Lorg/jetbrains/kotlin/idea/statistics/FinishReasonStats;", "selectedItem", "", "invocationCount", "(JLjava/lang/Long;Ljava/lang/Long;Lorg/jetbrains/kotlin/idea/statistics/CompletionTypeStats;Lorg/jetbrains/kotlin/idea/statistics/FileTypeStats;Lorg/jetbrains/kotlin/idea/statistics/FinishReasonStats;Ljava/lang/Integer;Ljava/lang/Integer;)V", "getCompletionType", "()Lorg/jetbrains/kotlin/idea/statistics/CompletionTypeStats;", "getFileType", "()Lorg/jetbrains/kotlin/idea/statistics/FileTypeStats;", "getFinishReason", "()Lorg/jetbrains/kotlin/idea/statistics/FinishReasonStats;", "getFinishTime", "()Ljava/lang/Long;", "Ljava/lang/Long;", "getInvocationCount", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getSelectedItem", "getShownTime", "getStartTime", "()J", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "(JLjava/lang/Long;Ljava/lang/Long;Lorg/jetbrains/kotlin/idea/statistics/CompletionTypeStats;Lorg/jetbrains/kotlin/idea/statistics/FileTypeStats;Lorg/jetbrains/kotlin/idea/statistics/FinishReasonStats;Ljava/lang/Integer;Ljava/lang/Integer;)Lorg/jetbrains/kotlin/idea/statistics/CompletionFUSCollector$CompletionStatsData;", "equals", "", "other", "hashCode", "toString", "", "idea-core"})
    public static final class CompletionStatsData {
        private final long startTime;
        @Nullable
        private final Long shownTime;
        @Nullable
        private final Long finishTime;
        @Nullable
        private final CompletionTypeStats completionType;
        @Nullable
        private final FileTypeStats fileType;
        @Nullable
        private final FinishReasonStats finishReason;
        @Nullable
        private final Integer selectedItem;
        @Nullable
        private final Integer invocationCount;

        public final long getStartTime() {
            return this.startTime;
        }

        @Nullable
        public final Long getShownTime() {
            return this.shownTime;
        }

        @Nullable
        public final Long getFinishTime() {
            return this.finishTime;
        }

        @Nullable
        public final CompletionTypeStats getCompletionType() {
            return this.completionType;
        }

        @Nullable
        public final FileTypeStats getFileType() {
            return this.fileType;
        }

        @Nullable
        public final FinishReasonStats getFinishReason() {
            return this.finishReason;
        }

        @Nullable
        public final Integer getSelectedItem() {
            return this.selectedItem;
        }

        @Nullable
        public final Integer getInvocationCount() {
            return this.invocationCount;
        }

        public CompletionStatsData(long startTime, @Nullable Long shownTime, @Nullable Long finishTime, @Nullable CompletionTypeStats completionType, @Nullable FileTypeStats fileType, @Nullable FinishReasonStats finishReason, @Nullable Integer selectedItem, @Nullable Integer invocationCount) {
            this.startTime = startTime;
            this.shownTime = shownTime;
            this.finishTime = finishTime;
            this.completionType = completionType;
            this.fileType = fileType;
            this.finishReason = finishReason;
            this.selectedItem = selectedItem;
            this.invocationCount = invocationCount;
        }

        public /* synthetic */ CompletionStatsData(long l, Long l2, Long l3, CompletionTypeStats completionTypeStats, FileTypeStats fileTypeStats, FinishReasonStats finishReasonStats, Integer n, Integer n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 2) != 0) {
                l2 = null;
            }
            if ((n3 & 4) != 0) {
                l3 = null;
            }
            if ((n3 & 8) != 0) {
                completionTypeStats = null;
            }
            if ((n3 & 0x10) != 0) {
                fileTypeStats = null;
            }
            if ((n3 & 0x20) != 0) {
                finishReasonStats = null;
            }
            if ((n3 & 0x40) != 0) {
                n = null;
            }
            if ((n3 & 0x80) != 0) {
                n2 = null;
            }
            this(l, l2, l3, completionTypeStats, fileTypeStats, finishReasonStats, n, n2);
        }

        public final long component1() {
            return this.startTime;
        }

        @Nullable
        public final Long component2() {
            return this.shownTime;
        }

        @Nullable
        public final Long component3() {
            return this.finishTime;
        }

        @Nullable
        public final CompletionTypeStats component4() {
            return this.completionType;
        }

        @Nullable
        public final FileTypeStats component5() {
            return this.fileType;
        }

        @Nullable
        public final FinishReasonStats component6() {
            return this.finishReason;
        }

        @Nullable
        public final Integer component7() {
            return this.selectedItem;
        }

        @Nullable
        public final Integer component8() {
            return this.invocationCount;
        }

        @NotNull
        public final CompletionStatsData copy(long startTime, @Nullable Long shownTime, @Nullable Long finishTime, @Nullable CompletionTypeStats completionType, @Nullable FileTypeStats fileType, @Nullable FinishReasonStats finishReason, @Nullable Integer selectedItem, @Nullable Integer invocationCount) {
            return new CompletionStatsData(startTime, shownTime, finishTime, completionType, fileType, finishReason, selectedItem, invocationCount);
        }

        public static /* synthetic */ CompletionStatsData copy$default(CompletionStatsData completionStatsData, long l, Long l2, Long l3, CompletionTypeStats completionTypeStats, FileTypeStats fileTypeStats, FinishReasonStats finishReasonStats, Integer n, Integer n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                l = completionStatsData.startTime;
            }
            if ((n3 & 2) != 0) {
                l2 = completionStatsData.shownTime;
            }
            if ((n3 & 4) != 0) {
                l3 = completionStatsData.finishTime;
            }
            if ((n3 & 8) != 0) {
                completionTypeStats = completionStatsData.completionType;
            }
            if ((n3 & 0x10) != 0) {
                fileTypeStats = completionStatsData.fileType;
            }
            if ((n3 & 0x20) != 0) {
                finishReasonStats = completionStatsData.finishReason;
            }
            if ((n3 & 0x40) != 0) {
                n = completionStatsData.selectedItem;
            }
            if ((n3 & 0x80) != 0) {
                n2 = completionStatsData.invocationCount;
            }
            return completionStatsData.copy(l, l2, l3, completionTypeStats, fileTypeStats, finishReasonStats, n, n2);
        }

        @NotNull
        public String toString() {
            return "CompletionStatsData(startTime=" + this.startTime + ", shownTime=" + this.shownTime + ", finishTime=" + this.finishTime + ", completionType=" + (Object)((Object)this.completionType) + ", fileType=" + (Object)((Object)this.fileType) + ", finishReason=" + (Object)((Object)this.finishReason) + ", selectedItem=" + this.selectedItem + ", invocationCount=" + this.invocationCount + ")";
        }

        public int hashCode() {
            Long l = this.shownTime;
            Long l2 = this.finishTime;
            CompletionTypeStats completionTypeStats = this.completionType;
            FileTypeStats fileTypeStats = this.fileType;
            FinishReasonStats finishReasonStats = this.finishReason;
            Integer n = this.selectedItem;
            Integer n2 = this.invocationCount;
            return ((((((Long.hashCode(this.startTime) * 31 + (l != null ? ((Object)l).hashCode() : 0)) * 31 + (l2 != null ? ((Object)l2).hashCode() : 0)) * 31 + (completionTypeStats != null ? ((Object)((Object)completionTypeStats)).hashCode() : 0)) * 31 + (fileTypeStats != null ? ((Object)((Object)fileTypeStats)).hashCode() : 0)) * 31 + (finishReasonStats != null ? ((Object)((Object)finishReasonStats)).hashCode() : 0)) * 31 + (n != null ? ((Object)n).hashCode() : 0)) * 31 + (n2 != null ? ((Object)n2).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof CompletionStatsData)) break block3;
                    CompletionStatsData completionStatsData = (CompletionStatsData)object;
                    if (this.startTime != completionStatsData.startTime || !Intrinsics.areEqual((Object)this.shownTime, (Object)completionStatsData.shownTime) || !Intrinsics.areEqual((Object)this.finishTime, (Object)completionStatsData.finishTime) || !Intrinsics.areEqual((Object)((Object)this.completionType), (Object)((Object)completionStatsData.completionType)) || !Intrinsics.areEqual((Object)((Object)this.fileType), (Object)((Object)completionStatsData.fileType)) || !Intrinsics.areEqual((Object)((Object)this.finishReason), (Object)((Object)completionStatsData.finishReason)) || !Intrinsics.areEqual((Object)this.selectedItem, (Object)completionStatsData.selectedItem) || !Intrinsics.areEqual((Object)this.invocationCount, (Object)completionStatsData.invocationCount)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

