/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.statistics;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.statistics.FUSEventGroups;
import org.jetbrains.kotlin.idea.statistics.GradleStatisticsEvents;
import org.jetbrains.kotlin.idea.statistics.KotlinFUSLogger;
import org.jetbrains.kotlin.statistics.BuildSessionLogger;
import org.jetbrains.kotlin.statistics.fileloggers.MetricsContainer;
import org.jetbrains.kotlin.statistics.metrics.BooleanMetrics;
import org.jetbrains.kotlin.statistics.metrics.IMetricContainer;
import org.jetbrains.kotlin.statistics.metrics.NumericalMetrics;
import org.jetbrains.kotlin.statistics.metrics.StringMetrics;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \n2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/statistics/KotlinGradleFUSLogger;", "Lcom/intellij/openapi/startup/StartupActivity;", "Lcom/intellij/openapi/project/DumbAware;", "Ljava/lang/Runnable;", "()V", "run", "", "runActivity", "project", "Lcom/intellij/openapi/project/Project;", "Companion", "idea-gradle"})
public final class KotlinGradleFUSLogger
implements StartupActivity,
DumbAware,
Runnable {
    public static final int MAXIMUM_USER_DIRS = 10;
    public static final long EXECUTION_DELAY_MIN = 60L;
    private static final String GRADLE_USER_DIRS_PROPERTY_NAME = "kotlin-gradle-user-dirs";
    private static final AtomicBoolean isRunning;
    public static final Companion Companion;

    public void runActivity(@NotNull Project project2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        AppExecutorUtil.getAppScheduledExecutorService().scheduleWithFixedDelay(this, 60L, 60L, TimeUnit.MINUTES);
    }

    @Override
    public void run() {
        Companion.reportStatistics();
    }

    static {
        Companion = new Companion(null);
        isRunning = new AtomicBoolean(false);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0006J\u001a\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0017H\u0002J\u0006\u0010\u0019\u001a\u00020\u0013J-\u0010\u001a\u001a\u00020\u0013*\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001c2\u0012\u0010\u001d\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\n\"\u00020\u0001H\u0002\u00a2\u0006\u0002\u0010\u001eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R0\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\n2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\n8B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/idea/statistics/KotlinGradleFUSLogger$Companion;", "", "()V", "EXECUTION_DELAY_MIN", "", "GRADLE_USER_DIRS_PROPERTY_NAME", "", "MAXIMUM_USER_DIRS", "", "value", "", "gradleUserDirs", "getGradleUserDirs", "()[Ljava/lang/String;", "setGradleUserDirs", "([Ljava/lang/String;)V", "isRunning", "Ljava/util/concurrent/atomic/AtomicBoolean;", "populateGradleUserDir", "", "path", "processMetricsContainer", "container", "Lorg/jetbrains/kotlin/statistics/fileloggers/MetricsContainer;", "previous", "reportStatistics", "log", "event", "Lorg/jetbrains/kotlin/idea/statistics/GradleStatisticsEvents;", "metrics", "(Lorg/jetbrains/kotlin/statistics/fileloggers/MetricsContainer;Lorg/jetbrains/kotlin/idea/statistics/GradleStatisticsEvents;[Ljava/lang/Object;)V", "idea-gradle"})
    public static final class Companion {
        private final void log(@NotNull MetricsContainer $this$log, GradleStatisticsEvents event, Object ... metrics) {
            HashMap data2 = new HashMap();
            Function2<String, String, Unit> $fun$putIfNotNull$1 = new Function2<String, String, Unit>(data2){
                final /* synthetic */ HashMap $data;

                public final void invoke(@NotNull String key, @Nullable String value2) {
                    Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
                    if (value2 != null) {
                        String string = key;
                        Map map2 = this.$data;
                        boolean bl = false;
                        String string2 = string.toLowerCase();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).toLowerCase()");
                        String string3 = string2;
                        map2.put(string3, value2);
                    }
                }
                {
                    this.$data = hashMap;
                    super(2);
                }
            };
            for (Object metric : metrics) {
                Object object = metric;
                if (object instanceof BooleanMetrics) {
                    IMetricContainer<Boolean> iMetricContainer = $this$log.getMetric((BooleanMetrics)((Object)metric));
                    $fun$putIfNotNull$1.invoke(((BooleanMetrics)((Object)metric)).name(), iMetricContainer != null ? iMetricContainer.toStringRepresentation() : null);
                    continue;
                }
                if (object instanceof StringMetrics) {
                    IMetricContainer<String> iMetricContainer = $this$log.getMetric((StringMetrics)((Object)metric));
                    $fun$putIfNotNull$1.invoke(((StringMetrics)((Object)metric)).name(), iMetricContainer != null ? iMetricContainer.toStringRepresentation() : null);
                    continue;
                }
                if (object instanceof NumericalMetrics) {
                    IMetricContainer<Long> iMetricContainer = $this$log.getMetric((NumericalMetrics)((Object)metric));
                    $fun$putIfNotNull$1.invoke(((NumericalMetrics)((Object)metric)).name(), iMetricContainer != null ? iMetricContainer.toStringRepresentation() : null);
                    continue;
                }
                if (!(object instanceof Pair)) continue;
                $fun$putIfNotNull$1.invoke(String.valueOf(((Pair)metric).getFirst()), String.valueOf(((Pair)metric).getSecond()));
            }
            if (data2.size() > 0) {
                KotlinFUSLogger.Companion.log(FUSEventGroups.GradlePerformance, event.name(), data2);
            }
        }

        private final void processMetricsContainer(MetricsContainer container2, MetricsContainer previous) {
            this.log(container2, GradleStatisticsEvents.Environment, new Object[]{NumericalMetrics.CPU_NUMBER_OF_CORES, StringMetrics.GRADLE_VERSION, NumericalMetrics.ARTIFACTS_DOWNLOAD_SPEED, StringMetrics.IDES_INSTALLED, BooleanMetrics.EXECUTED_FROM_IDEA});
            this.log(container2, GradleStatisticsEvents.Kapt, new Object[]{BooleanMetrics.ENABLED_KAPT, BooleanMetrics.ENABLED_DAGGER, BooleanMetrics.ENABLED_DATABINDING});
            this.log(container2, GradleStatisticsEvents.CompilerPlugins, new Object[]{BooleanMetrics.ENABLED_COMPILER_PLUGIN_ALL_OPEN, BooleanMetrics.ENABLED_COMPILER_PLUGIN_NO_ARG, BooleanMetrics.ENABLED_COMPILER_PLUGIN_JPA_SUPPORT, BooleanMetrics.ENABLED_COMPILER_PLUGIN_SAM_WITH_RECEIVER});
            this.log(container2, GradleStatisticsEvents.MPP, new Object[]{StringMetrics.MPP_PLATFORMS, BooleanMetrics.ENABLED_HMPP});
            this.log(container2, GradleStatisticsEvents.Libraries, new Object[]{StringMetrics.LIBRARY_SPRING_VERSION, StringMetrics.LIBRARY_VAADIN_VERSION, StringMetrics.LIBRARY_GWT_VERSION, StringMetrics.LIBRARY_HIBERNATE_VERSION});
            this.log(container2, GradleStatisticsEvents.GradleConfiguration, new Object[]{NumericalMetrics.GRADLE_DAEMON_HEAP_SIZE, NumericalMetrics.GRADLE_BUILD_NUMBER_IN_CURRENT_DAEMON, NumericalMetrics.CONFIGURATION_API_COUNT, NumericalMetrics.CONFIGURATION_IMPLEMENTATION_COUNT, NumericalMetrics.CONFIGURATION_COMPILE_COUNT, NumericalMetrics.CONFIGURATION_RUNTIME_COUNT, NumericalMetrics.GRADLE_NUMBER_OF_TASKS, NumericalMetrics.GRADLE_NUMBER_OF_UNCONFIGURED_TASKS, NumericalMetrics.GRADLE_NUMBER_OF_INCREMENTAL_TASKS});
            this.log(container2, GradleStatisticsEvents.ComponentVersions, new Object[]{StringMetrics.KOTLIN_COMPILER_VERSION, StringMetrics.KOTLIN_STDLIB_VERSION, StringMetrics.KOTLIN_REFLECT_VERSION, StringMetrics.KOTLIN_COROUTINES_VERSION, StringMetrics.KOTLIN_SERIALIZATION_VERSION, StringMetrics.ANDROID_GRADLE_PLUGIN_VERSION});
            this.log(container2, GradleStatisticsEvents.KotlinFeatures, new Object[]{StringMetrics.KOTLIN_LANGUAGE_VERSION, StringMetrics.KOTLIN_API_VERSION, BooleanMetrics.BUILD_SRC_EXISTS, NumericalMetrics.BUILD_SRC_COUNT, BooleanMetrics.GRADLE_BUILD_CACHE_USED, BooleanMetrics.GRADLE_WORKER_API_USED, BooleanMetrics.KOTLIN_OFFICIAL_CODESTYLE, BooleanMetrics.KOTLIN_PROGRESSIVE_MODE, BooleanMetrics.KOTLIN_KTS_USED});
            this.log(container2, GradleStatisticsEvents.GradlePerformance, new Object[]{NumericalMetrics.GRADLE_BUILD_DURATION, NumericalMetrics.GRADLE_EXECUTION_DURATION, NumericalMetrics.NUMBER_OF_SUBPROJECTS, NumericalMetrics.STATISTICS_VISIT_ALL_PROJECTS_OVERHEAD});
            IMetricContainer<Long> iMetricContainer = container2.getMetric(NumericalMetrics.BUILD_FINISH_TIME);
            Long finishTime = iMetricContainer != null ? iMetricContainer.getValue() : null;
            Object object = previous;
            Long prevFinishTime = object != null && (object = ((MetricsContainer)object).getMetric(NumericalMetrics.BUILD_FINISH_TIME)) != null ? (Long)object.getValue() : null;
            Long betweenBuilds = finishTime != null && prevFinishTime != null ? Long.valueOf(finishTime - prevFinishTime) : null;
            this.log(container2, GradleStatisticsEvents.UseScenarios, new Object[]{new Pair((Object)"time_between_builds", (Object)betweenBuilds), BooleanMetrics.DEBUGGER_ENABLED, BooleanMetrics.COMPILATION_STARTED, BooleanMetrics.TESTS_EXECUTED, BooleanMetrics.MAVEN_PUBLISH_EXECUTED, BooleanMetrics.BUILD_FAILED});
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        public final void reportStatistics() {
            if (isRunning.compareAndSet(false, true)) {
                try {
                    for (String gradleUserHome : this.getGradleUserDirs()) {
                        List<File> list2 = BuildSessionLogger.Companion.listProfileFiles(new File(gradleUserHome, "kotlin-profile"));
                        if (list2 == null) continue;
                        Iterable $this$forEach$iv = list2;
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            File statisticFile = (File)element$iv;
                            boolean bl = false;
                            boolean fileWasRead = true;
                            try {
                                void previousEvent;
                                Ref.ObjectRef objectRef = new Ref.ObjectRef();
                                objectRef.element = null;
                                fileWasRead = MetricsContainer.Companion.readFromFile(statisticFile, (Function1<? super MetricsContainer, Unit>)((Function1)new Function1<MetricsContainer, Unit>((Ref.ObjectRef)previousEvent){
                                    final /* synthetic */ Ref.ObjectRef $previousEvent;

                                    public final void invoke(@NotNull MetricsContainer metricContainer) {
                                        Intrinsics.checkParameterIsNotNull((Object)metricContainer, (String)"metricContainer");
                                        org.jetbrains.kotlin.idea.statistics.KotlinGradleFUSLogger$Companion.access$processMetricsContainer(KotlinGradleFUSLogger.Companion, metricContainer, (MetricsContainer)this.$previousEvent.element);
                                        this.$previousEvent.element = metricContainer;
                                    }
                                    {
                                        this.$previousEvent = objectRef;
                                        super(1);
                                    }
                                }));
                                if (!fileWasRead || statisticFile.delete()) continue;
                            }
                            catch (Exception e) {
                                Logger.getInstance(KotlinFUSLogger.class).info("Failed to process file " + statisticFile.getAbsolutePath() + ": " + e.getMessage(), (Throwable)e);
                                continue;
                            }
                            finally {
                                if (statisticFile.delete()) continue;
                                Logger.getInstance(KotlinFUSLogger.class).warn("[FUS] Failed to delete file " + statisticFile.getAbsolutePath());
                                continue;
                            }
                            Logger.getInstance(KotlinFUSLogger.class).warn("[FUS] Failed to delete file " + statisticFile.getAbsolutePath());
                        }
                    }
                }
                finally {
                    isRunning.set(false);
                }
            }
        }

        private final String[] getGradleUserDirs() {
            String[] stringArray = PropertiesComponent.getInstance().getValues(KotlinGradleFUSLogger.GRADLE_USER_DIRS_PROPERTY_NAME);
            if (stringArray == null) {
                stringArray = new String[]{};
            }
            return stringArray;
        }

        private final void setGradleUserDirs(String[] value2) {
            PropertiesComponent.getInstance().setValues(KotlinGradleFUSLogger.GRADLE_USER_DIRS_PROPERTY_NAME, value2);
        }

        /*
         * WARNING - void declaration
         */
        public final void populateGradleUserDir(@NotNull String path2) {
            void $this$toTypedArray$iv;
            void $this$filterTo$iv$iv;
            Collection $this$filter$iv;
            Intrinsics.checkParameterIsNotNull((Object)path2, (String)"path");
            Object[] currentState = this.getGradleUserDirs();
            if (ArraysKt.contains((Object[])currentState, (Object)path2)) {
                return;
            }
            ArrayList<String> result2 = new ArrayList<String>();
            result2.add(path2);
            CollectionsKt.addAll((Collection)result2, (Object[])currentState);
            Iterable iterable = result2;
            Companion companion = this;
            boolean $i$f$filter = false;
            void var6_7 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String filePath = (String)element$iv$iv;
                boolean bl = false;
                if (!new File(filePath).exists()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            String[] stringArray = (String[])destination$iv$iv;
            $this$filter$iv = CollectionsKt.take((Iterable)((Iterable)stringArray), (int)10);
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
            if (stringArray2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            stringArray = stringArray2;
            companion.setGradleUserDirs(stringArray);
        }

        private Companion() {
        }

        public static final /* synthetic */ void access$processMetricsContainer(Companion $this, MetricsContainer container2, MetricsContainer previous) {
            $this.processMetricsContainer(container2, previous);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

