/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.j2k;

import com.intellij.lang.ASTNode;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiMethodUtil;
import java.util.ListIterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.j2k.Converter;
import org.jetbrains.kotlin.j2k.ReferenceSearcher;
import org.jetbrains.kotlin.j2k.ReferenceSearcherKt;
import org.jetbrains.kotlin.j2k.UtilsKt;
import org.jetbrains.kotlin.j2k.ast.Element;
import org.jetbrains.kotlin.j2k.ast.ElementKt;
import org.jetbrains.kotlin.j2k.ast.Expression;
import org.jetbrains.kotlin.j2k.ast.Identifier;
import org.jetbrains.kotlin.j2k.ast.LiteralExpression;
import org.jetbrains.kotlin.j2k.ast.MethodCallExpression;
import org.jetbrains.kotlin.j2k.ast.Mutability;
import org.jetbrains.kotlin.j2k.ast.PrimitiveType;
import org.jetbrains.kotlin.j2k.ast.Property;
import org.jetbrains.kotlin.j2k.ast.Type;
import org.jetbrains.kotlin.j2k.ast.TypesKt;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000\u0082\u0001\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n\u001a\u0010\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u001a\u000e\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0002\u001a\u0016\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015\u001a\n\u0010\u0016\u001a\u00020\u0002*\u00020\u0017\u001a\u001e\u0010\u0018\u001a\u0004\u0018\u00010\u0002*\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001b\u001a\u00020\u001c\u001a\u001e\u0010\u001d\u001a\u0004\u0018\u00010\u001e*\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001b\u001a\u00020\u001c\u001a\f\u0010\u001f\u001a\u0004\u0018\u00010\u000e*\u00020 \u001a\f\u0010!\u001a\u0004\u0018\u00010\"*\u00020\u000e\u001a\f\u0010#\u001a\u0004\u0018\u00010$*\u00020\u000e\u001a\f\u0010%\u001a\u0004\u0018\u00010$*\u00020\u000e\u001a\n\u0010&\u001a\u00020\f*\u00020'\u001a\u0012\u0010(\u001a\u00020\f*\u00020'2\u0006\u0010)\u001a\u00020*\u001a\n\u0010+\u001a\u00020\f*\u00020\u000e\u001a\n\u0010,\u001a\u00020\f*\u00020$\u001a\n\u0010-\u001a\u00020\f*\u00020.\u001a\u0012\u0010/\u001a\u00020\f*\u00020 2\u0006\u00100\u001a\u00020\"\u001a\n\u00101\u001a\u00020\f*\u00020 \u001a\f\u00102\u001a\u0004\u0018\u00010\u000e*\u000203\u001a\f\u00104\u001a\u0004\u0018\u00010\u000e*\u000203\"\u001d\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\"\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0004\u00a8\u00065"}, d2={"toKotlinMutableTypesMap", "", "", "getToKotlinMutableTypesMap", "()Ljava/util/Map;", "toKotlinTypesMap", "getToKotlinTypesMap", "getDefaultInitializer", "Lorg/jetbrains/kotlin/j2k/ast/Expression;", "property", "Lorg/jetbrains/kotlin/j2k/ast/Property;", "isFacadeClassFromLibrary", "", "element", "Lcom/intellij/psi/PsiElement;", "quoteKeywords", "packageName", "shouldGenerateDefaultInitializer", "searcher", "Lorg/jetbrains/kotlin/j2k/ReferenceSearcher;", "field", "Lcom/intellij/psi/PsiField;", "accessModifier", "Lcom/intellij/psi/PsiModifierListOwner;", "convertToKotlinAnalog", "Lorg/jetbrains/kotlin/j2k/Converter;", "classQualifiedName", "mutability", "Lorg/jetbrains/kotlin/j2k/ast/Mutability;", "convertToKotlinAnalogIdentifier", "Lorg/jetbrains/kotlin/j2k/ast/Identifier;", "dot", "Lcom/intellij/psi/PsiReferenceExpression;", "getContainingClass", "Lcom/intellij/psi/PsiClass;", "getContainingConstructor", "Lcom/intellij/psi/PsiMethod;", "getContainingMethod", "isConstructor", "Lcom/intellij/psi/PsiMember;", "isImported", "file", "Lcom/intellij/psi/PsiJavaFile;", "isInSingleLine", "isMainMethod", "isNullLiteral", "Lcom/intellij/psi/PsiExpression;", "isQualifierEmptyOrClass", "psiClass", "isQualifierEmptyOrThis", "lPar", "Lcom/intellij/psi/PsiExpressionList;", "rPar", "j2k"})
public final class UtilsKt {
    @NotNull
    private static final Map<String, String> toKotlinTypesMap;
    @NotNull
    private static final Map<String, String> toKotlinMutableTypesMap;

    @NotNull
    public static final String quoteKeywords(@NotNull String packageName) {
        Intrinsics.checkParameterIsNotNull((Object)packageName, (String)"packageName");
        return CollectionsKt.joinToString$default((Iterable)StringsKt.split$default((CharSequence)packageName, (char[])new char[]{'.'}, (boolean)false, (int)0, (int)6, null), (CharSequence)".", null, null, (int)0, null, (Function1)quoteKeywords.1.INSTANCE, (int)30, null);
    }

    @Nullable
    public static final Expression getDefaultInitializer(@NotNull Property property2) {
        Expression result2;
        Expression expression2;
        Intrinsics.checkParameterIsNotNull((Object)property2, (String)"property");
        Type t = property2.getType();
        if (t.isNullable()) {
            expression2 = new LiteralExpression("null");
        } else if (t instanceof PrimitiveType) {
            switch (((PrimitiveType)t).getName().getName()) {
                case "Boolean": {
                    expression2 = new LiteralExpression("false");
                    break;
                }
                case "Char": {
                    expression2 = new LiteralExpression("' '");
                    break;
                }
                case "Double": {
                    Expression expression3 = (Expression)ElementKt.assignNoPrototype((Element)new LiteralExpression("0"));
                    String string = OperatorConventions.DOUBLE.toString();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"OperatorConventions.DOUBLE.toString()");
                    expression2 = MethodCallExpression.Companion.buildNonNull$default(MethodCallExpression.Companion, expression3, string, null, null, null, 28, null);
                    break;
                }
                case "Float": {
                    Expression expression4 = (Expression)ElementKt.assignNoPrototype((Element)new LiteralExpression("0"));
                    String string = OperatorConventions.FLOAT.toString();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"OperatorConventions.FLOAT.toString()");
                    expression2 = MethodCallExpression.Companion.buildNonNull$default(MethodCallExpression.Companion, expression4, string, null, null, null, 28, null);
                    break;
                }
                default: {
                    expression2 = new LiteralExpression("0");
                    break;
                }
            }
        } else {
            expression2 = null;
        }
        Expression expression5 = result2 = expression2;
        return expression5 != null ? (Expression)ElementKt.assignNoPrototype((Element)expression5) : null;
    }

    public static final boolean shouldGenerateDefaultInitializer(@NotNull ReferenceSearcher searcher2, @NotNull PsiField field2) {
        Intrinsics.checkParameterIsNotNull((Object)searcher2, (String)"searcher");
        Intrinsics.checkParameterIsNotNull((Object)field2, (String)"field");
        return field2.getInitializer() == null && (ReferenceSearcherKt.isVar(field2, searcher2) || !ReferenceSearcherKt.hasWriteAccesses((PsiVariable)field2, searcher2, (PsiElement)field2.getContainingClass()));
    }

    public static final boolean isQualifierEmptyOrThis(@NotNull PsiReferenceExpression $this$isQualifierEmptyOrThis) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isQualifierEmptyOrThis, (String)"$this$isQualifierEmptyOrThis");
        PsiExpression qualifier2 = $this$isQualifierEmptyOrThis.getQualifierExpression();
        return qualifier2 == null || qualifier2 instanceof PsiThisExpression && ((PsiThisExpression)qualifier2).getQualifier() == null;
    }

    public static final boolean isQualifierEmptyOrClass(@NotNull PsiReferenceExpression $this$isQualifierEmptyOrClass, @NotNull PsiClass psiClass2) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isQualifierEmptyOrClass, (String)"$this$isQualifierEmptyOrClass");
        Intrinsics.checkParameterIsNotNull((Object)psiClass2, (String)"psiClass");
        PsiExpression qualifier2 = $this$isQualifierEmptyOrClass.getQualifierExpression();
        return qualifier2 == null || qualifier2 instanceof PsiReferenceExpression && ((PsiReferenceExpression)qualifier2).isReferenceTo((PsiElement)psiClass2);
    }

    public static final boolean isInSingleLine(@NotNull PsiElement $this$isInSingleLine) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isInSingleLine, (String)"$this$isInSingleLine");
        if ($this$isInSingleLine instanceof PsiWhiteSpace) {
            String text2;
            String string = ((PsiWhiteSpace)$this$isInSingleLine).getText();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            return StringsKt.indexOf$default((CharSequence)(text2 = string), (char)'\n', (int)0, (boolean)false, (int)6, null) < 0 && StringsKt.indexOf$default((CharSequence)text2, (char)'\r', (int)0, (boolean)false, (int)6, null) < 0;
        }
        for (PsiElement child = $this$isInSingleLine.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (UtilsKt.isInSingleLine(child)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static final PsiMethod getContainingMethod(@NotNull PsiElement $this$getContainingMethod) {
        Intrinsics.checkParameterIsNotNull((Object)$this$getContainingMethod, (String)"$this$getContainingMethod");
        PsiElement context2 = $this$getContainingMethod.getContext();
        while (context2 != null) {
            PsiElement _context = context2;
            if (_context instanceof PsiMethod) {
                return (PsiMethod)_context;
            }
            context2 = _context.getContext();
        }
        return null;
    }

    @Nullable
    public static final PsiClass getContainingClass(@NotNull PsiElement $this$getContainingClass) {
        Intrinsics.checkParameterIsNotNull((Object)$this$getContainingClass, (String)"$this$getContainingClass");
        PsiElement context2 = $this$getContainingClass.getContext();
        while (context2 != null) {
            PsiElement _context = context2;
            if (_context instanceof PsiClass) {
                return (PsiClass)_context;
            }
            if (_context instanceof PsiMember) {
                return ((PsiMember)_context).getContainingClass();
            }
            context2 = _context.getContext();
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static final PsiMethod getContainingConstructor(@NotNull PsiElement $this$getContainingConstructor) {
        PsiMethod method;
        Intrinsics.checkParameterIsNotNull((Object)$this$getContainingConstructor, (String)"$this$getContainingConstructor");
        PsiMethod psiMethod = method = UtilsKt.getContainingMethod($this$getContainingConstructor);
        if (psiMethod == null) return null;
        if (!psiMethod.isConstructor()) return null;
        PsiMethod psiMethod2 = method;
        return psiMethod2;
    }

    public static final boolean isConstructor(@NotNull PsiMember $this$isConstructor) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isConstructor, (String)"$this$isConstructor");
        return $this$isConstructor instanceof PsiMethod && ((PsiMethod)$this$isConstructor).isConstructor();
    }

    @NotNull
    public static final String accessModifier(@NotNull PsiModifierListOwner $this$accessModifier) {
        Intrinsics.checkParameterIsNotNull((Object)$this$accessModifier, (String)"$this$accessModifier");
        return $this$accessModifier.hasModifierProperty("public") ? "public" : ($this$accessModifier.hasModifierProperty("private") ? "private" : ($this$accessModifier.hasModifierProperty("protected") ? "protected" : "packageLocal"));
    }

    public static final boolean isMainMethod(@NotNull PsiMethod $this$isMainMethod) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isMainMethod, (String)"$this$isMainMethod");
        return PsiMethodUtil.isMainMethod((PsiMethod)$this$isMainMethod);
    }

    @Nullable
    public static final PsiElement dot(@NotNull PsiReferenceExpression $this$dot) {
        Intrinsics.checkParameterIsNotNull((Object)$this$dot, (String)"$this$dot");
        ASTNode aSTNode = $this$dot.getNode().findChildByType(JavaTokenType.DOT);
        return aSTNode != null ? aSTNode.getPsi() : null;
    }

    @Nullable
    public static final PsiElement lPar(@NotNull PsiExpressionList $this$lPar) {
        Intrinsics.checkParameterIsNotNull((Object)$this$lPar, (String)"$this$lPar");
        ASTNode aSTNode = $this$lPar.getNode().findChildByType(JavaTokenType.LPARENTH);
        return aSTNode != null ? aSTNode.getPsi() : null;
    }

    @Nullable
    public static final PsiElement rPar(@NotNull PsiExpressionList $this$rPar) {
        Intrinsics.checkParameterIsNotNull((Object)$this$rPar, (String)"$this$rPar");
        ASTNode aSTNode = $this$rPar.getNode().findChildByType(JavaTokenType.RPARENTH);
        return aSTNode != null ? aSTNode.getPsi() : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isImported(@NotNull PsiMember $this$isImported, @NotNull PsiJavaFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isImported, (String)"$this$isImported");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        if ($this$isImported instanceof PsiClass) {
            String string;
            int index2;
            String fqName2;
            String string2 = fqName2 = ((PsiClass)$this$isImported).getQualifiedName();
            int n = index2 = string2 != null ? StringsKt.lastIndexOf$default((CharSequence)string2, (char)'.', (int)0, (boolean)false, (int)6, null) : -1;
            if (index2 >= 0) {
                String string3 = fqName2;
                if (string3 == null) {
                    Intrinsics.throwNpe();
                }
                String string4 = string3;
                int n2 = 0;
                boolean bl = false;
                String string5 = string4;
                if (string5 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string6 = string5.substring(n2, index2);
                string = string6;
                Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            } else {
                string = null;
            }
            String parentName = string;
            PsiImportStatementBase[] psiImportStatementBaseArray = file2.getImportList();
            PsiImportStatementBase[] psiImportStatementBaseArray2 = psiImportStatementBaseArray;
            if (psiImportStatementBaseArray == null) return false;
            PsiImportStatementBase[] psiImportStatementBaseArray3 = psiImportStatementBaseArray2.getAllImportStatements();
            psiImportStatementBaseArray2 = psiImportStatementBaseArray3;
            if (psiImportStatementBaseArray3 == null) return false;
            PsiImportStatementBase[] $this$any$iv = psiImportStatementBaseArray2;
            boolean $i$f$any = false;
            PsiImportStatementBase[] psiImportStatementBaseArray4 = $this$any$iv;
            int n3 = psiImportStatementBaseArray4.length;
            int n4 = 0;
            while (n4 < n3) {
                PsiImportStatementBase element$iv;
                PsiImportStatementBase it = element$iv = psiImportStatementBaseArray4[n4];
                boolean bl = false;
                PsiImportStatementBase psiImportStatementBase = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)psiImportStatementBase, (String)"it");
                PsiJavaCodeReferenceElement psiJavaCodeReferenceElement = psiImportStatementBase.getImportReference();
                if (Intrinsics.areEqual((Object)(psiJavaCodeReferenceElement != null ? psiJavaCodeReferenceElement.getQualifiedName() : null), (Object)(it.isOnDemand() ? parentName : fqName2))) {
                    return true;
                }
                ++n4;
            }
            return false;
        }
        if ($this$isImported.getContainingClass() == null) return false;
        PsiImportStaticStatement[] psiImportStaticStatementArray = file2.getImportList();
        PsiImportStaticStatement[] psiImportStaticStatementArray2 = psiImportStaticStatementArray;
        if (psiImportStaticStatementArray == null) return false;
        PsiImportStaticStatement[] psiImportStaticStatementArray3 = psiImportStaticStatementArray2.getImportStaticStatements();
        psiImportStaticStatementArray2 = psiImportStaticStatementArray3;
        if (psiImportStaticStatementArray3 == null) return false;
        PsiImportStaticStatement[] $this$any$iv = psiImportStaticStatementArray2;
        boolean $i$f$any = false;
        PsiImportStaticStatement[] psiImportStaticStatementArray4 = $this$any$iv;
        int n = psiImportStaticStatementArray4.length;
        int n5 = 0;
        while (n5 < n) {
            PsiImportStaticStatement element$iv;
            PsiImportStaticStatement it = element$iv = psiImportStaticStatementArray4[n5];
            boolean bl = false;
            if (Intrinsics.areEqual((Object)it.resolveTargetClass(), (Object)$this$isImported.getContainingClass())) {
                PsiImportStaticStatement psiImportStaticStatement = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)psiImportStaticStatement, (String)"it");
                if (psiImportStaticStatement.isOnDemand()) return true;
                if (Intrinsics.areEqual((Object)it.getReferenceName(), (Object)$this$isImported.getName())) {
                    return true;
                }
            }
            boolean bl2 = false;
            if (bl2) {
                return true;
            }
            ++n5;
        }
        return false;
    }

    public static final boolean isNullLiteral(@NotNull PsiExpression $this$isNullLiteral) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isNullLiteral, (String)"$this$isNullLiteral");
        return $this$isNullLiteral instanceof PsiLiteralExpression && Intrinsics.areEqual((Object)((PsiLiteralExpression)$this$isNullLiteral).getType(), (Object)PsiType.NULL);
    }

    public static final boolean isFacadeClassFromLibrary(@Nullable PsiElement element3) {
        return element3 instanceof KtLightClass && ((KtLightClass)element3).getKotlinOrigin() == null;
    }

    @Nullable
    public static final String convertToKotlinAnalog(@NotNull Converter $this$convertToKotlinAnalog, @Nullable String classQualifiedName, @NotNull Mutability mutability) {
        Intrinsics.checkParameterIsNotNull((Object)$this$convertToKotlinAnalog, (String)"$this$convertToKotlinAnalog");
        Intrinsics.checkParameterIsNotNull((Object)((Object)mutability), (String)"mutability");
        if (classQualifiedName == null) {
            return null;
        }
        String string = TypesKt.isMutable(mutability, $this$convertToKotlinAnalog.getSettings()) ? toKotlinMutableTypesMap.get(classQualifiedName) : null;
        if (string == null) {
            string = toKotlinTypesMap.get(classQualifiedName);
        }
        return string;
    }

    @Nullable
    public static final Identifier convertToKotlinAnalogIdentifier(@NotNull Converter $this$convertToKotlinAnalogIdentifier, @Nullable String classQualifiedName, @NotNull Mutability mutability) {
        Intrinsics.checkParameterIsNotNull((Object)$this$convertToKotlinAnalogIdentifier, (String)"$this$convertToKotlinAnalogIdentifier");
        Intrinsics.checkParameterIsNotNull((Object)((Object)mutability), (String)"mutability");
        String string = UtilsKt.convertToKotlinAnalog($this$convertToKotlinAnalogIdentifier, classQualifiedName, mutability);
        if (string == null) {
            return null;
        }
        String kotlinClassName = string;
        return Identifier.Companion.withNoPrototype$default(Identifier.Companion, StringsKt.substringAfterLast$default((String)kotlinClassName, (char)'.', null, (int)2, null), false, false, null, 14, null);
    }

    @NotNull
    public static final Map<String, String> getToKotlinTypesMap() {
        return toKotlinTypesMap;
    }

    @NotNull
    public static final Map<String, String> getToKotlinMutableTypesMap() {
        return toKotlinMutableTypesMap;
    }

    static {
        Pair[] pairArray = new Pair[17];
        String string = KotlinBuiltIns.FQ_NAMES.any.asString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"KotlinBuiltIns.FQ_NAMES.any.asString()");
        pairArray[0] = TuplesKt.to((Object)"java.lang.Object", (Object)string);
        String string2 = KotlinBuiltIns.FQ_NAMES._byte.asString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"KotlinBuiltIns.FQ_NAMES._byte.asString()");
        pairArray[1] = TuplesKt.to((Object)"java.lang.Byte", (Object)string2);
        String string3 = KotlinBuiltIns.FQ_NAMES._char.asString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"KotlinBuiltIns.FQ_NAMES._char.asString()");
        pairArray[2] = TuplesKt.to((Object)"java.lang.Character", (Object)string3);
        String string4 = KotlinBuiltIns.FQ_NAMES._double.asString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"KotlinBuiltIns.FQ_NAMES._double.asString()");
        pairArray[3] = TuplesKt.to((Object)"java.lang.Double", (Object)string4);
        String string5 = KotlinBuiltIns.FQ_NAMES._float.asString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"KotlinBuiltIns.FQ_NAMES._float.asString()");
        pairArray[4] = TuplesKt.to((Object)"java.lang.Float", (Object)string5);
        String string6 = KotlinBuiltIns.FQ_NAMES._int.asString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"KotlinBuiltIns.FQ_NAMES._int.asString()");
        pairArray[5] = TuplesKt.to((Object)"java.lang.Integer", (Object)string6);
        String string7 = KotlinBuiltIns.FQ_NAMES._long.asString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"KotlinBuiltIns.FQ_NAMES._long.asString()");
        pairArray[6] = TuplesKt.to((Object)"java.lang.Long", (Object)string7);
        String string8 = KotlinBuiltIns.FQ_NAMES._short.asString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"KotlinBuiltIns.FQ_NAMES._short.asString()");
        pairArray[7] = TuplesKt.to((Object)"java.lang.Short", (Object)string8);
        String string9 = KotlinBuiltIns.FQ_NAMES._boolean.asString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string9, (String)"KotlinBuiltIns.FQ_NAMES._boolean.asString()");
        pairArray[8] = TuplesKt.to((Object)"java.lang.Boolean", (Object)string9);
        String string10 = KotlinBuiltIns.FQ_NAMES.iterable.asString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string10, (String)"KotlinBuiltIns.FQ_NAMES.iterable.asString()");
        pairArray[9] = TuplesKt.to((Object)"java.lang.Iterable", (Object)string10);
        String string11 = KotlinBuiltIns.FQ_NAMES.iterator.asString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string11, (String)"KotlinBuiltIns.FQ_NAMES.iterator.asString()");
        pairArray[10] = TuplesKt.to((Object)"java.util.Iterator", (Object)string11);
        String string12 = KotlinBuiltIns.FQ_NAMES.list.asString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string12, (String)"KotlinBuiltIns.FQ_NAMES.list.asString()");
        pairArray[11] = TuplesKt.to((Object)"java.util.List", (Object)string12);
        String string13 = KotlinBuiltIns.FQ_NAMES.collection.asString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string13, (String)"KotlinBuiltIns.FQ_NAMES.collection.asString()");
        pairArray[12] = TuplesKt.to((Object)"java.util.Collection", (Object)string13);
        String string14 = KotlinBuiltIns.FQ_NAMES.set.asString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string14, (String)"KotlinBuiltIns.FQ_NAMES.set.asString()");
        pairArray[13] = TuplesKt.to((Object)"java.util.Set", (Object)string14);
        String string15 = KotlinBuiltIns.FQ_NAMES.map.asString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string15, (String)"KotlinBuiltIns.FQ_NAMES.map.asString()");
        pairArray[14] = TuplesKt.to((Object)"java.util.Map", (Object)string15);
        String string16 = KotlinBuiltIns.FQ_NAMES.mapEntry.asString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string16, (String)"KotlinBuiltIns.FQ_NAMES.mapEntry.asString()");
        pairArray[15] = TuplesKt.to((Object)"java.util.Map.Entry", (Object)string16);
        String string17 = ListIterator.class.getCanonicalName();
        String string18 = KotlinBuiltIns.FQ_NAMES.listIterator.asString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string18, (String)"KotlinBuiltIns.FQ_NAMES.listIterator.asString()");
        pairArray[16] = TuplesKt.to((Object)string17, (Object)string18);
        toKotlinTypesMap = MapsKt.mapOf((Pair[])pairArray);
        Pair[] pairArray2 = new Pair[7];
        String string19 = KotlinBuiltIns.FQ_NAMES.mutableIterator.asString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string19, (String)"KotlinBuiltIns.FQ_NAMES.mutableIterator.asString()");
        pairArray2[0] = TuplesKt.to((Object)"java.util.Iterator", (Object)string19);
        String string20 = KotlinBuiltIns.FQ_NAMES.mutableList.asString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string20, (String)"KotlinBuiltIns.FQ_NAMES.mutableList.asString()");
        pairArray2[1] = TuplesKt.to((Object)"java.util.List", (Object)string20);
        String string21 = KotlinBuiltIns.FQ_NAMES.mutableCollection.asString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string21, (String)"KotlinBuiltIns.FQ_NAMES.\u2026ableCollection.asString()");
        pairArray2[2] = TuplesKt.to((Object)"java.util.Collection", (Object)string21);
        String string22 = KotlinBuiltIns.FQ_NAMES.mutableSet.asString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string22, (String)"KotlinBuiltIns.FQ_NAMES.mutableSet.asString()");
        pairArray2[3] = TuplesKt.to((Object)"java.util.Set", (Object)string22);
        String string23 = KotlinBuiltIns.FQ_NAMES.mutableMap.asString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string23, (String)"KotlinBuiltIns.FQ_NAMES.mutableMap.asString()");
        pairArray2[4] = TuplesKt.to((Object)"java.util.Map", (Object)string23);
        String string24 = KotlinBuiltIns.FQ_NAMES.mutableMapEntry.asString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string24, (String)"KotlinBuiltIns.FQ_NAMES.mutableMapEntry.asString()");
        pairArray2[5] = TuplesKt.to((Object)"java.util.Map.Entry", (Object)string24);
        String string25 = ListIterator.class.getCanonicalName();
        String string26 = KotlinBuiltIns.FQ_NAMES.mutableListIterator.asString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string26, (String)"KotlinBuiltIns.FQ_NAMES.\u2026leListIterator.asString()");
        pairArray2[6] = TuplesKt.to((Object)string25, (Object)string26);
        toKotlinMutableTypesMap = MapsKt.mapOf((Pair[])pairArray2);
    }
}

