/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.CompanionObjectMapping;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FieldDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.util.capitalizeDecapitalize.CapitalizeDecapitalizeKt;

public final class JvmAbi {
    public static final String DEFAULT_IMPLS_CLASS_NAME = "DefaultImpls";
    public static final String ERASED_INLINE_CONSTRUCTOR_NAME = "constructor";
    public static final FqName JVM_FIELD_ANNOTATION_FQ_NAME = new FqName("kotlin.jvm.JvmField");
    public static final String DEFAULT_IMPLS_SUFFIX = "$DefaultImpls";
    public static final String DEFAULT_PARAMS_IMPL_SUFFIX = "$default";
    private static final String GET_PREFIX = "get";
    private static final String IS_PREFIX = "is";
    private static final String SET_PREFIX = "set";
    public static final String DELEGATED_PROPERTY_NAME_SUFFIX = "$delegate";
    public static final String DELEGATED_PROPERTIES_ARRAY_NAME = "$$delegatedProperties";
    public static final String DELEGATE_SUPER_FIELD_PREFIX = "$$delegate_";
    private static final String ANNOTATIONS_SUFFIX = "$annotations";
    public static final String ANNOTATED_PROPERTY_METHOD_NAME_SUFFIX = "$annotations";
    private static final String ANNOTATED_TYPEALIAS_METHOD_NAME_SUFFIX = "$annotations";
    public static final String INSTANCE_FIELD = "INSTANCE";
    public static final String HIDDEN_INSTANCE_FIELD = "$$INSTANCE";
    public static final ClassId REFLECTION_FACTORY_IMPL = ClassId.topLevel(new FqName("kotlin.reflect.jvm.internal.ReflectionFactoryImpl"));
    public static final String LOCAL_VARIABLE_NAME_PREFIX_INLINE_ARGUMENT = "$i$a$";
    public static final String LOCAL_VARIABLE_NAME_PREFIX_INLINE_FUNCTION = "$i$f$";
    public static final String IMPL_SUFFIX_FOR_INLINE_CLASS_MEMBERS = "-impl";

    @NotNull
    public static String getSyntheticMethodNameForAnnotatedProperty(@NotNull String baseName) {
        if (baseName == null) {
            JvmAbi.$$$reportNull$$$0(0);
        }
        String string = baseName + "$annotations";
        if (string == null) {
            JvmAbi.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public static String getSyntheticMethodNameForAnnotatedTypeAlias(@NotNull Name typeAliasName) {
        if (typeAliasName == null) {
            JvmAbi.$$$reportNull$$$0(2);
        }
        String string = typeAliasName.asString() + "$annotations";
        if (string == null) {
            JvmAbi.$$$reportNull$$$0(3);
        }
        return string;
    }

    public static boolean isGetterName(@NotNull String name2) {
        if (name2 == null) {
            JvmAbi.$$$reportNull$$$0(4);
        }
        return name2.startsWith(GET_PREFIX) || name2.startsWith(IS_PREFIX);
    }

    public static boolean isSetterName(@NotNull String name2) {
        if (name2 == null) {
            JvmAbi.$$$reportNull$$$0(5);
        }
        return name2.startsWith(SET_PREFIX);
    }

    @NotNull
    public static String getterName(@NotNull String propertyName) {
        if (propertyName == null) {
            JvmAbi.$$$reportNull$$$0(6);
        }
        String string = JvmAbi.startsWithIsPrefix(propertyName) ? propertyName : GET_PREFIX + CapitalizeDecapitalizeKt.capitalizeAsciiOnly(propertyName);
        if (string == null) {
            JvmAbi.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public static String setterName(@NotNull String propertyName) {
        if (propertyName == null) {
            JvmAbi.$$$reportNull$$$0(8);
        }
        String string = SET_PREFIX + (JvmAbi.startsWithIsPrefix(propertyName) ? propertyName.substring(IS_PREFIX.length()) : CapitalizeDecapitalizeKt.capitalizeAsciiOnly(propertyName));
        if (string == null) {
            JvmAbi.$$$reportNull$$$0(9);
        }
        return string;
    }

    public static boolean startsWithIsPrefix(String name2) {
        if (!name2.startsWith(IS_PREFIX)) {
            return false;
        }
        if (name2.length() == IS_PREFIX.length()) {
            return false;
        }
        char c = name2.charAt(IS_PREFIX.length());
        return 'a' > c || c > 'z';
    }

    public static boolean isPropertyWithBackingFieldInOuterClass(@NotNull PropertyDescriptor propertyDescriptor) {
        if (propertyDescriptor == null) {
            JvmAbi.$$$reportNull$$$0(10);
        }
        if (propertyDescriptor.getKind() == CallableMemberDescriptor.Kind.FAKE_OVERRIDE) {
            return false;
        }
        if (JvmAbi.isClassCompanionObjectWithBackingFieldsInOuter(propertyDescriptor.getContainingDeclaration())) {
            return true;
        }
        return DescriptorUtils.isCompanionObject(propertyDescriptor.getContainingDeclaration()) && JvmAbi.hasJvmFieldAnnotation(propertyDescriptor);
    }

    public static boolean isClassCompanionObjectWithBackingFieldsInOuter(@NotNull DeclarationDescriptor companionObject) {
        if (companionObject == null) {
            JvmAbi.$$$reportNull$$$0(11);
        }
        return DescriptorUtils.isCompanionObject(companionObject) && DescriptorUtils.isClassOrEnumClass(companionObject.getContainingDeclaration()) && !JvmAbi.isMappedIntrinsicCompanionObject((ClassDescriptor)companionObject);
    }

    public static boolean isMappedIntrinsicCompanionObject(@NotNull ClassDescriptor companionObject) {
        if (companionObject == null) {
            JvmAbi.$$$reportNull$$$0(12);
        }
        return CompanionObjectMapping.INSTANCE.isMappedIntrinsicCompanionObject(companionObject);
    }

    public static boolean hasJvmFieldAnnotation(@NotNull CallableMemberDescriptor memberDescriptor) {
        FieldDescriptor field2;
        if (memberDescriptor == null) {
            JvmAbi.$$$reportNull$$$0(13);
        }
        if (memberDescriptor instanceof PropertyDescriptor && (field2 = ((PropertyDescriptor)memberDescriptor).getBackingField()) != null && field2.getAnnotations().hasAnnotation(JVM_FIELD_ANNOTATION_FQ_NAME)) {
            return true;
        }
        return memberDescriptor.getAnnotations().hasAnnotation(JVM_FIELD_ANNOTATION_FQ_NAME);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseName";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/load/java/JvmAbi";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeAliasName";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyDescriptor";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "companionObject";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/load/java/JvmAbi";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSyntheticMethodNameForAnnotatedProperty";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSyntheticMethodNameForAnnotatedTypeAlias";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getterName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "setterName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSyntheticMethodNameForAnnotatedProperty";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 9: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSyntheticMethodNameForAnnotatedTypeAlias";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isGetterName";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isSetterName";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getterName";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setterName";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isPropertyWithBackingFieldInOuterClass";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isClassCompanionObjectWithBackingFieldsInOuter";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isMappedIntrinsicCompanionObject";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "hasJvmFieldAnnotation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

