/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.nj2k;

import com.intellij.openapi.project.Project;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.util.RefactoringChangeUtil;
import org.jetbrains.annotations.Nullable;

public class FixTypeArguments {
    @Nullable
    public static PsiExpression addTypeArguments(PsiExpression expression2, PsiType toType) {
        if (!PsiUtil.isLanguageLevel5OrHigher((PsiElement)expression2)) {
            return null;
        }
        if (expression2 instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression methodCall = (PsiMethodCallExpression)expression2;
            PsiReferenceParameterList list2 = methodCall.getMethodExpression().getParameterList();
            if (list2 == null || list2.getTypeArguments().length > 0) {
                return null;
            }
            JavaResolveResult resolveResult = methodCall.resolveMethodGenerics();
            PsiElement element3 = resolveResult.getElement();
            if (element3 instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)element3;
                PsiType returnType2 = method.getReturnType();
                if (returnType2 == null) {
                    return null;
                }
                PsiTypeParameter[] typeParameters2 = method.getTypeParameters();
                if (typeParameters2.length > 0) {
                    PsiType[] mappings = PsiType.createArray((int)typeParameters2.length);
                    PsiResolveHelper helper2 = JavaPsiFacade.getInstance((Project)expression2.getProject()).getResolveHelper();
                    LanguageLevel level = PsiUtil.getLanguageLevel((PsiElement)expression2);
                    for (int i2 = 0; i2 < typeParameters2.length; ++i2) {
                        PsiType substitution2;
                        PsiTypeParameter typeParameter = typeParameters2[i2];
                        if (toType == null) {
                            substitution2 = resolveResult.getSubstitutor().substitute(typeParameter);
                            if (!PsiTypesUtil.isDenotableType((PsiType)substitution2, (PsiElement)element3)) {
                                return null;
                            }
                        } else {
                            substitution2 = helper2.getSubstitutionForTypeParameter(typeParameter, returnType2, toType, false, level);
                        }
                        if (substitution2 == null || PsiType.NULL.equals((Object)substitution2)) {
                            return null;
                        }
                        mappings[i2] = GenericsUtil.eliminateWildcards((PsiType)substitution2, (boolean)false);
                    }
                    PsiElementFactory factory2 = JavaPsiFacade.getElementFactory((Project)expression2.getProject());
                    PsiMethodCallExpression copy2 = (PsiMethodCallExpression)expression2.copy();
                    PsiReferenceExpression methodExpression = copy2.getMethodExpression();
                    PsiReferenceParameterList parameterList2 = methodExpression.getParameterList();
                    for (PsiType mapping2 : mappings) {
                        parameterList2.add((PsiElement)factory2.createTypeElement(mapping2));
                    }
                    if (methodExpression.getQualifierExpression() == null) {
                        PsiClass containingClass2 = method.getContainingClass();
                        Object qualifierExpression = method.hasModifierProperty("static") ? factory2.createReferenceExpression(containingClass2) : RefactoringChangeUtil.createThisExpression((PsiManager)method.getManager(), null);
                        methodExpression.setQualifierExpression((PsiExpression)qualifierExpression);
                    }
                    return copy2;
                }
            }
        }
        return null;
    }
}

