/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.nj2k.conversions;

import java.math.BigInteger;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.nj2k.NewJ2kConverterContext;
import org.jetbrains.kotlin.nj2k.conversions.LiteralConversion;
import org.jetbrains.kotlin.nj2k.conversions.LiteralConversion$WhenMappings;
import org.jetbrains.kotlin.nj2k.conversions.RecursiveApplicableConversionBase;
import org.jetbrains.kotlin.nj2k.tree.JKLiteralExpression;
import org.jetbrains.kotlin.nj2k.tree.JKTreeElement;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\f\u0010\b\u001a\u00020\t*\u00020\tH\u0002J\f\u0010\n\u001a\u00020\t*\u00020\tH\u0002J\u0014\u0010\u000b\u001a\u00020\t*\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0002J\f\u0010\u000e\u001a\u00020\t*\u00020\u000fH\u0002J\u0014\u0010\u0010\u001a\u00020\t*\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0002J\f\u0010\u0011\u001a\u00020\u0012*\u00020\u000fH\u0002J\u0014\u0010\u0013\u001a\u00020\t*\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0002J\f\u0010\u0014\u001a\u00020\t*\u00020\u000fH\u0002J\f\u0010\u0015\u001a\u00020\t*\u00020\u000fH\u0002J\f\u0010\u0016\u001a\u00020\t*\u00020\u000fH\u0002J\f\u0010\u0017\u001a\u00020\t*\u00020\u000fH\u0002J\f\u0010\u0018\u001a\u00020\t*\u00020\u000fH\u0002\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/nj2k/conversions/LiteralConversion;", "Lorg/jetbrains/kotlin/nj2k/conversions/RecursiveApplicableConversionBase;", "context", "Lorg/jetbrains/kotlin/nj2k/NewJ2kConverterContext;", "(Lorg/jetbrains/kotlin/nj2k/NewJ2kConverterContext;)V", "applyToElement", "Lorg/jetbrains/kotlin/nj2k/tree/JKTreeElement;", "element", "cleanFloatAndDoubleLiterals", "", "cleanIntAndLongLiterals", "convertBinaryLiteral", "isLongLiteral", "", "convertCharLiteral", "Lorg/jetbrains/kotlin/nj2k/tree/JKLiteralExpression;", "convertHexLiteral", "convertLiteral", "", "convertOctalLiteral", "toDoubleLiteral", "toFloatLiteral", "toIntLiteral", "toLongLiteral", "toStringLiteral", "nj2k"})
public final class LiteralConversion
extends RecursiveApplicableConversionBase {
    @Override
    @NotNull
    public JKTreeElement applyToElement(@NotNull JKTreeElement element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        if (!(element3 instanceof JKLiteralExpression)) {
            return this.recurse(element3);
        }
        this.convertLiteral((JKLiteralExpression)element3);
        return this.recurse(element3);
    }

    private final void convertLiteral(@NotNull JKLiteralExpression $this$convertLiteral) {
        String string;
        switch (LiteralConversion$WhenMappings.$EnumSwitchMapping$0[$this$convertLiteral.getType().ordinal()]) {
            case 1: {
                string = this.toDoubleLiteral($this$convertLiteral);
                break;
            }
            case 2: {
                string = this.toFloatLiteral($this$convertLiteral);
                break;
            }
            case 3: {
                string = this.toLongLiteral($this$convertLiteral);
                break;
            }
            case 4: {
                string = this.toIntLiteral($this$convertLiteral);
                break;
            }
            case 5: {
                string = this.convertCharLiteral($this$convertLiteral);
                break;
            }
            case 6: {
                string = this.toStringLiteral($this$convertLiteral);
                break;
            }
            default: {
                return;
            }
        }
        $this$convertLiteral.setLiteral(string);
    }

    private final String toDoubleLiteral(@NotNull JKLiteralExpression $this$toDoubleLiteral) {
        String string = this.cleanFloatAndDoubleLiterals($this$toDoubleLiteral.getLiteral());
        boolean bl = false;
        boolean bl2 = false;
        String text2 = string;
        boolean bl3 = false;
        string = !StringsKt.contains$default((CharSequence)text2, (CharSequence)".", (boolean)false, (int)2, null) && !StringsKt.contains((CharSequence)text2, (CharSequence)"e", (boolean)true) ? text2 + '.' : text2;
        bl = false;
        bl2 = false;
        text2 = string;
        boolean bl4 = false;
        return StringsKt.endsWith$default((String)text2, (String)".", (boolean)false, (int)2, null) ? text2 + '0' : text2;
    }

    private final String toFloatLiteral(@NotNull JKLiteralExpression $this$toFloatLiteral) {
        String string = this.cleanFloatAndDoubleLiterals($this$toFloatLiteral.getLiteral());
        boolean bl = false;
        boolean bl2 = false;
        String text2 = string;
        boolean bl3 = false;
        return !StringsKt.endsWith$default((String)text2, (String)"f", (boolean)false, (int)2, null) ? text2 + 'f' : text2;
    }

    private final String toStringLiteral(@NotNull JKLiteralExpression $this$toStringLiteral) {
        CharSequence charSequence = $this$toStringLiteral.getLiteral();
        String string = "((?:\\\\)*)\\\\([0-3]?[0-7]{1,2})";
        boolean bl = false;
        string = new Regex(string);
        Function1 function1 = toStringLiteral.1.INSTANCE;
        boolean bl2 = false;
        charSequence = string.replace(charSequence, function1);
        string = "(?<!\\\\)\\$([A-Za-z]+|\\{)";
        boolean bl3 = false;
        string = new Regex(string);
        String string2 = "\\\\$0";
        bl2 = false;
        return string.replace(charSequence, string2);
    }

    private final String convertCharLiteral(@NotNull JKLiteralExpression $this$convertCharLiteral) {
        CharSequence charSequence = $this$convertCharLiteral.getLiteral();
        String string = "\\\\([0-3]?[0-7]{1,2})";
        boolean bl = false;
        string = new Regex(string);
        Function1 function1 = convertCharLiteral.1.INSTANCE;
        boolean bl2 = false;
        return string.replace(charSequence, function1);
    }

    private final String toIntLiteral(@NotNull JKLiteralExpression $this$toIntLiteral) {
        return this.convertOctalLiteral(this.convertBinaryLiteral(this.convertHexLiteral(this.cleanIntAndLongLiterals($this$toIntLiteral.getLiteral()), false), false), false);
    }

    private final String toLongLiteral(@NotNull JKLiteralExpression $this$toLongLiteral) {
        return this.convertOctalLiteral(this.convertBinaryLiteral(this.convertHexLiteral(this.cleanIntAndLongLiterals($this$toLongLiteral.getLiteral()), true), true), true) + "L";
    }

    private final String convertHexLiteral(@NotNull String $this$convertHexLiteral, boolean isLongLiteral) {
        String string;
        if (!StringsKt.startsWith((String)$this$convertHexLiteral, (String)"0x", (boolean)true)) {
            return $this$convertHexLiteral;
        }
        BigInteger value2 = new BigInteger(StringsKt.drop((String)$this$convertHexLiteral, (int)2), 16);
        if (isLongLiteral && value2.bitLength() > 63) {
            String string2;
            long l = value2.longValue();
            int n = 16;
            StringBuilder stringBuilder2 = new StringBuilder().append("-0x");
            boolean bl = false;
            String string3 = Long.toString(l, CharsKt.checkRadix((int)n));
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"java.lang.Long.toString(this, checkRadix(radix))");
            String string4 = string2 = string3;
            int n2 = 1;
            n = 0;
            String string5 = string4;
            if (string5 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string6 = string5.substring(n2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.String).substring(startIndex)");
            string2 = string6;
            string = stringBuilder2.append(string2).toString();
        } else if (!isLongLiteral && value2.bitLength() > 31) {
            String string7;
            int n = value2.intValue();
            int n3 = 16;
            StringBuilder stringBuilder3 = new StringBuilder().append("-0x");
            boolean bl = false;
            String string8 = Integer.toString(n, CharsKt.checkRadix((int)n3));
            Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"java.lang.Integer.toStri\u2026(this, checkRadix(radix))");
            String string9 = string7 = string8;
            n3 = 1;
            bl = false;
            String string10 = string9;
            if (string10 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string11 = string10.substring(n3);
            Intrinsics.checkExpressionValueIsNotNull((Object)string11, (String)"(this as java.lang.String).substring(startIndex)");
            string7 = string11;
            string = stringBuilder3.append(string7).toString();
        } else {
            string = $this$convertHexLiteral;
        }
        return string;
    }

    private final String convertBinaryLiteral(@NotNull String $this$convertBinaryLiteral, boolean isLongLiteral) {
        String string;
        if (!StringsKt.startsWith((String)$this$convertBinaryLiteral, (String)"0b", (boolean)true)) {
            return $this$convertBinaryLiteral;
        }
        BigInteger value2 = new BigInteger(StringsKt.drop((String)$this$convertBinaryLiteral, (int)2), 2);
        if (isLongLiteral) {
            long l = value2.longValue();
            int n = 10;
            boolean bl = false;
            String string2 = Long.toString(l, CharsKt.checkRadix((int)n));
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.Long.toString(this, checkRadix(radix))");
        } else {
            string = String.valueOf(value2.intValue());
        }
        return string;
    }

    private final String convertOctalLiteral(@NotNull String $this$convertOctalLiteral, boolean isLongLiteral) {
        String string;
        int n;
        block6: {
            block5: {
                if (!StringsKt.startsWith$default((String)$this$convertOctalLiteral, (String)"0", (boolean)false, (int)2, null) || $this$convertOctalLiteral.length() == 1) break block5;
                char c = $this$convertOctalLiteral.charAt(1);
                n = 0;
                if (Character.toLowerCase(c) != 'x') break block6;
            }
            return $this$convertOctalLiteral;
        }
        BigInteger value2 = new BigInteger(StringsKt.drop((String)$this$convertOctalLiteral, (int)1), 8);
        if (isLongLiteral) {
            long l = value2.longValue();
            int n2 = 10;
            boolean bl = false;
            String string2 = Long.toString(l, CharsKt.checkRadix((int)n2));
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.Long.toString(this, checkRadix(radix))");
        } else {
            n = value2.intValue();
            int n3 = 10;
            boolean bl = false;
            String string3 = Integer.toString(n, CharsKt.checkRadix((int)n3));
            string = string3;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"java.lang.Integer.toStri\u2026(this, checkRadix(radix))");
        }
        return string;
    }

    private final String cleanFloatAndDoubleLiterals(@NotNull String $this$cleanFloatAndDoubleLiterals) {
        return StringsKt.replace$default((String)StringsKt.replace((String)StringsKt.replace((String)StringsKt.replace((String)StringsKt.replace((String)StringsKt.replace((String)$this$cleanFloatAndDoubleLiterals, (String)"L", (String)"", (boolean)true), (String)"d", (String)"", (boolean)true), (String)".e", (String)"e", (boolean)true), (String)".f", (String)"", (boolean)true), (String)"f", (String)"", (boolean)true), (String)"_", (String)"", (boolean)false, (int)4, null);
    }

    private final String cleanIntAndLongLiterals(@NotNull String $this$cleanIntAndLongLiterals) {
        return StringsKt.replace$default((String)StringsKt.replace((String)$this$cleanIntAndLongLiterals, (String)"l", (String)"", (boolean)true), (String)"_", (String)"", (boolean)false, (int)4, null);
    }

    public LiteralConversion(@NotNull NewJ2kConverterContext context2) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        super(context2);
    }
}

