/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.preloading.instrumentation;

import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.kotlin.preloading.instrumentation.MethodData;

class MethodInstrumenter {
    private final String debugName;
    private final Pattern classPattern;
    private final Pattern namePattern;
    private final Pattern descPattern;
    private final boolean allowMultipleMatches;
    private final List<MethodData> enterData;
    private final List<MethodData> normalReturnData;
    private final List<MethodData> exceptionData;
    private final boolean logApplications;
    private final boolean dumpByteCode;

    public MethodInstrumenter(String debugName, Pattern classPattern, Pattern namePattern, Pattern descPattern, boolean allowMultipleMatches, List<MethodData> enterData, List<MethodData> normalReturnData, List<MethodData> exceptionData, boolean logApplications, boolean dumpByteCode) {
        this.debugName = debugName;
        this.classPattern = classPattern;
        this.namePattern = namePattern;
        this.descPattern = descPattern;
        this.allowMultipleMatches = allowMultipleMatches;
        this.enterData = enterData;
        this.normalReturnData = normalReturnData;
        this.exceptionData = exceptionData;
        this.logApplications = logApplications;
        this.dumpByteCode = dumpByteCode;
    }

    public boolean allowsMultipleMatches() {
        return this.allowMultipleMatches;
    }

    public void reportApplication(String className2, String methodName2, String methodDesc) {
        if (this.logApplications) {
            System.out.println(this.toString() + " applied to " + className2 + ":" + methodName2 + methodDesc);
        }
    }

    public boolean isApplicable(String name2, String desc2) {
        return this.namePattern.matcher(name2).matches() && this.descPattern.matcher(desc2).matches();
    }

    public List<MethodData> getEnterData() {
        return this.enterData;
    }

    public List<MethodData> getNormalReturnData() {
        return this.normalReturnData;
    }

    public List<MethodData> getExceptionData() {
        return this.exceptionData;
    }

    boolean shouldDumpByteCode() {
        return this.dumpByteCode;
    }

    public String toString() {
        return this.debugName + "[" + this.classPattern + ":" + this.namePattern + " " + this.descPattern + (this.allowMultipleMatches ? " multiple" : "") + "]";
    }
}

