/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.PsiDiagnosticUtils;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;

public class AnalyzingUtils {
    private static final boolean WRITE_DEBUG_TRACE_NAMES = false;

    public static void checkForSyntacticErrors(@NotNull PsiElement root2) {
        if (root2 == null) {
            AnalyzingUtils.$$$reportNull$$$0(0);
        }
        root2.acceptChildren((PsiElementVisitor)new PsiErrorElementVisitor(){

            @Override
            public void visitErrorElement(@NotNull PsiErrorElement element3) {
                if (element3 == null) {
                    1.$$$reportNull$$$0(0);
                }
                throw new IllegalArgumentException(element3.getErrorDescription() + "; looking at " + element3.getNode().getElementType() + " '" + element3.getText() + PsiDiagnosticUtils.atLocation((PsiElement)element3));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/resolve/AnalyzingUtils$1", "visitErrorElement"));
            }
        });
    }

    public static List<PsiErrorElement> getSyntaxErrorRanges(@NotNull PsiElement root2) {
        if (root2 == null) {
            AnalyzingUtils.$$$reportNull$$$0(1);
        }
        final ArrayList<PsiErrorElement> r = new ArrayList<PsiErrorElement>();
        root2.acceptChildren((PsiElementVisitor)new PsiErrorElementVisitor(){

            @Override
            public void visitErrorElement(@NotNull PsiErrorElement element3) {
                if (element3 == null) {
                    2.$$$reportNull$$$0(0);
                }
                r.add(element3);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/resolve/AnalyzingUtils$2", "visitErrorElement"));
            }
        });
        return r;
    }

    public static void throwExceptionOnErrors(BindingContext bindingContext2) {
        AnalyzingUtils.throwExceptionOnErrors(bindingContext2.getDiagnostics());
    }

    public static void throwExceptionOnErrors(Diagnostics diagnostics2) {
        for (Diagnostic diagnostic : diagnostics2) {
            DiagnosticSink.THROW_EXCEPTION.report(diagnostic);
        }
    }

    public static String formDebugNameForBindingTrace(@NotNull String debugName, @Nullable Object resolutionSubjectForMessage) {
        if (debugName == null) {
            AnalyzingUtils.$$$reportNull$$$0(2);
        }
        return "";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugName";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/resolve/AnalyzingUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkForSyntacticErrors";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getSyntaxErrorRanges";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "formDebugNameForBindingTrace";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static abstract class PsiErrorElementVisitor
    extends KtTreeVisitorVoid {
        public abstract void visitErrorElement(@NotNull PsiErrorElement var1);
    }
}

