/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import java.util.ArrayList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.SimpleFunctionDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\fJ$\u0010\u0017\u001a\u00020\n2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00100\u00192\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u0004J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0004H\u0002J\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/resolve/DataClassDescriptorResolver;", "", "()V", "COMPONENT_FUNCTION_NAME_PREFIX", "", "COPY_METHOD_NAME", "Lorg/jetbrains/kotlin/name/Name;", "getCOPY_METHOD_NAME", "()Lorg/jetbrains/kotlin/name/Name;", "createComponentFunctionDescriptor", "Lorg/jetbrains/kotlin/descriptors/SimpleFunctionDescriptor;", "parameterIndex", "", "property", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "parameter", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "createComponentName", "index", "createCopyFunctionDescriptor", "constructorParameters", "", "getComponentIndex", "componentName", "isComponentLike", "", "name", "frontend"})
public final class DataClassDescriptorResolver {
    @NotNull
    private static final Name COPY_METHOD_NAME;
    private static final String COMPONENT_FUNCTION_NAME_PREFIX = "component";
    public static final DataClassDescriptorResolver INSTANCE;

    @NotNull
    public final Name getCOPY_METHOD_NAME() {
        return COPY_METHOD_NAME;
    }

    @NotNull
    public final Name createComponentName(int index2) {
        Name name2 = Name.identifier(COMPONENT_FUNCTION_NAME_PREFIX + index2);
        Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"Name.identifier(COMPONEN\u2026TION_NAME_PREFIX + index)");
        return name2;
    }

    public final int getComponentIndex(@NotNull String componentName) {
        Intrinsics.checkParameterIsNotNull((Object)componentName, (String)"componentName");
        String string = componentName;
        int n = COMPONENT_FUNCTION_NAME_PREFIX.length();
        boolean bl = false;
        String string2 = string.substring(n);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
        string = string2;
        n = 0;
        return Integer.parseInt(string);
    }

    public final boolean isComponentLike(@NotNull Name name2) {
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        String string = name2.asString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name.asString()");
        return this.isComponentLike(string);
    }

    private final boolean isComponentLike(String name2) {
        if (!StringsKt.startsWith$default((String)name2, (String)COMPONENT_FUNCTION_NAME_PREFIX, (boolean)false, (int)2, null)) {
            return false;
        }
        try {
            this.getComponentIndex(name2);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    @NotNull
    public final SimpleFunctionDescriptor createComponentFunctionDescriptor(int parameterIndex2, @NotNull PropertyDescriptor property2, @NotNull ValueParameterDescriptor parameter, @NotNull ClassDescriptor classDescriptor2, @NotNull BindingTrace trace) {
        Intrinsics.checkParameterIsNotNull((Object)property2, (String)"property");
        Intrinsics.checkParameterIsNotNull((Object)parameter, (String)"parameter");
        Intrinsics.checkParameterIsNotNull((Object)classDescriptor2, (String)"classDescriptor");
        Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
        SimpleFunctionDescriptorImpl simpleFunctionDescriptorImpl = SimpleFunctionDescriptorImpl.create(classDescriptor2, Annotations.Companion.getEMPTY(), this.createComponentName(parameterIndex2), CallableMemberDescriptor.Kind.SYNTHESIZED, parameter.getSource());
        Intrinsics.checkExpressionValueIsNotNull((Object)simpleFunctionDescriptorImpl, (String)"SimpleFunctionDescriptor\u2026arameter.source\n        )");
        SimpleFunctionDescriptorImpl functionDescriptor2 = simpleFunctionDescriptorImpl;
        functionDescriptor2.initialize((ReceiverParameterDescriptor)null, classDescriptor2.getThisAsReceiverParameter(), CollectionsKt.emptyList(), CollectionsKt.emptyList(), property2.getType(), Modality.FINAL, property2.getVisibility());
        functionDescriptor2.setOperator(true);
        trace.record(BindingContext.DATA_CLASS_COMPONENT_FUNCTION, parameter, functionDescriptor2);
        return functionDescriptor2;
    }

    @NotNull
    public final SimpleFunctionDescriptor createCopyFunctionDescriptor(@NotNull Collection<? extends ValueParameterDescriptor> constructorParameters, @NotNull ClassDescriptor classDescriptor2, @NotNull BindingTrace trace) {
        Intrinsics.checkParameterIsNotNull(constructorParameters, (String)"constructorParameters");
        Intrinsics.checkParameterIsNotNull((Object)classDescriptor2, (String)"classDescriptor");
        Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
        SimpleFunctionDescriptorImpl simpleFunctionDescriptorImpl = SimpleFunctionDescriptorImpl.create(classDescriptor2, Annotations.Companion.getEMPTY(), COPY_METHOD_NAME, CallableMemberDescriptor.Kind.SYNTHESIZED, classDescriptor2.getSource());
        Intrinsics.checkExpressionValueIsNotNull((Object)simpleFunctionDescriptorImpl, (String)"SimpleFunctionDescriptor\u2026scriptor.source\n        )");
        SimpleFunctionDescriptorImpl functionDescriptor2 = simpleFunctionDescriptorImpl;
        boolean bl = false;
        ArrayList<ValueParameterDescriptorImpl> parameterDescriptors = new ArrayList<ValueParameterDescriptorImpl>();
        for (ValueParameterDescriptor valueParameterDescriptor : constructorParameters) {
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)trace.getBindingContext().get(BindingContext.VALUE_PARAMETER_AS_PROPERTY, valueParameterDescriptor);
            boolean declaresDefaultValue = propertyDescriptor != null;
            CallableDescriptor callableDescriptor = functionDescriptor2;
            int n = valueParameterDescriptor.getIndex();
            Annotations annotations2 = valueParameterDescriptor.getAnnotations();
            Name name2 = valueParameterDescriptor.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"parameter.name");
            KotlinType kotlinType = valueParameterDescriptor.getType();
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"parameter.type");
            boolean bl2 = valueParameterDescriptor.isCrossinline();
            boolean bl3 = valueParameterDescriptor.isNoinline();
            KotlinType kotlinType2 = valueParameterDescriptor.getVarargElementType();
            SourceElement sourceElement = valueParameterDescriptor.getSource();
            Intrinsics.checkExpressionValueIsNotNull((Object)sourceElement, (String)"parameter.source");
            ValueParameterDescriptorImpl parameterDescriptor = new ValueParameterDescriptorImpl(callableDescriptor, null, n, annotations2, name2, kotlinType, declaresDefaultValue, bl2, bl3, kotlinType2, sourceElement);
            parameterDescriptors.add(parameterDescriptor);
            if (!declaresDefaultValue) continue;
            trace.record(BindingContext.VALUE_PARAMETER_AS_PROPERTY, parameterDescriptor, propertyDescriptor);
        }
        functionDescriptor2.initialize((ReceiverParameterDescriptor)null, classDescriptor2.getThisAsReceiverParameter(), CollectionsKt.emptyList(), parameterDescriptors, (KotlinType)classDescriptor2.getDefaultType(), Modality.FINAL, Visibilities.PUBLIC);
        trace.record(BindingContext.DATA_CLASS_COPY_FUNCTION, classDescriptor2, functionDescriptor2);
        return functionDescriptor2;
    }

    private DataClassDescriptorResolver() {
    }

    static {
        DataClassDescriptorResolver dataClassDescriptorResolver;
        INSTANCE = dataClassDescriptorResolver = new DataClassDescriptorResolver();
        Name name2 = Name.identifier("copy");
        Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"Name.identifier(\"copy\")");
        COPY_METHOD_NAME = name2;
        COMPONENT_FUNCTION_NAME_PREFIX = COMPONENT_FUNCTION_NAME_PREFIX;
    }
}

