/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.Forceable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.containers.SLRUMap;
import com.intellij.util.containers.ShareableKey;
import com.intellij.util.io.DataEnumeratorEx;
import com.intellij.util.io.DifferentSerializableBytesImplyNonEqualityPolicy;
import com.intellij.util.io.InlineKeyDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentEnumerator;
import com.intellij.util.io.ResizeableMappedFile;
import com.intellij.util.io.keyStorage.AppendableObjectStorage;
import com.intellij.util.io.keyStorage.AppendableStorageBackedByResizableMappedFile;
import com.intellij.util.io.keyStorage.InlinedKeyStorage;
import com.intellij.util.io.keyStorage.NoDataException;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PersistentEnumeratorBase<Data>
implements DataEnumeratorEx<Data>,
Forceable,
Closeable {
    protected static final Logger LOG = Logger.getInstance(PersistentEnumerator.class);
    protected static final int NULL_ID = 0;
    private static final int META_DATA_OFFSET = 4;
    static final int DATA_START = 20;
    private static final CacheKey ourFlyweight = new FlyweightKey();
    protected final ResizeableMappedFile myStorage;
    @NotNull
    private final AppendableObjectStorage<Data> myKeyStorage;
    final KeyDescriptor<Data> myDataDescriptor;
    protected final Path myFile;
    private final Version myVersion;
    private final boolean myDoCaching;
    private volatile boolean myDirtyStatusUpdateInProgress;
    private boolean myClosed;
    private boolean myDirty;
    private boolean myCorrupted;
    private RecordBufferHandler<PersistentEnumeratorBase<?>> myRecordHandler;
    private Flushable myMarkCleanCallback;
    private static final int ENUMERATION_CACHE_SIZE;
    private static final SLRUMap<Object, Integer> ourEnumerationCache;

    private static CacheKey sharedKey(Object key, PersistentEnumeratorBase owner) {
        PersistentEnumeratorBase.ourFlyweight.key = key;
        PersistentEnumeratorBase.ourFlyweight.owner = owner;
        return ourFlyweight;
    }

    public static void clearCacheForTests() {
        ourEnumerationCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PersistentEnumeratorBase(@NotNull Path file, @NotNull ResizeableMappedFile storage, @NotNull KeyDescriptor<Data> dataDescriptor, int initialSize, @NotNull Version version, @NotNull RecordBufferHandler<? extends PersistentEnumeratorBase<?>> recordBufferHandler, boolean doCaching) throws IOException {
        block25: {
            if (file == null) {
                PersistentEnumeratorBase.$$$reportNull$$$0(0);
            }
            if (storage == null) {
                PersistentEnumeratorBase.$$$reportNull$$$0(1);
            }
            if (dataDescriptor == null) {
                PersistentEnumeratorBase.$$$reportNull$$$0(2);
            }
            if (version == null) {
                PersistentEnumeratorBase.$$$reportNull$$$0(3);
            }
            if (recordBufferHandler == null) {
                PersistentEnumeratorBase.$$$reportNull$$$0(4);
            }
            this.myDataDescriptor = dataDescriptor;
            this.myFile = file;
            this.myVersion = version;
            this.myRecordHandler = recordBufferHandler;
            this.myDoCaching = doCaching;
            if (!Files.exists(file, new LinkOption[0])) {
                if (file.getFileSystem().isReadOnly()) {
                    throw new IOException(file + " in " + file.getFileSystem() + " is not exist");
                }
                FileUtil.delete(this.keyStreamFile());
                if (!FileUtil.createIfDoesntExist(file.toFile())) {
                    throw new IOException("Cannot create empty file: " + file);
                }
            }
            this.myStorage = storage;
            this.lockStorageWrite();
            try {
                int sign;
                if (this.myStorage.length() == 0L) {
                    try {
                        this.markDirty(true);
                        this.putMetaData(0L);
                        this.putMetaData2(0L);
                        this.setupEmptyFile();
                        break block25;
                    }
                    catch (RuntimeException e) {
                        LOG.info(e);
                        this.myStorage.close();
                        if (e.getCause() instanceof IOException) {
                            throw (IOException)e.getCause();
                        }
                        throw e;
                    }
                    catch (IOException e) {
                        LOG.info(e);
                        this.myStorage.close();
                        throw e;
                    }
                    catch (Exception e) {
                        LOG.info(e);
                        this.myStorage.close();
                        throw new CorruptedException(file);
                    }
                }
                try {
                    sign = this.myStorage.getInt(0L);
                }
                catch (Exception e) {
                    LOG.info(e);
                    sign = this.myVersion.dirtyMagic;
                }
                if (sign != this.myVersion.correctlyClosedMagic) {
                    this.myStorage.close();
                    if (sign != this.myVersion.dirtyMagic) {
                        throw new VersionUpdatedException(file);
                    }
                    throw new CorruptedException(file);
                }
            }
            finally {
                this.unlockStorageWrite();
            }
        }
        if (dataDescriptor instanceof InlineKeyDescriptor) {
            this.myKeyStorage = new InlinedKeyStorage((InlineKeyDescriptor)dataDescriptor);
        } else {
            try {
                this.myKeyStorage = new AppendableStorageBackedByResizableMappedFile<Data>(this.keyStreamFile(), initialSize, this.myStorage.getPagedFileStorage().getStorageLockContext(), 0x100000, false, dataDescriptor);
            }
            catch (Throwable e) {
                LOG.info(e);
                this.myStorage.close();
                throw new CorruptedException(file);
            }
        }
    }

    @NotNull
    protected Object getDataAccessLock() {
        PersistentEnumeratorBase persistentEnumeratorBase = this;
        if (persistentEnumeratorBase == null) {
            PersistentEnumeratorBase.$$$reportNull$$$0(5);
        }
        return persistentEnumeratorBase;
    }

    void lockStorageRead() {
        this.myStorage.getPagedFileStorage().lockRead();
    }

    void unlockStorageRead() {
        this.myStorage.getPagedFileStorage().unlockRead();
    }

    void lockStorageWrite() {
        this.myStorage.getPagedFileStorage().lockWrite();
    }

    void unlockStorageWrite() {
        this.myStorage.getPagedFileStorage().unlockWrite();
    }

    protected abstract void setupEmptyFile() throws IOException;

    @NotNull
    final RecordBufferHandler<PersistentEnumeratorBase<?>> getRecordHandler() {
        RecordBufferHandler<PersistentEnumeratorBase<?>> recordBufferHandler = this.myRecordHandler;
        if (recordBufferHandler == null) {
            PersistentEnumeratorBase.$$$reportNull$$$0(6);
        }
        return recordBufferHandler;
    }

    public void setRecordHandler(@NotNull RecordBufferHandler<PersistentEnumeratorBase<?>> recordHandler) {
        if (recordHandler == null) {
            PersistentEnumeratorBase.$$$reportNull$$$0(7);
        }
        this.myRecordHandler = recordHandler;
    }

    void setMarkCleanCallback(Flushable markCleanCallback) {
        this.myMarkCleanCallback = markCleanCallback;
    }

    public Data getValue(int keyId, int processingKey) throws IOException {
        return this.valueOf(keyId);
    }

    @Override
    public int tryEnumerate(Data value) throws IOException {
        return this.doEnumerate(value, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doEnumerate(Data value, boolean onlyCheckForExisting, boolean saveNewValue) throws IOException {
        int id;
        if (this.myDoCaching && !saveNewValue) {
            SLRUMap<Object, Integer> sLRUMap = ourEnumerationCache;
            synchronized (sLRUMap) {
                Integer cachedId = ourEnumerationCache.get(PersistentEnumeratorBase.sharedKey(value, this));
                if (cachedId != null) {
                    return cachedId;
                }
            }
        }
        try {
            id = this.enumerateImpl(value, onlyCheckForExisting, saveNewValue);
        }
        catch (Throwable e) {
            if (!this.isCorrupted()) {
                this.markCorrupted();
                LOG.info("Marking corrupted:" + this.myFile, e);
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e);
        }
        if (this.myDoCaching && id != 0) {
            SLRUMap<Object, Integer> sLRUMap = ourEnumerationCache;
            synchronized (sLRUMap) {
                ourEnumerationCache.put(new CacheKey(value, this), id);
            }
        }
        return id;
    }

    @Override
    public int enumerate(Data value) throws IOException {
        return this.doEnumerate(value, false, false);
    }

    protected void putMetaData(long data) {
        this.lockStorageWrite();
        try {
            if (this.myStorage.length() < 12L || this.getMetaData() != data) {
                this.myStorage.putLong(4L, data);
            }
        }
        finally {
            this.unlockStorageWrite();
        }
    }

    protected long getMetaData() {
        this.lockStorageRead();
        try {
            long l = this.myStorage.getLong(4L);
            return l;
        }
        finally {
            this.unlockStorageRead();
        }
    }

    void putMetaData2(long data) {
        this.lockStorageWrite();
        try {
            if (this.myStorage.length() < 20L || this.getMetaData2() != data) {
                this.myStorage.putLong(12L, data);
            }
        }
        finally {
            this.unlockStorageWrite();
        }
    }

    long getMetaData2() {
        this.lockStorageRead();
        try {
            long l = this.myStorage.getLong(12L);
            return l;
        }
        finally {
            this.unlockStorageRead();
        }
    }

    public boolean processAllDataObject(final @NotNull Processor<? super Data> processor, final @Nullable DataFilter filter) throws IOException {
        if (processor == null) {
            PersistentEnumeratorBase.$$$reportNull$$$0(8);
        }
        return this.traverseAllRecords(new RecordsProcessor(){

            @Override
            public boolean process(int record) throws IOException {
                if (filter == null || filter.accept(record)) {
                    return processor.process(PersistentEnumeratorBase.this.valueOf(record));
                }
                return true;
            }
        });
    }

    @NotNull
    public Collection<Data> getAllDataObjects(@Nullable DataFilter filter) throws IOException {
        ArrayList values = new ArrayList();
        this.processAllDataObject(new CommonProcessors.CollectProcessor(values), filter);
        ArrayList arrayList = values;
        if (arrayList == null) {
            PersistentEnumeratorBase.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    public abstract boolean traverseAllRecords(RecordsProcessor var1) throws IOException;

    protected abstract int enumerateImpl(Data var1, boolean var2, boolean var3) throws IOException;

    protected boolean isKeyAtIndex(Data value, int idx) throws IOException {
        if (this.myKeyStorage instanceof InlinedKeyStorage) {
            return false;
        }
        int addr = this.indexToAddr(idx);
        if (this.myKeyStorage.checkBytesAreTheSame(addr, value)) {
            return true;
        }
        if (this.myDataDescriptor instanceof DifferentSerializableBytesImplyNonEqualityPolicy) {
            return false;
        }
        return this.myDataDescriptor.isEqual(this.valueOf(idx), value);
    }

    protected int writeData(Data value, int hashCode) {
        try {
            this.markDirty(true);
            int dataOff = this.doWriteData(value);
            return this.setupValueId(hashCode, dataOff);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int getLargestId() {
        return this.myKeyStorage.getCurrentLength();
    }

    protected int doWriteData(Data value) throws IOException {
        return this.myKeyStorage.append(value);
    }

    protected int setupValueId(int hashCode, int dataOff) {
        byte[] buf = this.myRecordHandler.getRecordBuffer(this);
        this.myRecordHandler.setupRecord(this, hashCode, dataOff, buf);
        int pos = this.myRecordHandler.recordWriteOffset(this, buf);
        this.myStorage.put(pos, buf, 0, buf.length);
        return pos;
    }

    public boolean iterateData(@NotNull Processor<? super Data> processor) throws IOException {
        if (processor == null) {
            PersistentEnumeratorBase.$$$reportNull$$$0(10);
        }
        this.lockStorageWrite();
        try {
            this.myKeyStorage.force();
        }
        finally {
            this.unlockStorageWrite();
        }
        return this.myKeyStorage.processAll(processor);
    }

    private Path keyStreamFile() {
        return this.myFile.resolveSibling(this.myFile.getFileName() + ".keystream");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Data valueOf(int idx) throws IOException {
        if (idx <= 0) {
            return null;
        }
        try {
            this.lockStorageRead();
            try {
                int addr = this.indexToAddr(idx);
                Data Data = this.myKeyStorage.read(addr);
                return Data;
            }
            finally {
                this.unlockStorageRead();
            }
        }
        catch (NoDataException e) {
            this.markCorrupted();
            return null;
        }
        catch (IOException io) {
            this.markCorrupted();
            throw io;
        }
        catch (Throwable e) {
            this.markCorrupted();
            throw new RuntimeException(e);
        }
    }

    int reEnumerate(Data key) throws IOException {
        if (!this.canReEnumerate()) {
            throw new IncorrectOperationException();
        }
        return this.doEnumerate(key, false, true);
    }

    boolean canReEnumerate() {
        return false;
    }

    protected abstract int indexToAddr(int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.getDataAccessLock();
        synchronized (object) {
            this.lockStorageWrite();
            try {
                if (!this.myClosed) {
                    this.myClosed = true;
                    this.doClose();
                }
            }
            finally {
                this.unlockStorageWrite();
            }
        }
    }

    protected void doClose() throws IOException {
        try {
            this.myKeyStorage.close();
            this.flush();
        }
        finally {
            this.myStorage.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        Object object = this.getDataAccessLock();
        synchronized (object) {
            return this.myClosed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDirty() {
        Object object = this.getDataAccessLock();
        synchronized (object) {
            return this.myDirty;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCorrupted() {
        Object object = this.getDataAccessLock();
        synchronized (object) {
            return this.myCorrupted;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flush() throws IOException {
        Object object = this.getDataAccessLock();
        synchronized (object) {
            this.lockStorageWrite();
            try {
                if (this.myStorage.isDirty() || this.isDirty()) {
                    this.doFlush();
                }
            }
            finally {
                this.unlockStorageWrite();
            }
        }
    }

    protected void doFlush() throws IOException {
        this.markDirty(false);
        this.myStorage.force();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void force() {
        Object object = this.getDataAccessLock();
        synchronized (object) {
            this.lockStorageWrite();
            try {
                this.myKeyStorage.force();
                this.flush();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                this.unlockStorageWrite();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void markDirty(boolean dirty) throws IOException {
        Object object = this.getDataAccessLock();
        synchronized (object) {
            if (dirty && this.myDirty && !this.myDirtyStatusUpdateInProgress) {
                return;
            }
            this.lockStorageWrite();
            try {
                if (this.myDirty) {
                    if (!dirty) {
                        this.myDirtyStatusUpdateInProgress = true;
                        if (this.myMarkCleanCallback != null) {
                            this.myMarkCleanCallback.flush();
                        }
                        if (!this.myCorrupted) {
                            this.myStorage.putInt(0L, this.myVersion.correctlyClosedMagic);
                            this.myDirty = false;
                        }
                        this.myDirtyStatusUpdateInProgress = false;
                    }
                } else if (dirty) {
                    this.myDirtyStatusUpdateInProgress = true;
                    this.myStorage.putInt(0L, this.myVersion.dirtyMagic);
                    this.myDirtyStatusUpdateInProgress = false;
                    this.myDirty = true;
                }
            }
            finally {
                this.unlockStorageWrite();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void markCorrupted() {
        Object object = this.getDataAccessLock();
        synchronized (object) {
            if (!this.myCorrupted) {
                this.myCorrupted = true;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Marking corrupted:" + this.myFile, new Throwable());
                }
                try {
                    this.markDirty(true);
                    this.force();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    static {
        String property = System.getProperty("idea.enumerationCacheSize");
        ENUMERATION_CACHE_SIZE = property == null ? 8192 : Integer.valueOf(property);
        ourEnumerationCache = new SLRUMap(ENUMERATION_CACHE_SIZE, ENUMERATION_CACHE_SIZE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataDescriptor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recordBufferHandler";
                break;
            }
            case 5: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/io/PersistentEnumeratorBase";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recordHandler";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/io/PersistentEnumeratorBase";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataAccessLock";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRecordHandler";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllDataObjects";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 9: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setRecordHandler";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processAllDataObject";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "iterateData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FlyweightKey
    extends CacheKey {
        FlyweightKey() {
            super(null, null);
        }

        @Override
        public ShareableKey getStableCopy() {
            return new CacheKey(this.key, this.owner);
        }
    }

    public static abstract class RecordsProcessor {
        private int myKey;

        public abstract boolean process(int var1) throws IOException;

        void setCurrentKey(int key) {
            this.myKey = key;
        }

        int getCurrentKey() {
            return this.myKey;
        }
    }

    public static interface DataFilter {
        public boolean accept(int var1);
    }

    public static class VersionUpdatedException
    extends CorruptedException {
        VersionUpdatedException(@NotNull Path file) {
            if (file == null) {
                VersionUpdatedException.$$$reportNull$$$0(0);
            }
            super("PersistentEnumerator storage corrupted " + file);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/io/PersistentEnumeratorBase$VersionUpdatedException", "<init>"));
        }
    }

    public static class CorruptedException
    extends IOException {
        public CorruptedException(Path file) {
            this("PersistentEnumerator storage corrupted " + file);
        }

        protected CorruptedException(String message) {
            super(message);
        }
    }

    private static class CacheKey
    implements ShareableKey {
        public PersistentEnumeratorBase<?> owner;
        public Object key;

        private CacheKey(Object key, PersistentEnumeratorBase<?> owner) {
            this.key = key;
            this.owner = owner;
        }

        @Override
        public ShareableKey getStableCopy() {
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            if (!this.key.equals(cacheKey.key)) {
                return false;
            }
            return this.owner.equals(cacheKey.owner);
        }

        public int hashCode() {
            return this.key.hashCode();
        }
    }

    static abstract class RecordBufferHandler<T extends PersistentEnumeratorBase<?>> {
        RecordBufferHandler() {
        }

        abstract int recordWriteOffset(T var1, byte[] var2);

        abstract byte @NotNull [] getRecordBuffer(T var1);

        abstract void setupRecord(T var1, int var2, int var3, byte[] var4);
    }

    public static class Version {
        private static final int DIRTY_MAGIC = -1161946761;
        private static final int CORRECTLY_CLOSED_MAGIC = 247118589;
        private final int correctlyClosedMagic;
        private final int dirtyMagic;

        public Version(int version) {
            this(247118589 + version, -1161946761);
        }

        private Version(int _correctlyClosedMagic, int _dirtyMagic) {
            this.correctlyClosedMagic = _correctlyClosedMagic;
            this.dirtyMagic = _dirtyMagic;
            assert (this.correctlyClosedMagic != this.dirtyMagic);
        }
    }
}

