/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.storage;

import com.intellij.UtilBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.EventDispatcher;
import java.util.Deque;
import java.util.EventListener;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HeavyProcessLatch {
    private static final Logger LOG = Logger.getInstance(HeavyProcessLatch.class);
    public static final HeavyProcessLatch INSTANCE = new HeavyProcessLatch();
    private final Map<String, Type> myHeavyProcesses = new ConcurrentHashMap<String, Type>();
    private final EventDispatcher<HeavyProcessListener> myEventDispatcher = EventDispatcher.create(HeavyProcessListener.class);
    private final Deque<Runnable> toExecuteOutOfHeavyActivity = new ConcurrentLinkedDeque<Runnable>();

    private HeavyProcessLatch() {
    }

    @NotNull
    public AccessToken processStarted(@NotNull String operationName) {
        if (operationName == null) {
            HeavyProcessLatch.$$$reportNull$$$0(0);
        }
        AccessToken accessToken = this.processStarted(operationName, Type.Processing);
        if (accessToken == null) {
            HeavyProcessLatch.$$$reportNull$$$0(1);
        }
        return accessToken;
    }

    public AccessToken processStarted(final @NotNull String operationName, @NotNull Type type) {
        if (operationName == null) {
            HeavyProcessLatch.$$$reportNull$$$0(2);
        }
        if (type == null) {
            HeavyProcessLatch.$$$reportNull$$$0(3);
        }
        this.myHeavyProcesses.put(operationName, type);
        this.myEventDispatcher.getMulticaster().processStarted();
        return new AccessToken(){

            @Override
            public void finish() {
                HeavyProcessLatch.this.processFinished(operationName);
            }
        };
    }

    private void processFinished(@NotNull String operationName) {
        Runnable runnable;
        if (operationName == null) {
            HeavyProcessLatch.$$$reportNull$$$0(4);
        }
        this.myHeavyProcesses.remove(operationName);
        this.myEventDispatcher.getMulticaster().processFinished();
        if (this.isRunning()) {
            return;
        }
        while ((runnable = this.toExecuteOutOfHeavyActivity.pollFirst()) != null) {
            try {
                runnable.run();
            }
            catch (Exception e) {
                LOG.error(e);
            }
        }
    }

    public boolean isRunning() {
        return !this.myHeavyProcesses.isEmpty();
    }

    @Nullable
    public String getRunningOperationName() {
        Map.Entry<String, Type> runningOperation = this.getRunningOperation();
        return runningOperation != null ? runningOperation.getKey() : null;
    }

    @Nullable
    public Map.Entry<String, Type> getRunningOperation() {
        if (this.myHeavyProcesses.isEmpty()) {
            return null;
        }
        Iterator<Map.Entry<String, Type>> iterator = this.myHeavyProcesses.entrySet().iterator();
        return iterator.hasNext() ? iterator.next() : null;
    }

    public void addListener(@NotNull HeavyProcessListener listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            HeavyProcessLatch.$$$reportNull$$$0(5);
        }
        if (parentDisposable == null) {
            HeavyProcessLatch.$$$reportNull$$$0(6);
        }
        this.myEventDispatcher.addListener(listener, parentDisposable);
    }

    public void executeOutOfHeavyProcess(@NotNull Runnable runnable) {
        if (runnable == null) {
            HeavyProcessLatch.$$$reportNull$$$0(7);
        }
        if (this.isRunning()) {
            this.toExecuteOutOfHeavyActivity.add(runnable);
        } else {
            runnable.run();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operationName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/io/storage/HeavyProcessLatch";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/io/storage/HeavyProcessLatch";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "processStarted";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processStarted";
                break;
            }
            case 1: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processFinished";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "executeOutOfHeavyProcess";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface HeavyProcessListener
    extends EventListener {
        default public void processStarted() {
        }

        public void processFinished();
    }

    public static enum Type {
        Indexing("heavyProcess.type.indexing"),
        Syncing("heavyProcess.type.syncing"),
        Processing("heavyProcess.type.processing");

        private final String bundleKey;

        private Type(String bundleKey) {
            this.bundleKey = bundleKey;
        }

        public String toString() {
            return UtilBundle.message(this.bundleKey, new Object[0]);
        }
    }
}

