/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.memoryfilesystem;

import com.github.marschall.memoryfilesystem.AbstractPath;
import com.github.marschall.memoryfilesystem.CharacterSet;
import com.github.marschall.memoryfilesystem.GlobPathMatcher;
import com.github.marschall.memoryfilesystem.RegexAbsolutePathMatcher;
import com.github.marschall.memoryfilesystem.RegexRelativePathMatcher;
import com.github.marschall.memoryfilesystem.Root;
import java.nio.file.InvalidPathException;
import java.nio.file.PathMatcher;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

abstract class PathParser {
    static final String[] EMPTY = new String[0];
    final char separator;
    private final CharacterSet forbiddenCharacters;

    PathParser(String separator, CharacterSet forbiddenCharacters) {
        this.forbiddenCharacters = forbiddenCharacters;
        if (separator.length() != 1) {
            throw new IllegalArgumentException("separator must have length 1 but was \"" + separator + "\"");
        }
        this.separator = separator.charAt(0);
    }

    void check(char c) {
        if (this.forbiddenCharacters.contains(c)) {
            throw new InvalidPathException(Character.toString(c), "contains a not allowed character");
        }
    }

    void check(List<String> elements) {
        for (String element : elements) {
            if (!this.forbiddenCharacters.containsAny(element)) continue;
            throw new InvalidPathException(element, "contains a not allowed character");
        }
    }

    boolean startWithSeparator(String s) {
        char first = s.charAt(0);
        return first == '/' || first == this.separator;
    }

    abstract AbstractPath parse(Map<String, Root> var1, String var2, String ... var3);

    abstract AbstractPath parseUri(Map<String, Root> var1, String var2);

    boolean startWithSeparator(String first, String ... more) {
        if (!first.isEmpty()) {
            return this.startWithSeparator(first);
        }
        if (more != null && more.length > 0) {
            for (String s : more) {
                if (s.isEmpty()) continue;
                return this.startWithSeparator(s);
            }
        }
        return false;
    }

    abstract PathMatcher parseGlob(String var1);

    abstract boolean isAbsolute(String var1);

    PathMatcher compileRegex(String regex, int regexFlags) {
        Pattern pattern = Pattern.compile(regex, regexFlags);
        if (this.isAbsolute(regex)) {
            return new RegexAbsolutePathMatcher(pattern);
        }
        return new RegexRelativePathMatcher(pattern);
    }

    PathMatcher transpileGlob(String glob, int regexFlags) {
        StringBuilder regex = new StringBuilder();
        regex.append('^');
        this.transpileGlobInto(new Stream(glob), regex);
        regex.append('$');
        Pattern pattern = Pattern.compile(regex.toString(), regexFlags);
        if (this.isAbsolute(glob)) {
            return new RegexAbsolutePathMatcher(pattern);
        }
        return new RegexRelativePathMatcher(pattern);
    }

    private void transpileGlobInto(Stream glob, StringBuilder regex) {
        block6: while (glob.hasNext()) {
            char next = glob.next();
            switch (next) {
                case '*': {
                    if (glob.hasNext() && glob.peek() == '*') {
                        regex.append(".*");
                        glob.next();
                        continue block6;
                    }
                    regex.append("[^");
                    PathParser.appendSafe(this.separator, regex);
                    regex.append("]*");
                    continue block6;
                }
                case '?': {
                    regex.append("[^");
                    PathParser.appendSafe(this.separator, regex);
                    regex.append("]");
                    continue block6;
                }
                case '{': {
                    regex.append('(');
                    String[] subPatterns = glob.upTo('}').split(",");
                    for (int i = 0; i < subPatterns.length; ++i) {
                        String subPattern = subPatterns[i];
                        if (i > 0) {
                            regex.append('|');
                        }
                        regex.append('(');
                        this.transpileGlobInto(new Stream(subPattern), regex);
                        regex.append(')');
                    }
                    regex.append(')');
                    continue block6;
                }
                case '\\': {
                    if (!glob.hasNext()) {
                        throw new PatternSyntaxException("\\must be followed by content", glob.getContents(), glob.getContents().length() - 1);
                    }
                    regex.append('\\').append(glob.next());
                    continue block6;
                }
            }
            PathParser.appendSafe(next, regex);
        }
    }

    static List<GlobPathMatcher.GlobPattern> convertToPatterns(List<String> elements) {
        ArrayList<GlobPathMatcher.GlobPattern> patterns = new ArrayList<GlobPathMatcher.GlobPattern>(elements.size());
        for (String element : elements) {
            patterns.add(PathParser.convertToPattern(element));
        }
        return patterns;
    }

    private static GlobPathMatcher.GlobPattern convertToPattern(String element) {
        if (element.equals("**")) {
            return DirectoryCrossingPattern.INSTANCE;
        }
        Stream stream = new Stream(element);
        StringBuilder buffer = new StringBuilder();
        PathParser.parseGeneric(stream, buffer, ExitHandler.EMPTY, element);
        Pattern pattern = Pattern.compile(buffer.toString(), 66);
        return new RegexPattern(pattern);
    }

    private static char parseGeneric(Stream stream, StringBuilder buffer, ExitHandler exitHandler, String element) {
        block7: while (stream.hasNext()) {
            char next = stream.next();
            if (exitHandler.isExit(next)) {
                return next;
            }
            switch (next) {
                case '*': {
                    buffer.append(".*");
                    continue block7;
                }
                case '?': {
                    buffer.append('.');
                    continue block7;
                }
                case '[': {
                    PathParser.parseRange(stream, buffer, element);
                    continue block7;
                }
                case '{': {
                    PathParser.parseGroup(stream, buffer, element);
                    continue block7;
                }
                case '\\': {
                    if (!stream.hasNext()) {
                        throw new PatternSyntaxException("\\must be followed by content", element, element.length() - 1);
                    }
                    buffer.append('\\').append(stream.next());
                    continue block7;
                }
            }
            PathParser.appendSafe(next, buffer);
        }
        return exitHandler.endOfStream(element);
    }

    private static void appendSafe(char c, StringBuilder buffer) {
        if (c == '^' || c == '$' || c == '.' || c == '\\') {
            buffer.append('\\');
        }
        buffer.append(c);
    }

    private static void parseGroup(Stream stream, StringBuilder buffer, String element) {
        ArrayList<String> groups = new ArrayList<String>(4);
        StringBuilder groupBuffer = new StringBuilder();
        while (PathParser.parseGeneric(stream, groupBuffer, ExitHandler.GROUP, element) != '}') {
            groups.add(groupBuffer.toString());
            groupBuffer = new StringBuilder(groupBuffer.length());
        }
        groups.add(groupBuffer.toString());
        boolean first = true;
        buffer.append('(');
        for (String group : groups) {
            if (!first) {
                buffer.append('|');
            } else {
                first = false;
            }
            buffer.append('(');
            buffer.append(group);
            buffer.append(')');
        }
        buffer.append(')');
    }

    private static void parseRange(Stream stream, StringBuilder buffer, String element) {
        StringBuilder rangeBuffer = new StringBuilder();
        PathParser.parseGeneric(stream, rangeBuffer, ExitHandler.RANGE, element);
        buffer.append('[');
        buffer.append((CharSequence)rangeBuffer);
        buffer.append(']');
    }

    static final class RegexPattern
    implements GlobPathMatcher.GlobPattern {
        private final Pattern pattern;

        RegexPattern(Pattern pattern) {
            this.pattern = pattern;
        }

        @Override
        public boolean isCrossingDirectoryBoundaries() {
            return false;
        }

        @Override
        public boolean matches(String element) {
            return this.pattern.matcher(element).matches();
        }

        public String toString() {
            return this.pattern.toString();
        }
    }

    static enum DirectoryCrossingPattern implements GlobPathMatcher.GlobPattern
    {
        INSTANCE;


        @Override
        public boolean isCrossingDirectoryBoundaries() {
            return true;
        }

        @Override
        public boolean matches(String element) {
            return true;
        }

        public String toString() {
            return "**";
        }
    }

    static final class Stream {
        private final String contents;
        private int position;

        Stream(String contents) {
            this.contents = contents;
            this.position = 0;
        }

        boolean hasNext() {
            return this.position < this.contents.length();
        }

        char next() {
            char value = this.contents.charAt(this.position);
            ++this.position;
            return value;
        }

        char peek() {
            return this.contents.charAt(this.position);
        }

        String upTo(char delimiter) {
            int start = this.position;
            int index = this.contents.indexOf(delimiter, start);
            while (index != -1 && this.contents.charAt(index - 1) == '\\') {
                start = index + 1;
                index = this.contents.indexOf(delimiter, start);
            }
            if (index == -1) {
                return null;
            }
            String substring = this.contents.substring(this.position, index);
            this.position = index + 1;
            return substring;
        }

        String getContents() {
            return this.contents;
        }
    }

    static enum ExitHandler {
        EMPTY{

            @Override
            boolean isExit(char c) {
                return false;
            }

            @Override
            char endOfStream(String element) {
                return '\u0000';
            }
        }
        ,
        GROUP{

            @Override
            boolean isExit(char c) {
                return c == ',' || c == '}';
            }

            @Override
            char endOfStream(String element) {
                throw new PatternSyntaxException("expected }", element, element.length() - 1);
            }
        }
        ,
        RANGE{

            @Override
            boolean isExit(char c) {
                return c == ']';
            }

            @Override
            char endOfStream(String element) {
                throw new PatternSyntaxException("expected ]", element, element.length() - 1);
            }
        };


        abstract boolean isExit(char var1);

        abstract char endOfStream(String var1);
    }
}

