/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.checkers;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.annotator.checkers.CustomAnnotationChecker;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationNameValuePair;

public class AnnotationCollectorChecker
extends CustomAnnotationChecker {
    @Override
    public boolean checkApplicability(@NotNull AnnotationHolder holder, @NotNull GrAnnotation annotation) {
        if (holder == null) {
            AnnotationCollectorChecker.$$$reportNull$$$0(0);
        }
        if (annotation == null) {
            AnnotationCollectorChecker.$$$reportNull$$$0(1);
        }
        return AnnotationCollectorChecker.isInAliasDeclaration(annotation);
    }

    @Override
    public boolean checkArgumentList(@NotNull AnnotationHolder holder, @NotNull GrAnnotation annotation) {
        if (holder == null) {
            AnnotationCollectorChecker.$$$reportNull$$$0(2);
        }
        if (annotation == null) {
            AnnotationCollectorChecker.$$$reportNull$$$0(3);
        }
        if (!AnnotationCollectorChecker.isInAliasDeclaration(annotation)) {
            return false;
        }
        PsiClass clazz = (PsiClass)annotation.getClassReference().resolve();
        if (clazz == null) {
            return true;
        }
        GrAnnotationNameValuePair[] attributes = annotation.getParameterList().getAttributes();
        Pair<PsiElement, String> r = CustomAnnotationChecker.checkAnnotationArguments(clazz, attributes, false);
        if (r != null && r.getFirst() != null) {
            holder.newAnnotation(HighlightSeverity.ERROR, (String)r.getSecond()).range((PsiElement)r.getFirst()).create();
        }
        return true;
    }

    private static boolean isInAliasDeclaration(GrAnnotation annotation) {
        GrAnnotation collector;
        PsiElement parent2 = annotation.getParent();
        return parent2 instanceof GrModifierList && (collector = (GrAnnotation)ContainerUtil.find((Object[])((GrModifierList)parent2).getRawAnnotations(), annotation1 -> "groovy.transform.AnnotationCollector".equals(annotation1.getQualifiedName()))) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/annotator/checkers/AnnotationCollectorChecker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkApplicability";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "checkArgumentList";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

