/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions;

import com.intellij.CommonBundle;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.util.PackageUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesProcessor;
import com.intellij.refactoring.util.RefactoringMessageUtil;
import com.intellij.util.IncorrectOperationException;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.intentions.GroovyIntentionsBundle;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;

public class GrMoveToDirFix
extends GroovyFix {
    private final String myPackageName;

    public GrMoveToDirFix(String packageName) {
        this.myPackageName = packageName;
    }

    @NotNull
    public String getName() {
        String packName = StringUtil.isEmptyOrSpaces((String)this.myPackageName) ? "default package" : this.myPackageName;
        String string = GroovyIntentionsBundle.message("move.to.correct.dir", packName);
        if (string == null) {
            GrMoveToDirFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = GroovyIntentionsBundle.message("move.to.correct.dir.family.name", new Object[0]);
        if (string == null) {
            GrMoveToDirFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    protected void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) throws IncorrectOperationException {
        PsiFile file;
        if (project == null) {
            GrMoveToDirFix.$$$reportNull$$$0(2);
        }
        if (descriptor == null) {
            GrMoveToDirFix.$$$reportNull$$$0(3);
        }
        if (!((file = descriptor.getPsiElement().getContainingFile()) instanceof GroovyFile)) {
            return;
        }
        VirtualFile vfile = file.getVirtualFile();
        if (vfile == null) {
            return;
        }
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)vfile, (Project)project);
        if (module == null) {
            return;
        }
        String packageName = ((GroovyFile)file).getPackageName();
        PsiDirectory directory = PackageUtil.findOrCreateDirectoryForPackage((Module)module, (String)packageName, null, (boolean)true);
        if (directory == null) {
            return;
        }
        String error = RefactoringMessageUtil.checkCanCreateFile((PsiDirectory)directory, (String)file.getName());
        if (error != null) {
            Messages.showMessageDialog((Project)project, (String)error, (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
            return;
        }
        new MoveFilesOrDirectoriesProcessor(project, new PsiElement[]{file}, directory, false, false, false, null, null).run();
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/annotator/intentions/GrMoveToDirFix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/annotator/intentions/GrMoveToDirFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

