/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.intentions.GroovyIntentionsBundle;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;

public class GrReplacePrimitiveTypeWithWrapperFix
extends GroovyFix {
    private static final Logger LOG = Logger.getInstance(GrReplacePrimitiveTypeWithWrapperFix.class);
    private final String myBoxedName;

    public GrReplacePrimitiveTypeWithWrapperFix(GrTypeElement typeElement) {
        LOG.assertTrue(typeElement.isValid());
        PsiType type2 = typeElement.getType();
        LOG.assertTrue(type2 instanceof PsiPrimitiveType);
        this.myBoxedName = ((PsiPrimitiveType)type2).getBoxedTypeName();
    }

    @NotNull
    public String getName() {
        String string = GroovyIntentionsBundle.message("replace.with.wrapper", this.myBoxedName);
        if (string == null) {
            GrReplacePrimitiveTypeWithWrapperFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = GroovyIntentionsBundle.message("replace.primitive.type.with.wrapper", new Object[0]);
        if (string == null) {
            GrReplacePrimitiveTypeWithWrapperFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    protected void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) throws IncorrectOperationException {
        if (project == null) {
            GrReplacePrimitiveTypeWithWrapperFix.$$$reportNull$$$0(2);
        }
        if (descriptor == null) {
            GrReplacePrimitiveTypeWithWrapperFix.$$$reportNull$$$0(3);
        }
        PsiElement element = descriptor.getPsiElement();
        assert (element instanceof GrTypeElement) : element;
        GrTypeElement typeElement = (GrTypeElement)element;
        PsiType type2 = typeElement.getType();
        if (!(type2 instanceof PsiPrimitiveType)) {
            return;
        }
        PsiClassType boxed = ((PsiPrimitiveType)type2).getBoxedType((PsiElement)typeElement);
        if (boxed == null) {
            return;
        }
        GrTypeElement newTypeElement = GroovyPsiElementFactory.getInstance(project).createTypeElement((PsiType)boxed);
        PsiElement replaced = typeElement.replace(newTypeElement);
        JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(replaced);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/annotator/intentions/GrReplacePrimitiveTypeWithWrapperFix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/annotator/intentions/GrReplacePrimitiveTypeWithWrapperFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

