/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.changeToMethod;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.codeInspection.GroovyInspectionBundle;
import org.jetbrains.plugins.groovy.codeInspection.changeToMethod.transformations.Transformation;
import org.jetbrains.plugins.groovy.codeInspection.changeToMethod.transformations.Transformations;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrSafeCastExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnaryExpression;

public class ChangeToMethodInspection
extends BaseInspection {
    @Override
    @NotNull
    protected BaseInspectionVisitor buildVisitor() {
        return new BaseInspectionVisitor(){

            @Override
            public void visitExpression(@NotNull GrExpression expression) {
                Transformation<? extends GrExpression> transformation;
                if (expression == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((transformation = ChangeToMethodInspection.this.getTransformation(expression)) == null) {
                    return;
                }
                PsiElement highlightingElement = ChangeToMethodInspection.this.getHighlightingElement(expression);
                if (highlightingElement == null) {
                    return;
                }
                if (transformation.couldApplyRow(expression)) {
                    this.registerError(highlightingElement, GroovyInspectionBundle.message("replace.with.method.message", transformation.getMethod()), new LocalQuickFix[]{ChangeToMethodInspection.this.getFix(transformation)}, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/plugins/groovy/codeInspection/changeToMethod/ChangeToMethodInspection$1", "visitExpression"));
            }
        };
    }

    @Nullable
    protected GroovyFix getFix(final @NotNull Transformation<?> transformation) {
        if (transformation == null) {
            ChangeToMethodInspection.$$$reportNull$$$0(0);
        }
        return new GroovyFix(){

            @Nls
            @NotNull
            public String getFamilyName() {
                String string = GroovyInspectionBundle.message("replace.with.method.fix", transformation.getMethod());
                if (string == null) {
                    2.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Override
            protected void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) throws IncorrectOperationException {
                PsiElement call;
                if (project == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (descriptor == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (!((call = descriptor.getPsiElement().getParent()) instanceof GrExpression)) {
                    return;
                }
                if (!transformation.couldApplyRow((GrExpression)call)) {
                    return;
                }
                transformation.applyRow((GrExpression)call);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/plugins/groovy/codeInspection/changeToMethod/ChangeToMethodInspection$2";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "descriptor";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFamilyName";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/changeToMethod/ChangeToMethodInspection$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "doFix";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    @Nullable
    public Transformation<? extends GrExpression> getTransformation(@NotNull GrExpression expression) {
        if (expression == null) {
            ChangeToMethodInspection.$$$reportNull$$$0(1);
        }
        if (expression instanceof GrUnaryExpression) {
            return Transformations.UNARY_TRANSFORMATIONS.get(((GrUnaryExpression)expression).getOperationTokenType());
        }
        if (expression instanceof GrBinaryExpression) {
            return Transformations.BINARY_TRANSFORMATIONS.get(((GrBinaryExpression)expression).getOperationTokenType());
        }
        if (expression instanceof GrSafeCastExpression) {
            return Transformations.AS_TYPE_TRANSFORMATION;
        }
        return null;
    }

    @Nullable
    public PsiElement getHighlightingElement(@NotNull GrExpression expression) {
        if (expression == null) {
            ChangeToMethodInspection.$$$reportNull$$$0(2);
        }
        if (expression instanceof GrUnaryExpression) {
            return ((GrUnaryExpression)expression).getOperationToken();
        }
        if (expression instanceof GrBinaryExpression) {
            return ((GrBinaryExpression)expression).getOperationToken();
        }
        if (expression instanceof GrSafeCastExpression) {
            return ((GrSafeCastExpression)expression).getOperationToken();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transformation";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/changeToMethod/ChangeToMethodInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getTransformation";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getHighlightingElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

