/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.control;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrConditionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;

public class GroovyConstantConditionalInspection
extends BaseInspection {
    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new ConstantConditionalExpressionVisitor();
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... args) {
        return "'#ref' can be simplified #loc";
    }

    static String calculateReplacementExpression(GrConditionalExpression exp) {
        GrExpression thenExpression = exp.getThenBranch();
        GrExpression elseExpression = exp.getElseBranch();
        GrExpression condition = exp.getCondition();
        assert (thenExpression != null);
        assert (elseExpression != null);
        if (GroovyConstantConditionalInspection.isTrue(condition)) {
            return thenExpression.getText();
        }
        return elseExpression.getText();
    }

    @Override
    public GroovyFix buildFix(@NotNull PsiElement location) {
        if (location == null) {
            GroovyConstantConditionalInspection.$$$reportNull$$$0(0);
        }
        return new ConstantConditionalFix();
    }

    private static boolean isFalse(GrExpression expression) {
        String text = expression.getText();
        return "false".equals(text);
    }

    private static boolean isTrue(GrExpression expression) {
        String text = expression.getText();
        return "true".equals(text);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "org/jetbrains/plugins/groovy/codeInspection/control/GroovyConstantConditionalInspection", "buildFix"));
    }

    private static class ConstantConditionalExpressionVisitor
    extends BaseInspectionVisitor {
        private ConstantConditionalExpressionVisitor() {
        }

        @Override
        public void visitConditionalExpression(@NotNull GrConditionalExpression expression) {
            if (expression == null) {
                ConstantConditionalExpressionVisitor.$$$reportNull$$$0(0);
            }
            super.visitConditionalExpression(expression);
            GrExpression condition = expression.getCondition();
            GrExpression thenExpression = expression.getThenBranch();
            if (thenExpression == null) {
                return;
            }
            GrExpression elseExpression = expression.getElseBranch();
            if (elseExpression == null) {
                return;
            }
            if (GroovyConstantConditionalInspection.isFalse(condition) || GroovyConstantConditionalInspection.isTrue(condition)) {
                this.registerError((PsiElement)expression, expression);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/plugins/groovy/codeInspection/control/GroovyConstantConditionalInspection$ConstantConditionalExpressionVisitor", "visitConditionalExpression"));
        }
    }

    private static class ConstantConditionalFix
    extends GroovyFix {
        private ConstantConditionalFix() {
        }

        @NotNull
        public String getFamilyName() {
            return "Simplify";
        }

        @Override
        public void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) throws IncorrectOperationException {
            if (project == null) {
                ConstantConditionalFix.$$$reportNull$$$0(0);
            }
            if (descriptor == null) {
                ConstantConditionalFix.$$$reportNull$$$0(1);
            }
            GrConditionalExpression expression = (GrConditionalExpression)descriptor.getPsiElement();
            String newExpression = GroovyConstantConditionalInspection.calculateReplacementExpression(expression);
            ConstantConditionalFix.replaceExpression(expression, newExpression);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "descriptor";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/plugins/groovy/codeInspection/control/GroovyConstantConditionalInspection$ConstantConditionalFix";
            objectArray[2] = "doFix";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

