/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.exception;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrBreakStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrContinueStatement;

public class GroovyContinueOrBreakFromFinallyBlockInspection
extends BaseInspection {
    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return "'#ref' inside 'finally' block #loc";
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitContinueStatement(@NotNull GrContinueStatement continueStatement) {
            if (continueStatement == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super.visitContinueStatement(continueStatement);
            if (!ControlFlowUtils.isInFinallyBlock(continueStatement)) {
                return;
            }
            GrStatement continuedStatement = continueStatement.findTargetStatement();
            if (continuedStatement == null) {
                return;
            }
            if (ControlFlowUtils.isInFinallyBlock(continuedStatement)) {
                return;
            }
            this.registerStatementError(continueStatement, new Object[0]);
        }

        @Override
        public void visitBreakStatement(@NotNull GrBreakStatement breakStatement) {
            if (breakStatement == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            super.visitBreakStatement(breakStatement);
            if (!ControlFlowUtils.isInFinallyBlock(breakStatement)) {
                return;
            }
            GrStatement target = breakStatement.findTargetStatement();
            if (target == null) {
                return;
            }
            if (ControlFlowUtils.isInFinallyBlock(target)) {
                return;
            }
            this.registerStatementError(breakStatement, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "continueStatement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "breakStatement";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/exception/GroovyContinueOrBreakFromFinallyBlockInspection$Visitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitContinueStatement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitBreakStatement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

