/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.validity;

import com.intellij.psi.PsiElement;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.utils.EquivalenceChecker;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSwitchStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrCaseLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;

public class GroovyDuplicateSwitchBranchInspection
extends BaseInspection {
    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return "Duplicate switch case '#ref' #loc";
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static GrCaseLabel[] collectCaseLabels(final GrSwitchStatement containingStatelent) {
        final HashSet labels = new HashSet();
        GroovyRecursiveElementVisitor visitor2 = new GroovyRecursiveElementVisitor(){

            @Override
            public void visitCaseLabel(@NotNull GrCaseLabel grCaseLabel) {
                if (grCaseLabel == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitCaseLabel(grCaseLabel);
                labels.add(grCaseLabel);
            }

            @Override
            public void visitSwitchStatement(@NotNull GrSwitchStatement grSwitchStatement) {
                if (grSwitchStatement == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (containingStatelent.equals(grSwitchStatement)) {
                    super.visitSwitchStatement(grSwitchStatement);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "grCaseLabel";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "grSwitchStatement";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/validity/GroovyDuplicateSwitchBranchInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitCaseLabel";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitSwitchStatement";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        containingStatelent.accept(visitor2);
        return labels.toArray(new GrCaseLabel[0]);
    }

    @Nullable
    private static GrExpression getExpressionForCaseLabel(GrCaseLabel label) {
        for (PsiElement child : label.getChildren()) {
            if (!(child instanceof GrExpression)) continue;
            return (GrExpression)child;
        }
        return null;
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitSwitchStatement(@NotNull GrSwitchStatement grSwitchStatement) {
            if (grSwitchStatement == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super.visitSwitchStatement(grSwitchStatement);
            HashSet<GrExpression> duplicateExpressions = new HashSet<GrExpression>();
            GrCaseLabel[] labels = GroovyDuplicateSwitchBranchInspection.collectCaseLabels(grSwitchStatement);
            for (int i = 0; i < labels.length; ++i) {
                GrCaseLabel label1 = labels[i];
                GrExpression expression1 = GroovyDuplicateSwitchBranchInspection.getExpressionForCaseLabel(label1);
                for (int j = i + 1; j < labels.length; ++j) {
                    GrCaseLabel label2 = labels[j];
                    GrExpression expression2 = GroovyDuplicateSwitchBranchInspection.getExpressionForCaseLabel(label2);
                    if (!EquivalenceChecker.expressionsAreEquivalent(expression1, expression2)) continue;
                    duplicateExpressions.add(expression1);
                    duplicateExpressions.add(expression2);
                }
            }
            for (GrExpression duplicateExpression : duplicateExpressions) {
                this.registerError(duplicateExpression);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grSwitchStatement", "org/jetbrains/plugins/groovy/codeInspection/validity/GroovyDuplicateSwitchBranchInspection$Visitor", "visitSwitchStatement"));
        }
    }
}

