/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.compiler;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.compiler.ExcludeFromStubGenerationAction;

public final class GroovyStubNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel> {
    static final String GROOVY_STUBS = "groovyStubs";
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"GroovyStubNotificationProvider");

    @Nullable
    @VisibleForTesting
    public static PsiClass findClassByStub(Project project, VirtualFile stubFile) {
        String[] components = StringUtil.trimEnd((String)stubFile.getPath(), (String)".java").split("[\\\\/]");
        int stubs = Arrays.asList(components).indexOf(GROOVY_STUBS);
        if (stubs < 0 || stubs >= components.length - 3) {
            return null;
        }
        String moduleName = components[stubs + 1];
        Module module = ModuleManager.getInstance((Project)project).findModuleByName(moduleName);
        if (module == null) {
            return null;
        }
        String fqn = StringUtil.join(Arrays.asList(components).subList(stubs + 3, components.length), (String)".");
        return JavaPsiFacade.getInstance((Project)project).findClass(fqn, GlobalSearchScope.moduleScope((Module)module));
    }

    private static EditorNotificationPanel decorateStubFile(VirtualFile file, Project project) {
        EditorNotificationPanel panel = new EditorNotificationPanel();
        panel.setText("This stub is generated for Groovy class to make Groovy-Java cross-compilation possible");
        panel.createActionLabel("Go to the Groovy class", () -> DumbService.getInstance((Project)project).withAlternativeResolveEnabled(() -> {
            PsiClass original = GroovyStubNotificationProvider.findClassByStub(project, file);
            if (original != null) {
                original.navigate(true);
            }
        }));
        panel.createActionLabel("Exclude from stub generation", () -> DumbService.getInstance((Project)project).withAlternativeResolveEnabled(() -> {
            PsiClass psiClass = GroovyStubNotificationProvider.findClassByStub(project, file);
            if (psiClass != null) {
                ExcludeFromStubGenerationAction.doExcludeFromStubGeneration(psiClass.getContainingFile());
            }
        }));
        return panel;
    }

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        Key<EditorNotificationPanel> key = KEY;
        if (key == null) {
            GroovyStubNotificationProvider.$$$reportNull$$$0(0);
        }
        return key;
    }

    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file, @NotNull FileEditor fileEditor, @NotNull Project project) {
        PsiClass psiClass;
        if (file == null) {
            GroovyStubNotificationProvider.$$$reportNull$$$0(1);
        }
        if (fileEditor == null) {
            GroovyStubNotificationProvider.$$$reportNull$$$0(2);
        }
        if (project == null) {
            GroovyStubNotificationProvider.$$$reportNull$$$0(3);
        }
        if (file.getName().endsWith(".java") && file.getPath().contains(GROOVY_STUBS) && (psiClass = GroovyStubNotificationProvider.findClassByStub(project, file)) != null) {
            return GroovyStubNotificationProvider.decorateStubFile(file, project);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/compiler/GroovyStubNotificationProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/compiler/GroovyStubNotificationProvider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createNotificationPanel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

