/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.config;

import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.roots.libraries.LibraryKind;
import com.intellij.openapi.roots.libraries.LibraryPresentationProvider;
import com.intellij.openapi.roots.libraries.NewLibraryConfiguration;
import com.intellij.openapi.roots.ui.configuration.libraries.CustomLibraryDescription;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainer;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.config.GroovyLibraryPresentationProviderBase;

public class GroovyLibraryDescription
extends CustomLibraryDescription {
    private static final String GROOVY_FRAMEWORK_NAME = "Groovy";
    private final String myEnvVariable;
    private final Set<? extends LibraryKind> myLibraryKinds;
    private final String myFrameworkName;

    public GroovyLibraryDescription() {
        this("GROOVY_HOME", GroovyLibraryDescription.getAllGroovyKinds(), GROOVY_FRAMEWORK_NAME);
    }

    public static Set<? extends LibraryKind> getAllGroovyKinds() {
        HashSet<LibraryKind> kinds = new HashSet<LibraryKind>();
        for (LibraryPresentationProvider provider2 : (LibraryPresentationProvider[])LibraryPresentationProvider.EP_NAME.getExtensions()) {
            if (!(provider2 instanceof GroovyLibraryPresentationProviderBase)) continue;
            kinds.add(provider2.getKind());
        }
        return kinds;
    }

    public GroovyLibraryDescription(@NotNull String envVariable, @NotNull LibraryKind libraryKind, String frameworkName) {
        if (envVariable == null) {
            GroovyLibraryDescription.$$$reportNull$$$0(0);
        }
        if (libraryKind == null) {
            GroovyLibraryDescription.$$$reportNull$$$0(1);
        }
        this(envVariable, Collections.singleton(libraryKind), frameworkName);
    }

    private GroovyLibraryDescription(@NotNull String envVariable, @NotNull Set<? extends LibraryKind> libraryKinds, String frameworkName) {
        if (envVariable == null) {
            GroovyLibraryDescription.$$$reportNull$$$0(2);
        }
        if (libraryKinds == null) {
            GroovyLibraryDescription.$$$reportNull$$$0(3);
        }
        this.myEnvVariable = envVariable;
        this.myLibraryKinds = libraryKinds;
        this.myFrameworkName = frameworkName;
    }

    @Nullable
    public static GroovyLibraryPresentationProviderBase findManager(@NotNull VirtualFile dir) {
        if (dir == null) {
            GroovyLibraryDescription.$$$reportNull$$$0(4);
        }
        String name = dir.getName();
        List providers = ContainerUtil.findAll((Object[])((LibraryPresentationProvider[])LibraryPresentationProvider.EP_NAME.getExtensions()), GroovyLibraryPresentationProviderBase.class);
        for (GroovyLibraryPresentationProviderBase provider2 : providers) {
            if (!provider2.managesName(name) || !provider2.isSDKHome(dir)) continue;
            return provider2;
        }
        for (GroovyLibraryPresentationProviderBase manager : providers) {
            if (!manager.isSDKHome(dir)) continue;
            return manager;
        }
        return null;
    }

    @NotNull
    public Set<? extends LibraryKind> getSuitableLibraryKinds() {
        Set<? extends LibraryKind> set = this.myLibraryKinds;
        if (set == null) {
            GroovyLibraryDescription.$$$reportNull$$$0(5);
        }
        return set;
    }

    public NewLibraryConfiguration createNewLibrary(@NotNull JComponent parentComponent, VirtualFile contextDirectory) {
        VirtualFile initial;
        if (parentComponent == null) {
            GroovyLibraryDescription.$$$reportNull$$$0(6);
        }
        if ((initial = GroovyLibraryDescription.findFile(System.getenv(this.myEnvVariable))) == null && GROOVY_FRAMEWORK_NAME.equals(this.myFrameworkName)) {
            if (SystemInfo.isLinux) {
                initial = GroovyLibraryDescription.findFile("/usr/share/groovy");
            } else if (SystemInfo.isMac) {
                initial = GroovyLibraryDescription.findFile("/usr/local/opt/groovy/libexec");
            }
        }
        FileChooserDescriptor descriptor = new FileChooserDescriptor(false, true, false, false, false, false){

            public boolean isFileSelectable(VirtualFile file) {
                if (!super.isFileSelectable(file)) {
                    return false;
                }
                return GroovyLibraryDescription.findManager(file) != null;
            }
        };
        descriptor.setTitle(this.myFrameworkName + " SDK");
        descriptor.setDescription("Choose a directory containing " + this.myFrameworkName + " distribution");
        VirtualFile dir = FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Component)parentComponent, null, (VirtualFile)initial);
        if (dir == null) {
            return null;
        }
        final GroovyLibraryPresentationProviderBase provider2 = GroovyLibraryDescription.findManager(dir);
        if (provider2 == null) {
            return null;
        }
        final String path = dir.getPath();
        String sdkVersion = provider2.getSDKVersion(path);
        if ("undefined".equals(sdkVersion)) {
            Messages.showErrorDialog((Component)parentComponent, (String)("Looks like " + this.myFrameworkName + " distribution in specified path is broken. Cannot determine version."), (String)"Failed to Create Library");
            return null;
        }
        return new NewLibraryConfiguration(provider2.getLibraryPrefix() + "-" + sdkVersion){

            public void addRoots(@NotNull LibraryEditor editor) {
                if (editor == null) {
                    2.$$$reportNull$$$0(0);
                }
                provider2.fillLibrary(path, editor);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/plugins/groovy/config/GroovyLibraryDescription$2", "addRoots"));
            }
        };
    }

    @Nullable
    private static VirtualFile findFile(String path) {
        if (path != null && !path.isEmpty()) {
            return LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)path));
        }
        return null;
    }

    @NotNull
    public LibrariesContainer.LibraryLevel getDefaultLevel() {
        LibrariesContainer.LibraryLevel libraryLevel = LibrariesContainer.LibraryLevel.GLOBAL;
        if (libraryLevel == null) {
            GroovyLibraryDescription.$$$reportNull$$$0(7);
        }
        return libraryLevel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envVariable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryKind";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryKinds";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/config/GroovyLibraryDescription";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/config/GroovyLibraryDescription";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuitableLibraryKinds";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findManager";
                break;
            }
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createNewLibrary";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

