/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.dataFlow.types;

import com.intellij.psi.PsiManager;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.VariableDescriptor;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.DFAType;

class TypeDfaState {
    private final Map<VariableDescriptor, DFAType> myVarTypes;

    TypeDfaState() {
        this.myVarTypes = new HashMap<VariableDescriptor, DFAType>();
    }

    TypeDfaState(TypeDfaState another) {
        this.myVarTypes = new HashMap<VariableDescriptor, DFAType>(another.myVarTypes);
    }

    Map<VariableDescriptor, DFAType> getVarTypes() {
        return this.myVarTypes;
    }

    TypeDfaState mergeWith(TypeDfaState another) {
        if (another.myVarTypes.isEmpty()) {
            return this;
        }
        TypeDfaState state = new TypeDfaState(this);
        state.myVarTypes.putAll(another.myVarTypes);
        return state;
    }

    void joinState(TypeDfaState another, PsiManager manager) {
        for (Map.Entry<VariableDescriptor, DFAType> entry : another.myVarTypes.entrySet()) {
            VariableDescriptor descriptor = entry.getKey();
            DFAType t1 = entry.getValue();
            if (!this.myVarTypes.containsKey(descriptor)) continue;
            DFAType t2 = this.myVarTypes.get(descriptor);
            if (t1 != null && t2 != null) {
                this.myVarTypes.put(descriptor, DFAType.create(t1, t2, manager));
                continue;
            }
            this.myVarTypes.put(descriptor, null);
        }
    }

    boolean contentsEqual(TypeDfaState another) {
        return this.myVarTypes.equals(another.myVarTypes);
    }

    @Nullable
    DFAType getVariableType(VariableDescriptor descriptor) {
        return this.myVarTypes.get(descriptor);
    }

    @Contract(value="_ -> new")
    @NotNull
    DFAType getOrCreateVariableType(VariableDescriptor descriptor) {
        DFAType result2 = this.getVariableType(descriptor);
        DFAType dFAType = result2 == null ? DFAType.create(null) : result2.copy();
        if (dFAType == null) {
            TypeDfaState.$$$reportNull$$$0(0);
        }
        return dFAType;
    }

    Map<VariableDescriptor, DFAType> getBindings() {
        return new HashMap<VariableDescriptor, DFAType>(this.myVarTypes);
    }

    void putType(VariableDescriptor descriptor, @Nullable DFAType type2) {
        this.myVarTypes.put(descriptor, type2);
    }

    public String toString() {
        return this.myVarTypes.toString();
    }

    public boolean containsVariable(@NotNull VariableDescriptor descriptor) {
        if (descriptor == null) {
            TypeDfaState.$$$reportNull$$$0(1);
        }
        return this.myVarTypes.containsKey(descriptor);
    }

    public void removeBinding(VariableDescriptor descriptor) {
        this.myVarTypes.remove(descriptor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/dataFlow/types/TypeDfaState";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateVariableType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/dataFlow/types/TypeDfaState";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "containsVariable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

