/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.VolatileNotNullLazyValue;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.dgm.GdkMethodHolder;
import org.jetbrains.plugins.groovy.dsl.GdslMembersHolderConsumer;
import org.jetbrains.plugins.groovy.dsl.GroovyClassDescriptor;
import org.jetbrains.plugins.groovy.dsl.dsltop.GdslMembersProvider;
import org.jetbrains.plugins.groovy.dsl.holders.CustomMembersHolder;
import org.jetbrains.plugins.groovy.lang.completion.closureParameters.ClosureDescriptor;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

public class GdkMethodDslProvider
implements GdslMembersProvider {
    public void category(String className, GdslMembersHolderConsumer consumer) {
        GdkMethodDslProvider.processCategoryMethods(className, consumer, false);
    }

    public void category(String className, boolean isStatic, GdslMembersHolderConsumer consumer) {
        GdkMethodDslProvider.processCategoryMethods(className, consumer, isStatic);
    }

    private static void processCategoryMethods(String className, GdslMembersHolderConsumer consumer, final boolean isStatic) {
        GlobalSearchScope scope = consumer.getResolveScope();
        final PsiClass categoryClass = JavaPsiFacade.getInstance((Project)consumer.getProject()).findClass(className, scope);
        if (categoryClass == null) {
            return;
        }
        VolatileNotNullLazyValue<GdkMethodHolder> methodsMap = new VolatileNotNullLazyValue<GdkMethodHolder>(){

            @NotNull
            protected GdkMethodHolder compute() {
                GdkMethodHolder gdkMethodHolder = GdkMethodHolder.getHolderForClass(categoryClass, isStatic);
                if (gdkMethodHolder == null) {
                    1.$$$reportNull$$$0(0);
                }
                return gdkMethodHolder;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/GdkMethodDslProvider$1", "compute"));
            }
        };
        consumer.addMemberHolder(new CustomMembersHolder((VolatileNotNullLazyValue)methodsMap){
            final /* synthetic */ VolatileNotNullLazyValue val$methodsMap;
            {
                this.val$methodsMap = volatileNotNullLazyValue;
            }

            @Override
            public boolean processMembers(GroovyClassDescriptor descriptor, PsiScopeProcessor processor, ResolveState state) {
                return !ResolveUtil.shouldProcessMethods((ElementClassHint)processor.getHint(ElementClassHint.KEY)) || ((GdkMethodHolder)this.val$methodsMap.getValue()).processMethods(processor, state, descriptor.getPsiType(), descriptor.getProject());
            }

            @Override
            public void consumeClosureDescriptors(GroovyClassDescriptor descriptor, Consumer<? super ClosureDescriptor> consumer) {
            }
        });
    }
}

