/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.file.PsiPackageImpl;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiTreeUtilKt;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtilKt;
import org.jetbrains.plugins.groovy.lang.resolve.ElementResolveResult;
import org.jetbrains.plugins.groovy.lang.resolve.GrCodeReferenceResolverKt;
import org.jetbrains.plugins.groovy.lang.resolve.OwnerKt;
import org.jetbrains.plugins.groovy.lang.resolve.processors.CodeFieldProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.processors.LocalVariableProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ReferenceExpressionClassProcessor;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000J\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u000e\u0010\u0006\u001a\u0004\u0018\u00010\u0005*\u00020\u0007H\u0002\u001a\u000e\u0010\b\u001a\u0004\u0018\u00010\t*\u00020\u0007H\u0000\u001a\u001e\u0010\n\u001a\u0004\u0018\u00010\u000b*\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\u0014\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0011*\u00020\u0007H\u0002\u001a\u001e\u0010\u0012\u001a\u0004\u0018\u00010\t*\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0007H\u0002\u001a\u001c\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0011*\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u001a\u001a\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u0011*\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0014\u001a\u0016\u0010\u0019\u001a\u0004\u0018\u00010\t*\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a8\u0006\u001a"}, d2={"checkCurrentClass", "", "field", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/GrField;", "place", "Lcom/intellij/psi/PsiElement;", "doResolvePackageOrClass", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrReferenceExpression;", "doResolveStatic", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GroovyResolveResult;", "resolveClassFqn", "Lcom/intellij/psi/PsiClass;", "facade", "Lcom/intellij/psi/JavaPsiFacade;", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "resolvePackageOrClass", "Lorg/jetbrains/plugins/groovy/lang/resolve/ElementResolveResult;", "resolveQualifiedType", "name", "", "qualifier", "resolveToField", "resolveToLocalVariable", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/GrVariable;", "resolveUnqualifiedType", "intellij.groovy.psi"})
public final class GrReferenceResolveRunnerKt {
    private static final ElementResolveResult<PsiElement> resolvePackageOrClass(@NotNull GrReferenceExpression $this$resolvePackageOrClass) {
        ElementResolveResult<PsiElement> elementResolveResult;
        PsiElement psiElement = GrReferenceResolveRunnerKt.doResolvePackageOrClass($this$resolvePackageOrClass);
        if (psiElement != null) {
            PsiElement psiElement2 = psiElement;
            boolean bl = false;
            boolean bl2 = false;
            PsiElement p1 = psiElement2;
            boolean bl3 = false;
            elementResolveResult = new ElementResolveResult<PsiElement>(p1);
        } else {
            elementResolveResult = null;
        }
        return elementResolveResult;
    }

    private static final PsiElement doResolvePackageOrClass(@NotNull GrReferenceExpression $this$doResolvePackageOrClass) {
        String string = $this$doResolvePackageOrClass.getQualifiedReferenceName();
        if (string == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"qualifiedReferenceName ?: return null");
        String qname = string;
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)$this$doResolvePackageOrClass.getProject());
        GlobalSearchScope globalSearchScope = $this$doResolvePackageOrClass.getResolveScope();
        Intrinsics.checkExpressionValueIsNotNull((Object)globalSearchScope, (String)"resolveScope");
        GlobalSearchScope scope = globalSearchScope;
        if ($this$doResolvePackageOrClass.isQualified()) {
            PsiClass clazz;
            JavaPsiFacade javaPsiFacade = facade;
            Intrinsics.checkExpressionValueIsNotNull((Object)javaPsiFacade, (String)"facade");
            PsiClass psiClass = clazz = GrReferenceResolveRunnerKt.resolveClassFqn($this$doResolvePackageOrClass, javaPsiFacade, scope);
            if (psiClass != null) {
                PsiClass psiClass2 = psiClass;
                boolean bl = false;
                boolean bl2 = false;
                PsiClass it = psiClass2;
                boolean bl3 = false;
                return (PsiElement)it;
            }
        }
        for (PsiElement parent2 : com.intellij.psi.util.PsiTreeUtilKt.getParents((PsiElement)$this$doResolvePackageOrClass)) {
            if (!(parent2 instanceof GrReferenceExpression)) {
                return null;
            }
            GrReferenceExpression grReferenceExpression = (GrReferenceExpression)parent2;
            JavaPsiFacade javaPsiFacade = facade;
            Intrinsics.checkExpressionValueIsNotNull((Object)javaPsiFacade, (String)"facade");
            PsiClass clazz = GrReferenceResolveRunnerKt.resolveClassFqn(grReferenceExpression, javaPsiFacade, scope);
            if (clazz == null) continue;
            PsiPackage psiPackage = facade.findPackage(qname);
            return psiPackage != null ? (PsiElement)psiPackage : (PsiElement)new PsiPackageImpl($this$doResolvePackageOrClass, qname, $this$doResolvePackageOrClass.getManager(), qname){
                final /* synthetic */ GrReferenceExpression $this_doResolvePackageOrClass;
                final /* synthetic */ String $qname;

                public boolean isValid() {
                    PsiManager psiManager = this.getManager();
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiManager, (String)"manager");
                    return !psiManager.isDisposed();
                }
                {
                    this.$this_doResolvePackageOrClass = $receiver;
                    this.$qname = $captured_local_variable$1;
                    super($super_call_param$2, $super_call_param$3);
                }
            };
        }
        return null;
    }

    private static final PsiClass resolveClassFqn(@NotNull GrReferenceExpression $this$resolveClassFqn, JavaPsiFacade facade, GlobalSearchScope scope) {
        block7: {
            block6: {
                if ($this$resolveClassFqn.getParent() instanceof GrMethodCall) {
                    return null;
                }
                String string = $this$resolveClassFqn.getReferenceName();
                if (string == null) {
                    return null;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"referenceName ?: return null");
                String name = string;
                CharSequence charSequence = name;
                boolean bl = false;
                if (charSequence.length() == 0) break block6;
                char c = StringsKt.first((CharSequence)name);
                bl = false;
                if (Character.isUpperCase(c)) break block7;
            }
            return null;
        }
        String string = $this$resolveClassFqn.getQualifiedReferenceName();
        if (string == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"qualifiedReferenceName ?: return null");
        String qname = string;
        return facade.findClass(qname, scope);
    }

    @Nullable
    public static final GroovyResolveResult doResolveStatic(@NotNull GrReferenceExpression $this$doResolveStatic) {
        ElementResolveResult<GrVariable> localVariable;
        Intrinsics.checkParameterIsNotNull((Object)$this$doResolveStatic, (String)"$this$doResolveStatic");
        String string = $this$doResolveStatic.getReferenceName();
        if (string == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"referenceName ?: return null");
        String name = string;
        ElementResolveResult<PsiElement> fqnResult = GrReferenceResolveRunnerKt.resolvePackageOrClass($this$doResolveStatic);
        if (fqnResult != null) {
            return fqnResult;
        }
        GrExpression qualifier = (GrExpression)$this$doResolveStatic.getQualifier();
        if (qualifier == null && (localVariable = GrReferenceResolveRunnerKt.resolveToLocalVariable($this$doResolveStatic, name)) != null) {
            return localVariable;
        }
        if (!($this$doResolveStatic.getParent() instanceof GrMethodCall)) {
            ElementResolveResult<GrField> field;
            if ((qualifier == null || PsiUtilKt.isThisExpression(qualifier)) && (field = GrReferenceResolveRunnerKt.resolveToField($this$doResolveStatic, name)) != null && GrReferenceResolveRunnerKt.checkCurrentClass(field.getElement(), $this$doResolveStatic)) {
                return field;
            }
            if (qualifier == null) {
                return GrReferenceResolveRunnerKt.resolveUnqualifiedType($this$doResolveStatic, name);
            }
            if (qualifier instanceof GrReferenceExpression) {
                return GrReferenceResolveRunnerKt.resolveQualifiedType($this$doResolveStatic, name, (GrReferenceExpression)qualifier);
            }
        }
        return null;
    }

    @Nullable
    public static final ElementResolveResult<GrVariable> resolveToLocalVariable(@NotNull PsiElement $this$resolveToLocalVariable, @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)$this$resolveToLocalVariable, (String)"$this$resolveToLocalVariable");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return (ElementResolveResult)PsiTreeUtilKt.treeWalkUpAndGet($this$resolveToLocalVariable, new LocalVariableProcessor(name));
    }

    private static final ElementResolveResult<GrField> resolveToField(@NotNull PsiElement $this$resolveToField, String name) {
        return (ElementResolveResult)PsiTreeUtilKt.treeWalkUpAndGet($this$resolveToField, new CodeFieldProcessor(name, $this$resolveToField));
    }

    private static final boolean checkCurrentClass(GrField field, PsiElement place) {
        PsiClass psiClass = field.getContainingClass();
        if (psiClass == null) {
            return false;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiClass, (String)"field.containingClass ?: return false");
        PsiClass containingClass = psiClass;
        return Intrinsics.areEqual((Object)containingClass, (Object)OwnerKt.getOwner(place));
    }

    private static final GroovyResolveResult resolveUnqualifiedType(@NotNull PsiElement $this$resolveUnqualifiedType, String name) {
        ReferenceExpressionClassProcessor processor = new ReferenceExpressionClassProcessor(name, $this$resolveUnqualifiedType);
        PsiScopeProcessor psiScopeProcessor = processor;
        ResolveState resolveState = ResolveState.initial();
        Intrinsics.checkExpressionValueIsNotNull((Object)resolveState, (String)"ResolveState.initial()");
        GrCodeReferenceResolverKt.processUnqualified($this$resolveUnqualifiedType, psiScopeProcessor, resolveState);
        return processor.getResult();
    }

    private static final GroovyResolveResult resolveQualifiedType(@NotNull PsiElement $this$resolveQualifiedType, String name, GrReferenceExpression qualifier) {
        PsiElement psiElement = qualifier.getStaticReference().resolve();
        if (!(psiElement instanceof PsiClass)) {
            psiElement = null;
        }
        PsiClass psiClass = (PsiClass)psiElement;
        if (psiClass == null) {
            return null;
        }
        PsiClass classQualifier = psiClass;
        ReferenceExpressionClassProcessor processor = new ReferenceExpressionClassProcessor(name, $this$resolveQualifiedType);
        classQualifier.processDeclarations((PsiScopeProcessor)processor, ResolveState.initial(), null, $this$resolveQualifiedType);
        return processor.getResult();
    }
}

