/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.typing;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrSafeCastExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrTraitType;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GrTraitUtil;
import org.jetbrains.plugins.groovy.lang.typing.GrTypeCalculator;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0002J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0002\u00a8\u0006\t"}, d2={"Lorg/jetbrains/plugins/groovy/lang/typing/DefaultSafeCastTypeCalculator;", "Lorg/jetbrains/plugins/groovy/lang/typing/GrTypeCalculator;", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrSafeCastExpression;", "()V", "getTraitType", "Lcom/intellij/psi/PsiType;", "expression", "getType", "getTypeFromRawCollectionCast", "intellij.groovy.psi"})
public final class DefaultSafeCastTypeCalculator
implements GrTypeCalculator<GrSafeCastExpression> {
    @Override
    @Nullable
    public PsiType getType(@NotNull GrSafeCastExpression expression) {
        PsiType psiType;
        Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
        GrTypeElement grTypeElement = expression.getCastTypeElement();
        if (grTypeElement == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)grTypeElement, (String)"expression.castTypeElement ?: return null");
        GrTypeElement typeElement = grTypeElement;
        PsiType psiType2 = this.getTypeFromRawCollectionCast(expression);
        if (psiType2 == null) {
            psiType2 = psiType = this.getTraitType(expression);
        }
        if (psiType2 == null) {
            psiType = typeElement.getType();
        }
        return psiType;
    }

    private final PsiType getTypeFromRawCollectionCast(GrSafeCastExpression expression) {
        GrTypeElement grTypeElement = expression.getCastTypeElement();
        Object object = grTypeElement != null ? grTypeElement.getType() : null;
        if (!(object instanceof PsiClassType)) {
            object = null;
        }
        PsiClassType psiClassType = (PsiClassType)object;
        if (psiClassType == null) {
            return null;
        }
        PsiClassType castType = psiClassType;
        if (!InheritanceUtil.isInheritor((PsiType)((PsiType)castType), (String)"java.util.Collection")) {
            return null;
        }
        if (PsiUtil.extractIterableTypeParameter((PsiType)((PsiType)castType), (boolean)false) != null) {
            return null;
        }
        PsiClass psiClass = castType.resolve();
        if (psiClass == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiClass, (String)"castType.resolve() ?: return null");
        PsiClass resolved = psiClass;
        Object[] objectArray = resolved.getTypeParameters();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"resolved.typeParameters");
        PsiTypeParameter psiTypeParameter = (PsiTypeParameter)ArraysKt.singleOrNull((Object[])objectArray);
        if (psiTypeParameter == null) {
            return null;
        }
        PsiTypeParameter typeParameter = psiTypeParameter;
        GrExpression grExpression = expression.getOperand();
        Intrinsics.checkExpressionValueIsNotNull((Object)grExpression, (String)"expression.operand");
        PsiType psiType = TypesUtil.getItemType(grExpression.getType());
        if (psiType == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiType, (String)"getItemType(expression.o\u2026rand.type) ?: return null");
        PsiType itemType = psiType;
        Map substitutionMap = MapsKt.mapOf((Pair)TuplesKt.to((Object)typeParameter, (Object)itemType));
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)expression.getProject());
        PsiSubstitutor psiSubstitutor = factory.createSubstitutor(substitutionMap);
        Intrinsics.checkExpressionValueIsNotNull((Object)psiSubstitutor, (String)"factory.createSubstitutor(substitutionMap)");
        PsiSubstitutor substitutor = psiSubstitutor;
        return (PsiType)factory.createType(resolved, substitutor);
    }

    private final PsiType getTraitType(GrSafeCastExpression expression) {
        GrTypeElement grTypeElement = expression.getCastTypeElement();
        Object object = grTypeElement != null ? grTypeElement.getType() : null;
        if (!(object instanceof PsiClassType)) {
            object = null;
        }
        PsiClassType psiClassType = (PsiClassType)object;
        if (psiClassType == null) {
            return null;
        }
        PsiClassType castType = psiClassType;
        GrExpression grExpression = expression.getOperand();
        Intrinsics.checkExpressionValueIsNotNull((Object)grExpression, (String)"expression.operand");
        PsiType exprType = grExpression.getType();
        if (!(exprType instanceof PsiClassType) && !(exprType instanceof GrTraitType)) {
            return null;
        }
        PsiClass psiClass = castType.resolve();
        if (psiClass == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiClass, (String)"castType.resolve() ?: return null");
        PsiClass resolved = psiClass;
        if (!GrTraitUtil.isTrait(resolved)) {
            return null;
        }
        return GrTraitType.createTraitType(exprType, CollectionsKt.listOf((Object)castType));
    }
}

