/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.mvc;

import com.intellij.facet.FacetManager;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.impl.ModifiableModelCommitter;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.roots.ui.configuration.actions.ModuleDeleteProvider;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashSet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;
import org.jetbrains.plugins.groovy.mvc.MvcFramework;
import org.jetbrains.plugins.groovy.mvc.MvcProjectStructure;

public final class MvcModuleStructureUtil {
    private static final Logger LOG = Logger.getInstance(MvcModuleStructureUtil.class);
    @NonNls
    public static final String PLUGINS_DIRECTORY = "plugins";
    @NonNls
    public static final String APPLICATION_PROPERTIES = "application.properties";
    public static final Key<String> LAST_MVC_VERSION = Key.create((String)"LAST_MVC_VERSION");

    private MvcModuleStructureUtil() {
    }

    @Nullable
    public static ContentEntry findContentEntry(ModuleRootModel rootModel, VirtualFile root) {
        for (ContentEntry entry : rootModel.getContentEntries()) {
            if (!Comparing.equal((Object)entry.getFile(), (Object)root)) continue;
            return entry;
        }
        return null;
    }

    @Nullable
    private static Consumer<ModifiableRootModel> addSourceRootsAndLibDirectory(@NotNull VirtualFile root, MvcProjectStructure structure) {
        if (root == null) {
            MvcModuleStructureUtil.$$$reportNull$$$0(0);
        }
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)structure.myModule);
        HashMap sourceRoots = new HashMap();
        for (ContentEntry entry : moduleRootManager.getContentEntries()) {
            for (SourceFolder folder : entry.getSourceFolders()) {
                sourceRoots.put(folder.getFile(), folder.getRootType());
            }
        }
        root.refresh(false, true);
        ArrayList<Consumer<ContentEntry>> actions = new ArrayList<Consumer<ContentEntry>>();
        for (Map.Entry entry : structure.getSourceFolders().entrySet()) {
            JpsModuleSourceRootType rootType = (JpsModuleSourceRootType)entry.getKey();
            for (String src : (Collection)entry.getValue()) {
                MvcModuleStructureUtil.addSourceFolder(root, src, rootType, actions, sourceRoots);
            }
        }
        for (String src : structure.getInvalidSourceFolders()) {
            MvcModuleStructureUtil.removeSrcFolderFromRoots(root.findFileByRelativePath(src), actions, sourceRoots);
        }
        for (VirtualFile excluded : structure.getExcludedFolders(root)) {
            if (!moduleRootManager.getFileIndex().isInContent(excluded)) continue;
            actions.add((Consumer<ContentEntry>)((Consumer)contentEntry -> contentEntry.addExcludeFolder(excluded)));
        }
        Consumer<ModifiableRootModel> modifyLib = MvcModuleStructureUtil.addJarDirectory(root, structure.myModule, structure.getUserLibraryName());
        if (actions.isEmpty() && modifyLib == null && MvcModuleStructureUtil.findContentEntry((ModuleRootModel)moduleRootManager, root) != null) {
            return null;
        }
        return model -> {
            ContentEntry contentEntry = MvcModuleStructureUtil.findContentEntry((ModuleRootModel)model, root);
            if (contentEntry == null) {
                contentEntry = model.addContentEntry(root);
            }
            for (Consumer action : actions) {
                action.consume((Object)contentEntry);
            }
            if (modifyLib != null) {
                modifyLib.consume(model);
            }
        };
    }

    public static void removeSrcFolderFromRoots(VirtualFile file, @NotNull List<Consumer<ContentEntry>> actions, @NotNull Map<VirtualFile, JpsModuleSourceRootType<?>> sourceRoots) {
        if (actions == null) {
            MvcModuleStructureUtil.$$$reportNull$$$0(1);
        }
        if (sourceRoots == null) {
            MvcModuleStructureUtil.$$$reportNull$$$0(2);
        }
        MvcModuleStructureUtil.removeSrcFolderFromRoots(file, actions, sourceRoots.keySet());
    }

    public static void removeSrcFolderFromRoots(VirtualFile file, @NotNull List<Consumer<ContentEntry>> actions, @NotNull Collection<VirtualFile> sourceRoots) {
        if (actions == null) {
            MvcModuleStructureUtil.$$$reportNull$$$0(3);
        }
        if (sourceRoots == null) {
            MvcModuleStructureUtil.$$$reportNull$$$0(4);
        }
        if (sourceRoots.contains(file)) {
            actions.add((Consumer<ContentEntry>)((Consumer)contentEntry -> {
                SourceFolder[] folders;
                for (SourceFolder folder : folders = contentEntry.getSourceFolders()) {
                    if (!Comparing.equal((Object)folder.getFile(), (Object)file)) continue;
                    contentEntry.removeSourceFolder(folder);
                }
            }));
        }
    }

    @Nullable
    public static Consumer<ModifiableRootModel> addJarDirectory(VirtualFile root, Module module, String libName) {
        VirtualFile libDir = root.findFileByRelativePath("lib");
        if (libDir == null || !libDir.isDirectory() || ProjectRootManager.getInstance((Project)module.getProject()).getFileIndex().isExcluded(libDir)) {
            return null;
        }
        Library library = MvcModuleStructureUtil.findUserLibrary(module, libName);
        if (library != null && library.isJarDirectory(libDir.getUrl())) {
            return null;
        }
        return model -> {
            Library.ModifiableModel libModel = MvcModuleStructureUtil.modifyDefaultLibrary(model, libName);
            libModel.addJarDirectory(libDir, false);
            libModel.commit();
        };
    }

    public static Library.ModifiableModel modifyDefaultLibrary(ModifiableRootModel model, String libName) {
        LibraryTable libTable = model.getModuleLibraryTable();
        for (Library library : libTable.getLibraries()) {
            if (library.getName() == null || !library.getName().startsWith(libName)) continue;
            return library.getModifiableModel();
        }
        Library library = LibraryUtil.createLibrary((LibraryTable)libTable, (String)(libName + " (" + model.getModule().getName() + ')'));
        for (OrderEntry entry : model.getOrderEntries()) {
            LibraryOrderEntry libraryEntry;
            if (!(entry instanceof LibraryOrderEntry) || !(libraryEntry = (LibraryOrderEntry)entry).isModuleLevel() || libraryEntry.getLibrary() != library) continue;
            libraryEntry.setExported(true);
        }
        return library.getModifiableModel();
    }

    private static void addSourceFolder(@NotNull VirtualFile root, @NotNull String relativePath, JpsModuleSourceRootType<?> rootType, List<Consumer<ContentEntry>> actions, Map<VirtualFile, JpsModuleSourceRootType<?>> sourceRoots) {
        VirtualFile src;
        if (root == null) {
            MvcModuleStructureUtil.$$$reportNull$$$0(5);
        }
        if (relativePath == null) {
            MvcModuleStructureUtil.$$$reportNull$$$0(6);
        }
        if ((src = root.findFileByRelativePath(relativePath)) == null) {
            return;
        }
        JpsModuleSourceRootType<?> existingRootType = sourceRoots.get(src);
        if (rootType == JavaSourceRootType.TEST_SOURCE && existingRootType != null && existingRootType != JavaSourceRootType.TEST_SOURCE) {
            actions.add((Consumer<ContentEntry>)((Consumer)entry -> {
                for (SourceFolder folder : entry.getSourceFolders()) {
                    if (!Comparing.equal((Object)folder.getFile(), (Object)src)) continue;
                    entry.removeSourceFolder(folder);
                    entry.addSourceFolder(src, rootType);
                    break;
                }
            }));
            return;
        }
        actions.add((Consumer<ContentEntry>)((Consumer)contentEntry -> contentEntry.addSourceFolder(src, rootType)));
    }

    public static void updateModuleStructure(Module module, MvcProjectStructure structure, @NotNull VirtualFile root) {
        if (root == null) {
            MvcModuleStructureUtil.$$$reportNull$$$0(7);
        }
        Pair<Collection<Consumer<ModifiableRootModel>>, Collection<Consumer<ModifiableFacetModel>>> actions = MvcModuleStructureUtil.getUpdateProjectStructureActions(Collections.singletonList(root), structure);
        if (!((Collection)actions.first).isEmpty()) {
            ModuleRootModificationUtil.updateModel((Module)module, model -> {
                for (Consumer action : (Collection)actions.first) {
                    action.consume(model);
                }
            });
        }
        if (!((Collection)actions.second).isEmpty()) {
            Application application = ApplicationManager.getApplication();
            ModifiableFacetModel model2 = (ModifiableFacetModel)ReadAction.compute(() -> FacetManager.getInstance((Module)module).createModifiableModel());
            for (Consumer action : (Collection)actions.second) {
                action.consume((Object)model2);
            }
            application.invokeAndWait(() -> application.runWriteAction(() -> model2.commit()));
        }
    }

    private static boolean checkValidity(VirtualFile pluginDir) {
        pluginDir.refresh(false, false);
        return pluginDir.isValid();
    }

    private static Pair<Collection<Consumer<ModifiableRootModel>>, Collection<Consumer<ModifiableFacetModel>>> getUpdateProjectStructureActions(Collection<VirtualFile> appRoots, MvcProjectStructure structure) {
        for (VirtualFile appRoot : ModuleRootManager.getInstance((Module)structure.myModule).getContentRoots()) {
            appRoot.refresh(false, false);
        }
        ArrayList<Consumer<ModifiableRootModel>> actions = new ArrayList<Consumer<ModifiableRootModel>>();
        MvcModuleStructureUtil.removeInvalidSourceRoots(actions, structure);
        MvcModuleStructureUtil.cleanupDefaultLibrary(structure.myModule, actions, appRoots, structure.getUserLibraryName());
        MvcModuleStructureUtil.moveupLibrariesFromMavenPlugin(structure.myModule, actions);
        ArrayList<VirtualFile> rootsToFacetSetup = new ArrayList<VirtualFile>(appRoots.size());
        for (VirtualFile appRoot : appRoots) {
            if (!MvcModuleStructureUtil.checkValidity(appRoot)) continue;
            ContainerUtil.addIfNotNull(actions, MvcModuleStructureUtil.addSourceRootsAndLibDirectory(appRoot, structure));
            rootsToFacetSetup.add(appRoot);
        }
        ArrayList<Consumer<ModifiableFacetModel>> facetActions = new ArrayList<Consumer<ModifiableFacetModel>>();
        structure.setupFacets(facetActions, rootsToFacetSetup);
        return Pair.create(actions, facetActions);
    }

    private static OrderEntry @Nullable [] moveupLibrariesFromMavenPlugin(ModuleRootModel moduleRootModel) {
        LibraryOrderEntry newestLibrary = null;
        int firstLibraryIndex = 0;
        int newestLibraryIndex = 0;
        OrderEntry[] orderEntries = moduleRootModel.getOrderEntries();
        for (int i = 0; i < orderEntries.length; ++i) {
            LibraryOrderEntry libraryEntry;
            String libraryName;
            if (!(orderEntries[i] instanceof LibraryOrderEntry) || (libraryName = (libraryEntry = (LibraryOrderEntry)orderEntries[i]).getLibraryName()) == null || !libraryName.contains("slf4j-api")) continue;
            if (newestLibrary == null) {
                newestLibrary = libraryEntry;
                firstLibraryIndex = i;
                newestLibraryIndex = i;
                continue;
            }
            if (libraryName.compareTo(newestLibrary.getLibraryName()) <= 0) continue;
            newestLibraryIndex = i;
            newestLibrary = libraryEntry;
        }
        if (firstLibraryIndex == newestLibraryIndex) {
            return null;
        }
        Object[] res = (OrderEntry[])orderEntries.clone();
        ArrayUtil.swap((Object[])res, (int)firstLibraryIndex, (int)newestLibraryIndex);
        return res;
    }

    private static void moveupLibrariesFromMavenPlugin(Module module, Collection<Consumer<ModifiableRootModel>> actions) {
        if (MvcModuleStructureUtil.moveupLibrariesFromMavenPlugin((ModuleRootModel)ModuleRootManager.getInstance((Module)module)) != null) {
            actions.add((Consumer<ModifiableRootModel>)((Consumer)modifiableRootModel -> {
                OrderEntry[] orderEntries = MvcModuleStructureUtil.moveupLibrariesFromMavenPlugin((ModuleRootModel)modifiableRootModel);
                if (orderEntries != null) {
                    modifiableRootModel.rearrangeOrderEntries(orderEntries);
                }
            }));
        }
    }

    private static void removeInvalidSourceRoots(Collection<Consumer<ModifiableRootModel>> actions, MvcProjectStructure structure) {
        THashSet toRemove = new THashSet();
        THashSet toRemoveContent = new THashSet();
        for (ContentEntry entry : ModuleRootManager.getInstance((Module)structure.myModule).getContentEntries()) {
            VirtualFile file = entry.getFile();
            if (file == null || !structure.isValidContentRoot(file)) {
                toRemoveContent.add(entry.getUrl());
                continue;
            }
            for (SourceFolder folder : entry.getSourceFolders()) {
                if (folder.getFile() != null) continue;
                toRemove.add(folder);
            }
        }
        if (!toRemove.isEmpty() || !toRemoveContent.isEmpty()) {
            actions.add((Consumer<ModifiableRootModel>)((Consumer)arg_0 -> MvcModuleStructureUtil.lambda$removeInvalidSourceRoots$11((Set)toRemoveContent, (Set)toRemove, arg_0)));
        }
    }

    public static void cleanupDefaultLibrary(Module module, Collection<Consumer<ModifiableRootModel>> actions, Collection<VirtualFile> appRoots, String libName) {
        Library library = MvcModuleStructureUtil.findUserLibrary(module, libName);
        if (library == null) {
            return;
        }
        VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
        ArrayList<String> toRemoveUrls = new ArrayList<String>();
        for (String url : library.getUrls(OrderRootType.CLASSES)) {
            VirtualFile virtualFile = virtualFileManager.findFileByUrl(url);
            if (virtualFile == null) {
                toRemoveUrls.add(url);
                continue;
            }
            if (!library.isJarDirectory(url) || virtualFile.getName().equals("lib") && appRoots.contains(virtualFile.getParent())) continue;
            toRemoveUrls.add(url);
        }
        if (!toRemoveUrls.isEmpty()) {
            actions.add((Consumer<ModifiableRootModel>)((Consumer)model -> {
                Library.ModifiableModel modifiableModel = MvcModuleStructureUtil.modifyDefaultLibrary(model, libName);
                for (String url : toRemoveUrls) {
                    modifiableModel.removeRoot(url, OrderRootType.CLASSES);
                }
                modifiableModel.commit();
            }));
        }
    }

    public static boolean hasModulesWithSupport(Project project, MvcFramework framework) {
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            if (!framework.hasSupport(module)) continue;
            return true;
        }
        return false;
    }

    public static List<Module> getAllModulesWithSupport(Project project, MvcFramework framework) {
        ArrayList<Module> modules = new ArrayList<Module>();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            if (!framework.hasSupport(module)) continue;
            modules.add(module);
        }
        return modules;
    }

    @Nullable
    private static Library extractNonModuleLibraries(List<? super Library> result2, ModuleRootManager rootManager, boolean providedOnly, String userLibraryName) {
        Library userLibrary = null;
        for (OrderEntry entry : rootManager.getOrderEntries()) {
            LibraryOrderEntry libraryEntry;
            Library library;
            if (!(entry instanceof LibraryOrderEntry) || (library = (libraryEntry = (LibraryOrderEntry)entry).getLibrary()) == null) continue;
            String libraryName = libraryEntry.getLibraryName();
            if (libraryName != null && libraryName.startsWith(userLibraryName)) {
                userLibrary = library;
                continue;
            }
            if (library.getTable() == null || providedOnly && libraryEntry.getScope().isForProductionRuntime()) continue;
            result2.add((Library)library);
        }
        return userLibrary;
    }

    private static Set<String> getJarUrls(@Nullable Library library) {
        if (library == null) {
            return Collections.emptySet();
        }
        HashSet<String> res = new HashSet<String>();
        for (String url : library.getUrls(OrderRootType.CLASSES)) {
            if (library.isJarDirectory(url)) continue;
            res.add(url);
        }
        return res;
    }

    public static void syncAuxModuleSdk(@NotNull Module appModule, @NotNull Module pluginsModule, @NotNull MvcFramework framework) {
        boolean isLibrariesEquals;
        if (appModule == null) {
            MvcModuleStructureUtil.$$$reportNull$$$0(8);
        }
        if (pluginsModule == null) {
            MvcModuleStructureUtil.$$$reportNull$$$0(9);
        }
        if (framework == null) {
            MvcModuleStructureUtil.$$$reportNull$$$0(10);
        }
        ModuleRootManager auxRootManager = ModuleRootManager.getInstance((Module)pluginsModule);
        ModuleRootManager appRootManager = ModuleRootManager.getInstance((Module)appModule);
        boolean isSdkEquals = Comparing.equal((Object)auxRootManager.getSdk(), (Object)appRootManager.getSdk());
        ArrayList appLibraries = new ArrayList();
        Library appUserLibrary = MvcModuleStructureUtil.extractNonModuleLibraries(appLibraries, appRootManager, false, framework.getUserLibraryName());
        ArrayList auxLibraries = new ArrayList();
        Library auxUserLibrary = MvcModuleStructureUtil.extractNonModuleLibraries(auxLibraries, auxRootManager, false, framework.getUserLibraryName());
        boolean bl = isLibrariesEquals = appLibraries.equals(auxLibraries) && MvcModuleStructureUtil.getJarUrls(auxUserLibrary).equals(MvcModuleStructureUtil.getJarUrls(appUserLibrary));
        if (!isSdkEquals || !isLibrariesEquals) {
            ModuleRootModificationUtil.updateModel((Module)pluginsModule, model -> {
                if (!isSdkEquals) {
                    MvcModuleStructureUtil.copySdk((ModuleRootModel)appRootManager, model);
                }
                if (!isLibrariesEquals) {
                    MvcModuleStructureUtil.copyUserLibraries((ModuleRootModel)appRootManager, model, framework);
                }
            });
        }
    }

    @Nullable
    public static PropertiesFile findApplicationProperties(@NotNull Module module, MvcFramework framework) {
        VirtualFile root;
        if (module == null) {
            MvcModuleStructureUtil.$$$reportNull$$$0(11);
        }
        if ((root = framework.findAppRoot(module)) == null) {
            return null;
        }
        VirtualFile appChild = root.findChild(APPLICATION_PROPERTIES);
        if (appChild == null || !appChild.isValid()) {
            return null;
        }
        PsiManager manager = PsiManager.getInstance((Project)module.getProject());
        PsiFile psiFile = manager.findFile(appChild);
        if (psiFile instanceof PropertiesFile) {
            return (PropertiesFile)psiFile;
        }
        return null;
    }

    public static void removeAuxiliaryModule(Module toRemove) {
        SmartList usingModels = new SmartList();
        Project project = toRemove.getProject();
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        block0: for (Module module : moduleManager.getModules()) {
            if (module == toRemove) continue;
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
            for (OrderEntry entry : moduleRootManager.getOrderEntries()) {
                if (!(entry instanceof ModuleOrderEntry) || toRemove != ((ModuleOrderEntry)entry).getModule()) continue;
                usingModels.add(moduleRootManager.getModifiableModel());
                continue block0;
            }
        }
        ModifiableModuleModel moduleModel = moduleManager.getModifiableModel();
        ModuleDeleteProvider.removeModule((Module)toRemove, (Collection)usingModels, (ModifiableModuleModel)moduleModel);
        ModifiableModelCommitter.multiCommit((Collection)usingModels, (ModifiableModuleModel)moduleModel);
    }

    @NotNull
    public static Module createAuxiliaryModule(@NotNull Module appModule, String moduleName, MvcFramework framework) {
        if (appModule == null) {
            MvcModuleStructureUtil.$$$reportNull$$$0(12);
        }
        ModuleManager moduleManager = ModuleManager.getInstance((Project)appModule.getProject());
        ModifiableModuleModel moduleModel = moduleManager.getModifiableModel();
        String moduleFilePath = new File(appModule.getModuleFilePath()).getParent() + "/" + moduleName + ".iml";
        VirtualFile existing = LocalFileSystem.getInstance().findFileByPath(moduleFilePath);
        if (existing != null) {
            try {
                existing.delete((Object)"Grails/Griffon plugins maintenance");
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
        moduleModel.newModule(moduleFilePath, StdModuleTypes.JAVA.getId());
        moduleModel.commit();
        Module pluginsModule = moduleManager.findModuleByName(moduleName);
        assert (pluginsModule != null);
        ModifiableRootModel newRootModel = ModuleRootManager.getInstance((Module)pluginsModule).getModifiableModel();
        ModifiableRootModel appModel = ModuleRootManager.getInstance((Module)appModule).getModifiableModel();
        MvcModuleStructureUtil.copySdkAndLibraries((ModuleRootModel)appModel, newRootModel, framework);
        newRootModel.commit();
        appModel.commit();
        Module module = pluginsModule;
        if (module == null) {
            MvcModuleStructureUtil.$$$reportNull$$$0(13);
        }
        return module;
    }

    public static void ensureDependency(@NotNull Module from, @NotNull Module to, boolean exported) {
        if (from == null) {
            MvcModuleStructureUtil.$$$reportNull$$$0(14);
        }
        if (to == null) {
            MvcModuleStructureUtil.$$$reportNull$$$0(15);
        }
        if (!from.equals(to) && !MvcModuleStructureUtil.hasDependency(from, to)) {
            ModuleRootModificationUtil.addDependency((Module)from, (Module)to, (DependencyScope)DependencyScope.COMPILE, (boolean)exported);
        }
    }

    public static boolean hasDependency(@NotNull Module from, @NotNull Module to) {
        if (from == null) {
            MvcModuleStructureUtil.$$$reportNull$$$0(16);
        }
        if (to == null) {
            MvcModuleStructureUtil.$$$reportNull$$$0(17);
        }
        for (OrderEntry entry : ModuleRootManager.getInstance((Module)from).getOrderEntries()) {
            ModuleOrderEntry moduleOrderEntry;
            if (!(entry instanceof ModuleOrderEntry) || to != (moduleOrderEntry = (ModuleOrderEntry)entry).getModule()) continue;
            return true;
        }
        return false;
    }

    public static void removeDependency(@NotNull Module from, @NotNull Module to) {
        if (from == null) {
            MvcModuleStructureUtil.$$$reportNull$$$0(18);
        }
        if (to == null) {
            MvcModuleStructureUtil.$$$reportNull$$$0(19);
        }
        if (!from.equals(to) && MvcModuleStructureUtil.hasDependency(from, to)) {
            ModifiableRootModel fromModel = ModuleRootManager.getInstance((Module)from).getModifiableModel();
            for (OrderEntry entry : fromModel.getOrderEntries()) {
                ModuleOrderEntry moduleOrderEntry;
                if (!(entry instanceof ModuleOrderEntry) || to != (moduleOrderEntry = (ModuleOrderEntry)entry).getModule()) continue;
                fromModel.removeOrderEntry((OrderEntry)moduleOrderEntry);
            }
            fromModel.commit();
        }
    }

    public static void copySdk(ModuleRootModel from, ModifiableRootModel to) {
        if (from.isSdkInherited()) {
            to.inheritSdk();
        } else {
            to.setSdk(from.getSdk());
        }
    }

    public static void copySdkAndLibraries(ModuleRootModel from, ModifiableRootModel to, @NotNull MvcFramework framework) {
        if (framework == null) {
            MvcModuleStructureUtil.$$$reportNull$$$0(20);
        }
        MvcModuleStructureUtil.copySdk(from, to);
        MvcModuleStructureUtil.copyUserLibraries(from, to, framework);
    }

    public static void copyUserLibraries(ModuleRootModel from, ModifiableRootModel to, @NotNull MvcFramework framework) {
        if (framework == null) {
            MvcModuleStructureUtil.$$$reportNull$$$0(21);
        }
        Library userLibraryTo = null;
        for (OrderEntry entry : to.getOrderEntries()) {
            LibraryOrderEntry libraryEntry;
            Library library;
            if (!(entry instanceof LibraryOrderEntry) || (library = (libraryEntry = (LibraryOrderEntry)entry).getLibrary()) == null) continue;
            String libraryName = libraryEntry.getLibraryName();
            if (libraryName != null && libraryName.startsWith(framework.getUserLibraryName())) {
                userLibraryTo = library;
                continue;
            }
            if (library.getTable() == null || libraryEntry.getScope().isForProductionRuntime() && !framework.isSDKLibrary(library)) continue;
            to.removeOrderEntry(entry);
        }
        Library userLibraryFrom = null;
        for (OrderEntry entry : from.getOrderEntries()) {
            LibraryOrderEntry libraryEntry;
            Library library;
            if (!(entry instanceof LibraryOrderEntry) || (library = (libraryEntry = (LibraryOrderEntry)entry).getLibrary()) == null) continue;
            String libraryName = library.getName();
            if (libraryName != null && libraryName.startsWith(framework.getUserLibraryName())) {
                userLibraryFrom = library;
                continue;
            }
            if (library.getTable() == null) continue;
            LibraryOrderEntry libraryOrderEntry = to.addLibraryEntry(library);
            libraryOrderEntry.setScope(DependencyScope.PROVIDED);
        }
        if (userLibraryTo == null) {
            if (userLibraryFrom == null) {
                return;
            }
            userLibraryTo = to.getModuleLibraryTable().createLibrary(framework.getUserLibraryName() + " (" + to.getModule().getName() + ')');
        } else {
            OrderEntry[] orderEntries = (OrderEntry[])to.getOrderEntries().clone();
            for (int i = 0; i < orderEntries.length; ++i) {
                OrderEntry orderEntry = orderEntries[i];
                if (!(orderEntry instanceof LibraryOrderEntry) || userLibraryTo != ((LibraryOrderEntry)orderEntry).getLibrary()) continue;
                System.arraycopy(orderEntries, i + 1, orderEntries, i, orderEntries.length - i - 1);
                orderEntries[orderEntries.length - 1] = orderEntry;
                to.rearrangeOrderEntries(orderEntries);
                break;
            }
        }
        Library.ModifiableModel model = userLibraryTo.getModifiableModel();
        for (String url : model.getUrls(OrderRootType.CLASSES)) {
            if (model.isJarDirectory(url)) continue;
            model.removeRoot(url, OrderRootType.CLASSES);
        }
        if (userLibraryFrom != null) {
            for (String url : userLibraryFrom.getUrls(OrderRootType.CLASSES)) {
                if (userLibraryFrom.isJarDirectory(url)) continue;
                model.addRoot(url, OrderRootType.CLASSES);
            }
        }
        model.commit();
    }

    public static Consumer<ModifiableRootModel> removeStaleContentEntries(Collection<VirtualFile> pluginDirs) {
        return modifiableRootModel -> {
            for (ContentEntry entry : modifiableRootModel.getContentEntries()) {
                if (pluginDirs.contains(entry.getFile())) continue;
                modifiableRootModel.removeContentEntry(entry);
            }
        };
    }

    public static void updateAuxModuleStructure(Module auxModule, Collection<VirtualFile> pluginDirs, MvcFramework framework) {
        ModifiableRootModel model;
        MvcProjectStructure structure = framework.createProjectStructure(auxModule, true);
        Pair<Collection<Consumer<ModifiableRootModel>>, Collection<Consumer<ModifiableFacetModel>>> actions = MvcModuleStructureUtil.getUpdateProjectStructureActions(pluginDirs, structure);
        for (ContentEntry root : ModuleRootManager.getInstance((Module)auxModule).getContentEntries()) {
            if (pluginDirs.contains(root.getFile())) continue;
            ((Collection)actions.first).add(MvcModuleStructureUtil.removeStaleContentEntries(pluginDirs));
            break;
        }
        if (!((Collection)actions.first).isEmpty()) {
            ((Collection)actions.first).add(MvcModuleStructureUtil.exportDefaultLibrary(structure.getUserLibraryName()));
        }
        if (!((Collection)actions.first).isEmpty()) {
            model = ModuleRootManager.getInstance((Module)auxModule).getModifiableModel();
            for (Consumer pluginsUpdateAction : (Collection)actions.first) {
                pluginsUpdateAction.consume((Object)model);
            }
            model.commit();
        }
        if (!((Collection)actions.second).isEmpty()) {
            model = FacetManager.getInstance((Module)auxModule).createModifiableModel();
            for (Consumer action : (Collection)actions.second) {
                action.consume((Object)model);
            }
            model.commit();
        }
    }

    public static Consumer<ModifiableRootModel> exportDefaultLibrary(String libraryName) {
        return modifiableRootModel -> {
            for (OrderEntry entry : modifiableRootModel.getOrderEntries()) {
                LibraryOrderEntry libraryOrderEntry;
                String lName;
                if (!(entry instanceof LibraryOrderEntry) || (lName = (libraryOrderEntry = (LibraryOrderEntry)entry).getLibraryName()) == null || !lName.startsWith(libraryName)) continue;
                libraryOrderEntry.setExported(true);
            }
        };
    }

    private static boolean hasChildDirectory(VirtualFile file) {
        for (VirtualFile virtualFile : file.getChildren()) {
            if (!virtualFile.isDirectory()) continue;
            return true;
        }
        return false;
    }

    public static void updateGlobalPluginModule(@NotNull Project project, @NotNull MvcFramework framework) {
        if (project == null) {
            MvcModuleStructureUtil.$$$reportNull$$$0(22);
        }
        if (framework == null) {
            MvcModuleStructureUtil.$$$reportNull$$$0(23);
        }
        MultiMap map2 = new MultiMap();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            VirtualFile globalPluginsDir;
            if (!framework.hasSupport(module) || (globalPluginsDir = MvcModuleStructureUtil.refreshAndFind(framework.getGlobalPluginsDir(module))) == null || !MvcModuleStructureUtil.hasChildDirectory(globalPluginsDir)) continue;
            map2.putValue((Object)globalPluginsDir, (Object)module);
        }
        HashMap<VirtualFile, Module> globalAuxModules = new HashMap<VirtualFile, Module>();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            if (!framework.isGlobalPluginModule(module)) continue;
            VirtualFile[] contentRoots = ModuleRootManager.getInstance((Module)module).getContentRoots();
            VirtualFile parent2 = null;
            if (contentRoots.length > 0) {
                parent2 = contentRoots[0].getParent();
                if (!map2.containsKey((Object)parent2)) {
                    parent2 = null;
                } else {
                    for (int i = 1; i < contentRoots.length; ++i) {
                        if (Comparing.equal((Object)parent2, (Object)contentRoots[i].getParent())) continue;
                        parent2 = null;
                        break;
                    }
                }
            }
            if (parent2 == null) {
                MvcModuleStructureUtil.removeAuxiliaryModule(module);
                continue;
            }
            globalAuxModules.put(parent2, module);
        }
        for (VirtualFile virtualFile : map2.keySet()) {
            Module module;
            if (globalAuxModules.containsKey(virtualFile)) continue;
            Module appModule = (Module)map2.get((Object)virtualFile).iterator().next();
            module = MvcModuleStructureUtil.createAuxiliaryModule(appModule, MvcModuleStructureUtil.generateUniqueModuleName(project, framework.getGlobalPluginsModuleName()), framework);
            globalAuxModules.put(virtualFile, module);
        }
        assert (map2.size() == globalAuxModules.size());
        for (VirtualFile virtualFile : map2.keySet()) {
            ArrayList<VirtualFile> pluginRoots = new ArrayList<VirtualFile>();
            for (Module child : virtualFile.getChildren()) {
                if (!child.isDirectory()) continue;
                pluginRoots.add((VirtualFile)child);
            }
            assert (!pluginRoots.isEmpty());
            Module auxModule = (Module)globalAuxModules.get(virtualFile);
            MvcModuleStructureUtil.updateAuxModuleStructure(auxModule, pluginRoots, framework);
            for (Module appModule : map2.get((Object)virtualFile)) {
                MvcModuleStructureUtil.ensureDependency(appModule, auxModule, false);
                Module commonPluginsModule = framework.findCommonPluginsModule(appModule);
                if (commonPluginsModule == null) continue;
                MvcModuleStructureUtil.ensureDependency(commonPluginsModule, auxModule, false);
            }
        }
    }

    private static String generateUniqueModuleName(@NotNull Project project, String prefix) {
        String res;
        if (project == null) {
            MvcModuleStructureUtil.$$$reportNull$$$0(24);
        }
        ModuleManager manager = ModuleManager.getInstance((Project)project);
        int i = 0;
        do {
            res = i == 0 ? prefix : prefix + i;
            ++i;
        } while (manager.findModuleByName(res) != null);
        return res;
    }

    @Nullable
    public static Module updateAuxiliaryPluginsModuleRoots(Module appModule, MvcFramework framework) {
        Module commonPluginsModule = framework.findCommonPluginsModule(appModule);
        HashSet<VirtualFile> pluginRoots = new HashSet<VirtualFile>();
        VirtualFile globalPluginsDir = MvcModuleStructureUtil.refreshAndFind(framework.getGlobalPluginsDir(appModule));
        for (VirtualFile pluginRoot : framework.getCommonPluginRoots(appModule, true)) {
            if (!MvcModuleStructureUtil.checkValidity(pluginRoot) || globalPluginsDir != null && VfsUtil.isAncestor((VirtualFile)globalPluginsDir, (VirtualFile)pluginRoot, (boolean)true)) continue;
            pluginRoots.add(pluginRoot);
        }
        if (pluginRoots.isEmpty()) {
            if (commonPluginsModule != null) {
                MvcModuleStructureUtil.removeAuxiliaryModule(commonPluginsModule);
            }
            return null;
        }
        if (commonPluginsModule == null) {
            commonPluginsModule = MvcModuleStructureUtil.createAuxiliaryModule(appModule, framework.getCommonPluginsModuleName(appModule), framework);
        }
        MvcModuleStructureUtil.ensureDependency(appModule, commonPluginsModule, false);
        MvcModuleStructureUtil.updateAuxModuleStructure(commonPluginsModule, pluginRoots, framework);
        return commonPluginsModule;
    }

    public static Library findUserLibrary(@NotNull Module module, final @NotNull String name) {
        if (module == null) {
            MvcModuleStructureUtil.$$$reportNull$$$0(25);
        }
        if (name == null) {
            MvcModuleStructureUtil.$$$reportNull$$$0(26);
        }
        CommonProcessors.FindProcessor<Library> processor = new CommonProcessors.FindProcessor<Library>(){

            protected boolean accept(Library library) {
                String libraryName = library.getName();
                return libraryName != null && libraryName.startsWith(name);
            }
        };
        OrderEnumerator.orderEntries((Module)module).forEachLibrary((Processor)processor);
        return (Library)processor.getFoundValue();
    }

    @Nullable
    public static VirtualFile refreshAndFind(@Nullable File file) {
        return MvcModuleStructureUtil.findFile(file, true);
    }

    @Nullable
    public static VirtualFile findFile(@Nullable File file, boolean refresh) {
        if (file == null) {
            return null;
        }
        if (refresh) {
            ApplicationManager.getApplication().assertIsDispatchThread();
            return LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file);
        }
        return LocalFileSystem.getInstance().findFileByIoFile(file);
    }

    public static boolean isEnabledStructureUpdate() {
        return !Boolean.parseBoolean(System.getProperty("grails.disable.structure.update"));
    }

    private static /* synthetic */ void lambda$removeInvalidSourceRoots$11(Set toRemoveContent, Set toRemove, ModifiableRootModel model) {
        for (ContentEntry entry : model.getContentEntries()) {
            if (toRemoveContent.remove(entry.getUrl())) {
                model.removeContentEntry(entry);
                continue;
            }
            for (SourceFolder folder : entry.getSourceFolders()) {
                if (!toRemove.remove(folder)) continue;
                entry.removeSourceFolder(folder);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceRoots";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appModule";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginsModule";
                break;
            }
            case 10: 
            case 20: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "framework";
                break;
            }
            case 11: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/mvc/MvcModuleStructureUtil";
                break;
            }
            case 14: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 15: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/mvc/MvcModuleStructureUtil";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createAuxiliaryModule";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addSourceRootsAndLibDirectory";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removeSrcFolderFromRoots";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addSourceFolder";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "updateModuleStructure";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "syncAuxModuleSdk";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findApplicationProperties";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createAuxiliaryModule";
                break;
            }
            case 13: {
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "ensureDependency";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "hasDependency";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "removeDependency";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "copySdkAndLibraries";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "copyUserLibraries";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "updateGlobalPluginModule";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "generateUniqueModuleName";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "findUserLibrary";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

