/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.introduce.field;

import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.introduce.inplace.OccurrencesChooser;
import com.intellij.refactoring.introduceField.IntroduceFieldHandler;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMember;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.refactoring.GrRefactoringError;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringBundle;
import org.jetbrains.plugins.groovy.refactoring.introduce.GrAbstractInplaceIntroducer;
import org.jetbrains.plugins.groovy.refactoring.introduce.GrIntroduceContext;
import org.jetbrains.plugins.groovy.refactoring.introduce.GrIntroduceDialog;
import org.jetbrains.plugins.groovy.refactoring.introduce.GrIntroduceFieldHandlerBase;
import org.jetbrains.plugins.groovy.refactoring.introduce.StringPartInfo;
import org.jetbrains.plugins.groovy.refactoring.introduce.field.GrInplaceFieldIntroducer;
import org.jetbrains.plugins.groovy.refactoring.introduce.field.GrIntroduceFieldDialog;
import org.jetbrains.plugins.groovy.refactoring.introduce.field.GrIntroduceFieldProcessor;
import org.jetbrains.plugins.groovy.refactoring.introduce.field.GrIntroduceFieldSettings;

public class GrIntroduceFieldHandler
extends GrIntroduceFieldHandlerBase<GrIntroduceFieldSettings> {
    @Override
    @NotNull
    protected String getRefactoringName() {
        String string = IntroduceFieldHandler.getRefactoringNameText();
        if (string == null) {
            GrIntroduceFieldHandler.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String getHelpID() {
        return "refactoring.introduceField";
    }

    @Override
    protected void checkExpression(@NotNull GrExpression selectedExpr) {
        if (selectedExpr == null) {
            GrIntroduceFieldHandler.$$$reportNull$$$0(1);
        }
        GrIntroduceFieldHandler.checkContainingClass(selectedExpr);
    }

    private static void checkContainingClass(PsiElement place) {
        PsiClass containingClass = PsiUtil.getContextClass(place);
        if (containingClass == null) {
            throw new GrRefactoringError(GroovyRefactoringBundle.message("cannot.introduce.field.in.script", new Object[0]));
        }
        if (containingClass.isInterface()) {
            throw new GrRefactoringError(GroovyRefactoringBundle.message("cannot.introduce.field.in.interface", new Object[0]));
        }
        if (PsiUtil.skipParentheses(place, false) == null) {
            throw new GrRefactoringError(GroovyRefactoringBundle.message("expression.contains.errors", new Object[0]));
        }
    }

    @Override
    protected void checkVariable(@NotNull GrVariable variable) throws GrRefactoringError {
        if (variable == null) {
            GrIntroduceFieldHandler.$$$reportNull$$$0(2);
        }
        GrIntroduceFieldHandler.checkContainingClass(variable);
    }

    @Override
    protected void checkStringLiteral(@NotNull StringPartInfo info) throws GrRefactoringError {
        if (info == null) {
            GrIntroduceFieldHandler.$$$reportNull$$$0(3);
        }
        GrIntroduceFieldHandler.checkContainingClass(info.getLiteral());
    }

    @Override
    protected void checkOccurrences(PsiElement @NotNull [] occurrences) {
        if (occurrences == null) {
            GrIntroduceFieldHandler.$$$reportNull$$$0(4);
        }
    }

    @Override
    @NotNull
    protected GrIntroduceDialog<GrIntroduceFieldSettings> getDialog(@NotNull GrIntroduceContext context) {
        if (context == null) {
            GrIntroduceFieldHandler.$$$reportNull$$$0(5);
        }
        return new GrIntroduceFieldDialog(context);
    }

    @Override
    public GrVariable runRefactoring(@NotNull GrIntroduceContext context, @NotNull GrIntroduceFieldSettings settings) {
        if (context == null) {
            GrIntroduceFieldHandler.$$$reportNull$$$0(6);
        }
        if (settings == null) {
            GrIntroduceFieldHandler.$$$reportNull$$$0(7);
        }
        return new GrIntroduceFieldProcessor(context, settings).run();
    }

    @Override
    protected GrAbstractInplaceIntroducer<GrIntroduceFieldSettings> getIntroducer(@NotNull GrIntroduceContext context, @NotNull OccurrencesChooser.ReplaceChoice choice) {
        if (context == null) {
            GrIntroduceFieldHandler.$$$reportNull$$$0(8);
        }
        if (choice == null) {
            GrIntroduceFieldHandler.$$$reportNull$$$0(9);
        }
        Ref contextRef = Ref.create((Object)context);
        if (context.getStringPart() != null) {
            this.extractStringPart((Ref<GrIntroduceContext>)contextRef);
        }
        return new GrInplaceFieldIntroducer((GrIntroduceContext)contextRef.get(), choice);
    }

    @Override
    protected PsiElement @NotNull [] findOccurrences(@NotNull GrExpression expression, @NotNull PsiElement scope) {
        if (expression == null) {
            GrIntroduceFieldHandler.$$$reportNull$$$0(10);
        }
        if (scope == null) {
            GrIntroduceFieldHandler.$$$reportNull$$$0(11);
        }
        PsiElement[] occurrences = super.findOccurrences(expression, scope);
        if (GrIntroduceFieldHandler.shouldBeStatic(expression, scope)) {
            if (occurrences == null) {
                GrIntroduceFieldHandler.$$$reportNull$$$0(12);
            }
            return occurrences;
        }
        ArrayList<PsiElement> filtered = new ArrayList<PsiElement>();
        for (PsiElement occurrence : occurrences) {
            if (GrIntroduceFieldHandler.shouldBeStatic(occurrence, scope)) continue;
            filtered.add(occurrence);
        }
        PsiElement[] psiElementArray = filtered.toArray(PsiElement.EMPTY_ARRAY);
        if (psiElementArray == null) {
            GrIntroduceFieldHandler.$$$reportNull$$$0(13);
        }
        return psiElementArray;
    }

    @Nullable
    static GrMember getContainer(@Nullable PsiElement place, @Nullable PsiElement scope) {
        while (place != null && place != scope) {
            if (!((place = place.getParent()) instanceof GrMember)) continue;
            return (GrMember)place;
        }
        return null;
    }

    static boolean shouldBeStatic(PsiElement expr, PsiElement clazz) {
        GrMember method = GrIntroduceFieldHandler.getContainer(expr, clazz);
        if (method == null) {
            return false;
        }
        return method.hasModifierProperty("static");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/refactoring/introduce/field/GrIntroduceFieldHandler";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedExpr";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "occurrences";
                break;
            }
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "choice";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRefactoringName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/refactoring/introduce/field/GrIntroduceFieldHandler";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "findOccurrences";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "checkExpression";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkVariable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkStringLiteral";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkOccurrences";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDialog";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "runRefactoring";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getIntroducer";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findOccurrences";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

