/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.rename;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.resolve.imports.GroovyFileImports;
import org.jetbrains.plugins.groovy.lang.resolve.imports.GroovyNamedImport;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ClassResolverProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.processors.MethodResolverProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.processors.PropertyResolverProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ResolverProcessor;

public final class RenameAliasedUsagesUtil {
    private static final String EMPTY_ALIAS = "____00_______EMPTY_ALIAS_______00____";

    private RenameAliasedUsagesUtil() {
    }

    public static Collection<PsiReference> filterAliasedRefs(Collection<? extends PsiReference> refs, PsiElement element) {
        HashMap<GroovyFile, String> aliases = new HashMap<GroovyFile, String>();
        ArrayList<PsiReference> result2 = new ArrayList<PsiReference>();
        for (PsiReference psiReference : refs) {
            PsiElement e = psiReference.getElement();
            if (e == null || RenameAliasedUsagesUtil.skipReference(element, aliases, e)) continue;
            result2.add(psiReference);
        }
        return result2;
    }

    public static boolean skipReference(PsiElement member, Map<GroovyFile, String> aliases, PsiElement element) {
        PsiFile containingFile = element.getContainingFile();
        if (containingFile instanceof GroovyFile && RenameAliasedUsagesUtil.findAliasedName(aliases, (GroovyFile)containingFile, member) != EMPTY_ALIAS) {
            return PsiTreeUtil.getParentOfType((PsiElement)element, GrImportStatement.class, (boolean)true) == null;
        }
        return false;
    }

    private static String findAliasedName(Map<GroovyFile, String> map2, GroovyFile containingFile, PsiElement elementToResolve) {
        String s = map2.get(containingFile);
        if (s != null) {
            return s;
        }
        PsiManager manager = elementToResolve.getManager();
        ResolverProcessor processor = RenameAliasedUsagesUtil.getProcessor(elementToResolve, containingFile);
        GroovyFileImports fileImports = containingFile.getImports();
        for (GroovyNamedImport anImport : fileImports.getAllNamedImports()) {
            GroovyResolveResult[] results;
            if (!anImport.isAliased()) continue;
            anImport.processDeclarations(processor, ResolveState.initial(), containingFile, containingFile);
            for (GroovyResolveResult result2 : results = processor.getCandidates()) {
                if (!manager.areElementsEquivalent(elementToResolve, result2.getElement())) continue;
                String importedName = anImport.getName();
                map2.put(containingFile, importedName);
                return importedName;
            }
        }
        map2.put(containingFile, EMPTY_ALIAS);
        return EMPTY_ALIAS;
    }

    public static ResolverProcessor getProcessor(PsiElement element, GroovyPsiElement place) {
        if (element instanceof PsiMethod) {
            return new MethodResolverProcessor(null, place, false, null, null, PsiType.EMPTY_ARRAY);
        }
        if (element instanceof PsiField) {
            return new PropertyResolverProcessor(null, place);
        }
        if (element instanceof PsiClass) {
            return new ClassResolverProcessor(null, place);
        }
        throw new IllegalArgumentException("element must be method or field or class: " + element.getClass() + ", text=" + element.getText());
    }
}

