/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.shell;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.FindClassUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.config.GroovyConfigUtils;
import org.jetbrains.plugins.groovy.runner.DefaultGroovyScriptRunner;
import org.jetbrains.plugins.groovy.runner.GroovyScriptRunConfiguration;
import org.jetbrains.plugins.groovy.shell.GroovyShellConfig;
import org.jetbrains.plugins.groovy.util.LibrariesUtil;

public class DefaultGroovyShellRunner
extends GroovyShellConfig {
    private static final String[] REQUIRED_GROOVY_CLASSES = new String[]{"org.apache.commons.cli.CommandLineParser", "org.codehaus.groovy.tools.shell.Main", "org.fusesource.jansi.AnsiConsole"};

    @Override
    @NotNull
    public String getWorkingDirectory(@NotNull Module module) {
        if (module == null) {
            DefaultGroovyShellRunner.$$$reportNull$$$0(0);
        }
        VirtualFile[] contentRoots = ModuleRootManager.getInstance((Module)module).getContentRoots();
        String string = contentRoots[0].getPath();
        if (string == null) {
            DefaultGroovyShellRunner.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public JavaParameters createJavaParameters(@NotNull Module module) throws ExecutionException {
        if (module == null) {
            DefaultGroovyShellRunner.$$$reportNull$$$0(2);
        }
        JavaParameters res = GroovyScriptRunConfiguration.createJavaParametersWithSdk(module);
        DefaultGroovyScriptRunner.configureGenericGroovyRunner(res, module, "org.codehaus.groovy.tools.shell.Main", false, true);
        res.setWorkingDirectory(this.getWorkingDirectory(module));
        JavaParameters javaParameters = res;
        if (javaParameters == null) {
            DefaultGroovyShellRunner.$$$reportNull$$$0(3);
        }
        return javaParameters;
    }

    @Override
    public boolean canRun(@NotNull Module module) {
        VirtualFile[] contentRoots;
        if (module == null) {
            DefaultGroovyShellRunner.$$$reportNull$$$0(4);
        }
        return (contentRoots = ModuleRootManager.getInstance((Module)module).getContentRoots()).length > 0 && DefaultGroovyShellRunner.hasGroovyWithNeededJars(module);
    }

    @Override
    @NotNull
    public String getVersion(@NotNull Module module) {
        if (module == null) {
            DefaultGroovyShellRunner.$$$reportNull$$$0(5);
        }
        String homePath = LibrariesUtil.getGroovyHomePath(module);
        assert (homePath != null);
        String version = GroovyConfigUtils.getInstance().getSDKVersion(homePath);
        String string = version == "undefined" ? "" : "Groovy " + version;
        if (string == null) {
            DefaultGroovyShellRunner.$$$reportNull$$$0(6);
        }
        return string;
    }

    public static boolean hasGroovyWithNeededJars(Module module) {
        GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)module.getProject());
        for (String className : REQUIRED_GROOVY_CLASSES) {
            if (facade.findClass(className, scope) != null) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isSuitableModule(Module module) {
        return super.isSuitableModule(module) && DefaultGroovyShellRunner.hasGroovyWithNeededJars(module);
    }

    @Override
    public Collection<Module> getPossiblySuitableModules(Project project) {
        LinkedHashSet results = null;
        for (String className : REQUIRED_GROOVY_CLASSES) {
            Collection someModules = FindClassUtil.findModulesWithClass((Project)project, (String)className);
            if (results == null) {
                results = new LinkedHashSet(someModules);
            } else {
                results.retainAll(someModules);
            }
            if (!results.isEmpty()) continue;
            return ContainerUtil.emptyList();
        }
        return results;
    }

    @Override
    public String getTitle() {
        return "Groovy Shell";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/shell/DefaultGroovyShellRunner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/shell/DefaultGroovyShellRunner";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getWorkingDirectory";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createJavaParameters";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getWorkingDirectory";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createJavaParameters";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "canRun";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getVersion";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

