/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.shell;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootModificationTracker;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.shell.GroovyShellConfig;
import org.jetbrains.plugins.groovy.shell.GroovyShellRunnerImpl;
import org.jetbrains.plugins.groovy.util.ModuleChooserUtil;

public abstract class GroovyShellActionBase
extends AnAction {
    private final GroovyShellConfig myConfig;
    private final Condition<Module> APPLICABLE_MODULE = new Condition<Module>(){

        public boolean value(Module module) {
            return GroovyShellActionBase.this.myConfig.isSuitableModule(module);
        }
    };
    private final Key<CachedValue<Boolean>> APPLICABLE_MODULE_CACHE = Key.create((String)"APPLICABLE_MODULE_CACHE");
    private final Consumer<Module> RUNNER = new Consumer<Module>(){

        public void consume(Module module) {
            GroovyShellRunnerImpl.doRunShell(GroovyShellActionBase.this.myConfig, module);
        }
    };

    public GroovyShellActionBase(GroovyShellConfig runner) {
        this.myConfig = runner;
    }

    public void update(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            GroovyShellActionBase.$$$reportNull$$$0(0);
        }
        boolean enabled = (project = (Project)e.getData(CommonDataKeys.PROJECT)) != null && this.hasGroovyCompatibleModule(project);
        e.getPresentation().setEnabledAndVisible(enabled);
    }

    private boolean hasGroovyCompatibleModule(Project project) {
        return (Boolean)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, this.APPLICABLE_MODULE_CACHE, () -> {
            Collection<Module> possibleModules = this.myConfig.getPossiblySuitableModules(project);
            return CachedValueProvider.Result.create((Object)ModuleChooserUtil.hasGroovyCompatibleModules(possibleModules, this.APPLICABLE_MODULE), (Object[])new Object[]{ProjectRootModificationTracker.getInstance((Project)project)});
        }, false);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            GroovyShellActionBase.$$$reportNull$$$0(1);
        }
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        assert (project != null);
        List<Module> suitableModules = ModuleChooserUtil.filterGroovyCompatibleModules(this.myConfig.getPossiblySuitableModules(project), this.APPLICABLE_MODULE);
        ModuleChooserUtil.selectModule(project, suitableModules, (Function<Module, String>)((Function)this.myConfig::getVersion), this.RUNNER);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "org/jetbrains/plugins/groovy/shell/GroovyShellActionBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

