/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import com.intellij.codeInsight.MetaAnnotationUtil;
import com.intellij.diagnostic.logging.LogConfigurationPanel;
import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.ExternalizablePath;
import com.intellij.execution.InputRedirectAware;
import com.intellij.execution.JUnitBundle;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.JavaRunConfigurationExtensionManager;
import com.intellij.execution.JavaTestConfigurationWithDiscoverySupport;
import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.RunConfigurationExtension;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.application.ApplicationConfiguration;
import com.intellij.execution.configuration.EnvironmentVariablesComponent;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.junit.JUnitConfigurationType;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.execution.junit.PatternConfigurationProducer;
import com.intellij.execution.junit.RefactoringListeners;
import com.intellij.execution.junit.TestObject;
import com.intellij.execution.junit.UnknownTestTarget;
import com.intellij.execution.junit2.configuration.JUnitConfigurable;
import com.intellij.execution.junit2.info.MethodLocation;
import com.intellij.execution.junit2.ui.properties.JUnitConsoleProperties;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.testframework.TestSearchScope;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.execution.util.JavaParametersUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorGroup;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.DifferenceFilter;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.util.ClassUtil;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.util.ArrayUtilRt;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JUnitConfiguration
extends JavaTestConfigurationWithDiscoverySupport
implements InputRedirectAware {
    public static final byte FRAMEWORK_ID = 0;
    @NonNls
    public static final String TEST_CLASS = "class";
    @NonNls
    public static final String TEST_PACKAGE = "package";
    @NonNls
    public static final String TEST_DIRECTORY = "directory";
    @NonNls
    public static final String TEST_CATEGORY = "category";
    @NonNls
    public static final String TEST_METHOD = "method";
    @NonNls
    public static final String TEST_UNIQUE_ID = "uniqueId";
    @NonNls
    public static final String TEST_TAGS = "tags";
    @NonNls
    public static final String BY_SOURCE_POSITION = "source location";
    @NonNls
    public static final String BY_SOURCE_CHANGES = "changes";
    @NonNls
    public static final String FORK_NONE = "none";
    @NonNls
    public static final String FORK_METHOD = "method";
    @NonNls
    public static final String FORK_KLASS = "class";
    @NonNls
    public static final String FORK_REPEAT = "repeat";
    @NonNls
    public static final String JUNIT_START_CLASS = "com.intellij.rt.junit.JUnitStarter";
    @NonNls
    private static final String PATTERN_EL_NAME = "pattern";
    @NonNls
    public static final String TEST_PATTERN = "pattern";
    @NonNls
    private static final String TEST_CLASS_ATT_NAME = "testClass";
    @NonNls
    private static final String PATTERNS_EL_NAME = "patterns";
    private final Data myData;
    private final InputRedirectAware.InputRedirectOptionsImpl myInputRedirectOptions;
    final RefactoringListeners.Accessor<PsiPackage> myPackage;
    final RefactoringListeners.Accessor<PsiClass> myClass;
    final RefactoringListeners.Accessor<PsiClass> myCategory;
    public boolean ALTERNATIVE_JRE_PATH_ENABLED;
    public String ALTERNATIVE_JRE_PATH;

    public JUnitConfiguration(String name, Project project, ConfigurationFactory configurationFactory) {
        this(name, project, new Data(), configurationFactory);
    }

    public JUnitConfiguration(String name, Project project) {
        this(name, project, new Data(), JUnitConfigurationType.getInstance().getConfigurationFactories()[0]);
    }

    protected JUnitConfiguration(String name, Project project, Data data, ConfigurationFactory configurationFactory) {
        super(name, new JavaRunConfigurationModule(project, true), configurationFactory);
        this.myInputRedirectOptions = new InputRedirectAware.InputRedirectOptionsImpl();
        this.myPackage = new RefactoringListeners.Accessor<PsiPackage>(){

            public void setName(String qualifiedName) {
                boolean generatedName = JUnitConfiguration.this.isGeneratedName();
                ((JUnitConfiguration)JUnitConfiguration.this).myData.PACKAGE_NAME = qualifiedName;
                if (generatedName) {
                    JUnitConfiguration.this.setGeneratedName();
                }
            }

            public PsiPackage getPsiElement() {
                String qualifiedName = JUnitConfiguration.this.myData.getPackageName();
                return qualifiedName != null ? JavaPsiFacade.getInstance((Project)JUnitConfiguration.this.getProject()).findPackage(qualifiedName) : null;
            }

            public void setPsiElement(PsiPackage psiPackage) {
                this.setName(psiPackage.getQualifiedName());
            }
        };
        this.myClass = new RefactoringListeners.Accessor<PsiClass>(){

            public void setName(@NotNull String qualifiedName) {
                if (qualifiedName == null) {
                    2.$$$reportNull$$$0(0);
                }
                boolean generatedName = JUnitConfiguration.this.isGeneratedName();
                ((JUnitConfiguration)JUnitConfiguration.this).myData.MAIN_CLASS_NAME = qualifiedName;
                if (generatedName) {
                    JUnitConfiguration.this.setGeneratedName();
                }
            }

            public PsiClass getPsiElement() {
                return ((JavaRunConfigurationModule)JUnitConfiguration.this.getConfigurationModule()).findClass(JUnitConfiguration.this.myData.getMainClassName());
            }

            public void setPsiElement(PsiClass psiClass) {
                Module originalModule = ((JavaRunConfigurationModule)JUnitConfiguration.this.getConfigurationModule()).getModule();
                JUnitConfiguration.this.setMainClass(psiClass);
                JUnitConfiguration.this.restoreOriginalModule(originalModule);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/intellij/execution/junit/JUnitConfiguration$2", "setName"));
            }
        };
        this.myCategory = new RefactoringListeners.Accessor<PsiClass>(){

            public void setName(@NotNull String qualifiedName) {
                if (qualifiedName == null) {
                    3.$$$reportNull$$$0(0);
                }
                JUnitConfiguration.this.setCategory(qualifiedName);
            }

            public PsiClass getPsiElement() {
                return ((JavaRunConfigurationModule)JUnitConfiguration.this.getConfigurationModule()).findClass(JUnitConfiguration.this.myData.getCategory());
            }

            public void setPsiElement(PsiClass psiClass) {
                JUnitConfiguration.this.setCategory(JavaExecutionUtil.getRuntimeQualifiedName((PsiClass)psiClass));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/intellij/execution/junit/JUnitConfiguration$3", "setName"));
            }
        };
        this.myData = data;
    }

    protected JUnitConfiguration(@NotNull Project project, Data data, @NotNull ConfigurationFactory configurationFactory) {
        if (project == null) {
            JUnitConfiguration.$$$reportNull$$$0(0);
        }
        if (configurationFactory == null) {
            JUnitConfiguration.$$$reportNull$$$0(1);
        }
        super(new JavaRunConfigurationModule(project, true), configurationFactory);
        this.myInputRedirectOptions = new InputRedirectAware.InputRedirectOptionsImpl();
        this.myPackage = new /* invalid duplicate definition of identical inner class */;
        this.myClass = new /* invalid duplicate definition of identical inner class */;
        this.myCategory = new /* invalid duplicate definition of identical inner class */;
        this.myData = data;
    }

    public TestObject getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (executor == null) {
            JUnitConfiguration.$$$reportNull$$$0(2);
        }
        if (env == null) {
            JUnitConfiguration.$$$reportNull$$$0(3);
        }
        TestObject testObject = TestObject.fromString(this.myData.TEST_OBJECT, this, env);
        DumbService dumbService = DumbService.getInstance((Project)this.getProject());
        if (dumbService.isDumb() && !DumbService.isDumbAware((Object)((Object)testObject))) {
            throw new ExecutionException("Running tests is disabled during index update");
        }
        return testObject;
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        SettingsEditorGroup group = new SettingsEditorGroup();
        group.addEditor(ExecutionBundle.message((String)"run.configuration.configuration.tab.title", (Object[])new Object[0]), new JUnitConfigurable(this.getProject()));
        JavaRunConfigurationExtensionManager.getInstance().appendEditors((RunConfigurationBase)this, group);
        group.addEditor(ExecutionBundle.message((String)"logs.tab.title", (Object[])new Object[0]), (SettingsEditor)new LogConfigurationPanel());
        SettingsEditorGroup settingsEditorGroup = group;
        if (settingsEditorGroup == null) {
            JUnitConfiguration.$$$reportNull$$$0(4);
        }
        return settingsEditorGroup;
    }

    public Data getPersistentData() {
        return this.myData;
    }

    public RefactoringElementListener getRefactoringElementListener(PsiElement element) {
        RefactoringElementListener listener = this.getTestObject().getListener(element, this);
        return RunConfigurationExtension.wrapRefactoringElementListener((PsiElement)element, (RunConfigurationBase)this, (RefactoringElementListener)listener);
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        this.getTestObject().checkConfiguration();
        JavaRunConfigurationExtensionManager.checkConfigurationIsValid((RunConfigurationBase)this);
    }

    public Collection<Module> getValidModules() {
        if (TEST_PACKAGE.equals(this.myData.TEST_OBJECT) || "pattern".equals(this.myData.TEST_OBJECT)) {
            return Arrays.asList(ModuleManager.getInstance((Project)this.getProject()).getModules());
        }
        try {
            this.getTestObject().checkConfiguration();
        }
        catch (RuntimeConfigurationError e) {
            return Arrays.asList(ModuleManager.getInstance((Project)this.getProject()).getModules());
        }
        catch (RuntimeConfigurationException runtimeConfigurationException) {
            // empty catch block
        }
        return JavaRunConfigurationModule.getModulesForClass((Project)this.getProject(), (String)this.myData.getMainClassName());
    }

    public String suggestedName() {
        String repeat;
        switch (this.getRepeatMode()) {
            case "Until Stopped": 
            case "Until Failure": {
                repeat = " [*]";
                break;
            }
            case "N Times": {
                repeat = " [" + this.getRepeatCount() + "]";
                break;
            }
            default: {
                repeat = "";
            }
        }
        String generatedName = this.myData.getGeneratedName((JavaRunConfigurationModule)this.getConfigurationModule());
        if (generatedName == null) {
            return null;
        }
        return generatedName + repeat;
    }

    public String getActionName() {
        return this.getTestObject().suggestActionName();
    }

    public String getVMParameters() {
        return this.myData.getVMParameters();
    }

    public void setVMParameters(@Nullable String value) {
        this.myData.setVMParameters(StringUtil.nullize((String)value));
    }

    public String getProgramParameters() {
        return this.myData.getProgramParameters();
    }

    public void setProgramParameters(String value) {
        this.myData.setProgramParameters(value);
    }

    public String getWorkingDirectory() {
        return this.myData.getWorkingDirectory();
    }

    public void setWorkingDirectory(String value) {
        this.myData.setWorkingDirectory(value);
    }

    @NotNull
    public Map<String, String> getEnvs() {
        Map<String, String> map = this.myData.getEnvs();
        if (map == null) {
            JUnitConfiguration.$$$reportNull$$$0(5);
        }
        return map;
    }

    public void setEnvs(@NotNull Map<String, String> envs) {
        if (envs == null) {
            JUnitConfiguration.$$$reportNull$$$0(6);
        }
        this.myData.setEnvs(envs);
    }

    public boolean isPassParentEnvs() {
        return this.myData.PASS_PARENT_ENVS;
    }

    public void setPassParentEnvs(boolean passParentEnvs) {
        this.myData.PASS_PARENT_ENVS = passParentEnvs;
    }

    public boolean isAlternativeJrePathEnabled() {
        return this.ALTERNATIVE_JRE_PATH_ENABLED;
    }

    public void setAlternativeJrePathEnabled(boolean enabled) {
        boolean changed = this.ALTERNATIVE_JRE_PATH_ENABLED != enabled;
        this.ALTERNATIVE_JRE_PATH_ENABLED = enabled;
        ApplicationConfiguration.onAlternativeJreChanged((boolean)changed, (Project)this.getProject());
    }

    public String getAlternativeJrePath() {
        return this.ALTERNATIVE_JRE_PATH;
    }

    public void setAlternativeJrePath(String path) {
        boolean changed = !Objects.equals(this.ALTERNATIVE_JRE_PATH, path);
        this.ALTERNATIVE_JRE_PATH = path;
        ApplicationConfiguration.onAlternativeJreChanged((boolean)changed, (Project)this.getProject());
    }

    public String getRunClass() {
        Data data = this.getPersistentData();
        return !Comparing.strEqual((String)data.TEST_OBJECT, (String)"class") && !Comparing.strEqual((String)data.TEST_OBJECT, (String)"method") ? null : data.getMainClassName();
    }

    public String getPackage() {
        Data data = this.getPersistentData();
        return !Comparing.strEqual((String)data.TEST_OBJECT, (String)TEST_PACKAGE) ? null : data.getPackageName();
    }

    public void beClassConfiguration(PsiClass testClass) {
        if ("class".equals(this.getForkMode())) {
            this.setForkMode(FORK_NONE);
        }
        this.setMainClass(testClass);
        this.myData.TEST_OBJECT = "class";
        this.setGeneratedName();
    }

    public boolean isConfiguredByElement(PsiElement element) {
        PsiClass testClass = JUnitUtil.getTestClass((PsiElement)element);
        PsiMethod testMethod = JUnitUtil.getTestMethod((PsiElement)element, (boolean)false);
        Object testPackage = element instanceof PsiPackage ? (PsiPackage)element : (element instanceof PsiDirectory ? JavaDirectoryService.getInstance().getPackage((PsiDirectory)element) : null);
        PsiDirectory testDir = element instanceof PsiDirectory ? (PsiDirectory)element : null;
        return this.getTestObject().isConfiguredByElement(this, testClass, testMethod, (PsiPackage)testPackage, testDir);
    }

    public String getTestType() {
        return this.getPersistentData().TEST_OBJECT;
    }

    public TestSearchScope getTestSearchScope() {
        return this.getPersistentData().getScope();
    }

    public void setSearchScope(TestSearchScope searchScope) {
        this.getPersistentData().setScope(searchScope);
    }

    public void beFromSourcePosition(PsiLocation<? extends PsiMethod> sourceLocation) {
        this.myData.setTestMethod((Location<? extends PsiMethod>)sourceLocation);
        this.myData.TEST_OBJECT = BY_SOURCE_POSITION;
    }

    public void setMainClass(PsiClass testClass) {
        boolean shouldUpdateName = this.isGeneratedName();
        this.setModule(this.myData.setMainClass(testClass));
        if (shouldUpdateName) {
            this.setGeneratedName();
        }
    }

    public void setCategory(String categoryName) {
        boolean shouldUpdateName = this.isGeneratedName();
        this.myData.setCategoryName(categoryName);
        if (shouldUpdateName) {
            this.setGeneratedName();
        }
    }

    public void beMethodConfiguration(Location<PsiMethod> methodLocation) {
        this.setForkMode(FORK_NONE);
        this.setModule(this.myData.setTestMethod(methodLocation));
        this.setGeneratedName();
    }

    public Module @NotNull [] getModules() {
        if (TEST_PACKAGE.equals(this.myData.TEST_OBJECT) && this.getPersistentData().getScope() == TestSearchScope.WHOLE_PROJECT) {
            if (Module.EMPTY_ARRAY == null) {
                JUnitConfiguration.$$$reportNull$$$0(7);
            }
            return Module.EMPTY_ARRAY;
        }
        Module[] moduleArray = super.getModules();
        if (moduleArray == null) {
            JUnitConfiguration.$$$reportNull$$$0(8);
        }
        return moduleArray;
    }

    public TestObject getTestObject() {
        return this.myData.getTestObject(this);
    }

    @NotNull
    public InputRedirectAware.InputRedirectOptions getInputRedirectOptions() {
        InputRedirectAware.InputRedirectOptionsImpl inputRedirectOptionsImpl = this.myInputRedirectOptions;
        if (inputRedirectOptionsImpl == null) {
            JUnitConfiguration.$$$reportNull$$$0(9);
        }
        return inputRedirectOptionsImpl;
    }

    public void readExternal(@NotNull Element element) throws InvalidDataException {
        Element tagElement;
        Element idsElement;
        Element categoryNameElement;
        Element dirNameElement;
        String repeatMode;
        String count;
        String mode;
        Element forkModeElement;
        if (element == null) {
            JUnitConfiguration.$$$reportNull$$$0(10);
        }
        super.readExternal(element);
        JavaRunConfigurationExtensionManager.getInstance().readExternal((RunConfigurationBase)this, element);
        DefaultJDOMExternalizer.readExternal((Object)((Object)this), (Element)element);
        DefaultJDOMExternalizer.readExternal((Object)this.getPersistentData(), (Element)element);
        EnvironmentVariablesComponent.readExternal((Element)element, this.getPersistentData().getEnvs());
        Element patternsElement = element.getChild(PATTERNS_EL_NAME);
        if (patternsElement != null) {
            LinkedHashSet<String> tests = new LinkedHashSet<String>();
            for (Element patternElement : patternsElement.getChildren("pattern")) {
                tests.add(patternElement.getAttributeValue(TEST_CLASS_ATT_NAME));
            }
            this.myData.setPatterns(tests);
        }
        if ((forkModeElement = element.getChild("fork_mode")) != null && (mode = forkModeElement.getAttributeValue("value")) != null) {
            this.setForkMode(mode);
        }
        if ((count = element.getAttributeValue("repeat_count")) != null) {
            try {
                this.setRepeatCount(Integer.parseInt(count));
            }
            catch (NumberFormatException e) {
                this.setRepeatCount(1);
            }
        }
        if ((repeatMode = element.getAttributeValue("repeat_mode")) != null) {
            this.setRepeatMode(repeatMode);
        }
        if ((dirNameElement = element.getChild("dir")) != null) {
            String dirName = dirNameElement.getAttributeValue("value");
            this.getPersistentData().setDirName(FileUtil.toSystemDependentName((String)dirName));
        }
        if ((categoryNameElement = element.getChild(TEST_CATEGORY)) != null) {
            String categoryName = categoryNameElement.getAttributeValue("value");
            this.getPersistentData().setCategoryName(categoryName);
        }
        if ((idsElement = element.getChild("uniqueIds")) != null) {
            ArrayList ids = new ArrayList();
            idsElement.getChildren(TEST_UNIQUE_ID).forEach(uniqueIdElement -> ids.add(uniqueIdElement.getAttributeValue("value")));
            this.getPersistentData().setUniqueIds(ArrayUtilRt.toStringArray(ids));
        }
        if ((tagElement = element.getChild("tag")) != null) {
            this.getPersistentData().setTags(tagElement.getAttributeValue("value"));
        } else {
            Element tagsElement = element.getChild(TEST_TAGS);
            if (tagsElement != null) {
                ArrayList tags = new ArrayList();
                tagsElement.getChildren("tag").forEach(tElement -> tags.add(tElement.getAttributeValue("value")));
                this.getPersistentData().setTags(StringUtil.join(tags, (String)"|"));
            }
        }
        this.myInputRedirectOptions.readExternal(element);
    }

    public void writeExternal(@NotNull Element element) {
        String tags;
        String[] ids;
        String repeatMode;
        String forkMode;
        String categoryName;
        String dirName;
        if (element == null) {
            JUnitConfiguration.$$$reportNull$$$0(11);
        }
        super.writeExternal(element);
        JavaRunConfigurationExtensionManager.getInstance().writeExternal((RunConfigurationBase)this, element);
        DefaultJDOMExternalizer.writeExternal((Object)((Object)this), (Element)element, (DefaultJDOMExternalizer.JDOMFilter)JavaParametersUtil.getFilter((CommonJavaRunConfigurationParameters)this));
        Data persistentData = this.getPersistentData();
        DefaultJDOMExternalizer.writeExternal((Object)persistentData, (Element)element, (DefaultJDOMExternalizer.JDOMFilter)new DifferenceFilter<Data>(persistentData, new Data()){

            public boolean isAccept(@NotNull Field field) {
                if (field == null) {
                    4.$$$reportNull$$$0(0);
                }
                return "TEST_OBJECT".equals(field.getName()) || super.isAccept(field);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/execution/junit/JUnitConfiguration$4", "isAccept"));
            }
        });
        if (!persistentData.getEnvs().isEmpty()) {
            EnvironmentVariablesComponent.writeExternal((Element)element, persistentData.getEnvs());
        }
        if (!(dirName = persistentData.getDirName()).isEmpty()) {
            Element dirNameElement = new Element("dir");
            dirNameElement.setAttribute("value", FileUtil.toSystemIndependentName((String)dirName));
            element.addContent(dirNameElement);
        }
        if (!(categoryName = persistentData.getCategory()).isEmpty()) {
            Element categoryNameElement = new Element(TEST_CATEGORY);
            categoryNameElement.setAttribute("value", categoryName);
            element.addContent(categoryNameElement);
        }
        if (!persistentData.getPatterns().isEmpty()) {
            Element patternsElement = new Element(PATTERNS_EL_NAME);
            for (String o : persistentData.getPatterns()) {
                Element patternElement = new Element("pattern");
                patternElement.setAttribute(TEST_CLASS_ATT_NAME, o);
                patternsElement.addContent(patternElement);
            }
            element.addContent(patternsElement);
        }
        if (!(forkMode = this.getForkMode()).equals(FORK_NONE)) {
            Element forkModeElement = new Element("fork_mode");
            forkModeElement.setAttribute("value", forkMode);
            element.addContent(forkModeElement);
        }
        if (this.getRepeatCount() != 1) {
            element.setAttribute("repeat_count", String.valueOf(this.getRepeatCount()));
        }
        if (!"Once".equals(repeatMode = this.getRepeatMode())) {
            element.setAttribute("repeat_mode", repeatMode);
        }
        if ((ids = persistentData.getUniqueIds()) != null && ids.length > 0) {
            Element uniqueIds = new Element("uniqueIds");
            Arrays.stream(ids).forEach(id -> uniqueIds.addContent(new Element(TEST_UNIQUE_ID).setAttribute("value", id)));
            element.addContent(uniqueIds);
        }
        if ((tags = persistentData.getTags()) != null && tags.length() > 0) {
            Element tagsElement = new Element("tag");
            tagsElement.setAttribute("value", tags);
            element.addContent(tagsElement);
        }
        this.myInputRedirectOptions.writeExternal(element);
    }

    public String getForkMode() {
        return this.myData.FORK_MODE;
    }

    public void setForkMode(@NotNull String forkMode) {
        if (forkMode == null) {
            JUnitConfiguration.$$$reportNull$$$0(12);
        }
        this.myData.FORK_MODE = forkMode;
    }

    public boolean collectOutputFromProcessHandler() {
        return false;
    }

    public void bePatternConfiguration(List<PsiClass> classes, PsiMethod method) {
        String methodSufiix;
        this.myData.TEST_OBJECT = "pattern";
        LinkedHashSet<String> patterns = new LinkedHashSet<String>();
        if (method != null) {
            this.myData.METHOD_NAME = Data.getMethodPresentation(method);
            methodSufiix = "," + this.myData.METHOD_NAME;
        } else {
            methodSufiix = "";
        }
        for (PsiClass pattern : classes) {
            patterns.add(JavaExecutionUtil.getRuntimeQualifiedName((PsiClass)pattern) + methodSufiix);
        }
        this.myData.setPatterns(patterns);
        Module module = ((PatternConfigurationProducer)RunConfigurationProducer.getInstance(PatternConfigurationProducer.class)).findModule((ModuleBasedConfiguration)this, ((JavaRunConfigurationModule)this.getConfigurationModule()).getModule(), patterns);
        if (module == null) {
            this.myData.setScope(TestSearchScope.WHOLE_PROJECT);
            this.setModule(null);
        } else {
            this.setModule(module);
        }
        this.setGeneratedName();
    }

    public int getRepeatCount() {
        return this.myData.REPEAT_COUNT;
    }

    public void setRepeatCount(int repeatCount) {
        this.myData.REPEAT_COUNT = repeatCount;
    }

    public String getRepeatMode() {
        return this.myData.REPEAT_MODE;
    }

    public void setRepeatMode(String repeatMode) {
        this.myData.REPEAT_MODE = repeatMode;
    }

    @NotNull
    public SMTRunnerConsoleProperties createTestConsoleProperties(@NotNull Executor executor) {
        if (executor == null) {
            JUnitConfiguration.$$$reportNull$$$0(13);
        }
        return new JUnitConsoleProperties(this, executor);
    }

    public byte getTestFrameworkId() {
        return 0;
    }

    public static String getDefaultPackageName() {
        return JUnitBundle.message("default.package.presentable.name", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationFactory";
                break;
            }
            case 2: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/junit/JUnitConfiguration";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envs";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forkMode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/junit/JUnitConfiguration";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationEditor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvs";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getModules";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputRedirectOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setEnvs";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setForkMode";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createTestConsoleProperties";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Data
    implements Cloneable {
        public String PACKAGE_NAME;
        public String MAIN_CLASS_NAME;
        public String METHOD_NAME;
        private String[] UNIQUE_ID = ArrayUtilRt.EMPTY_STRING_ARRAY;
        private String TAGS;
        public String TEST_OBJECT = "class";
        public String VM_PARAMETERS = "-ea";
        public String PARAMETERS;
        public String WORKING_DIRECTORY = "$MODULE_WORKING_DIR$";
        public boolean PASS_PARENT_ENVS = true;
        public TestSearchScope.Wrapper TEST_SEARCH_SCOPE = new TestSearchScope.Wrapper();
        private String DIR_NAME;
        private String CATEGORY_NAME;
        private String FORK_MODE = "none";
        private int REPEAT_COUNT = 1;
        private String REPEAT_MODE = "Once";
        private LinkedHashSet<String> myPattern = new LinkedHashSet();
        private Map<String, String> myEnvs = new LinkedHashMap<String, String>();
        private String myChangeList = "All";

        public boolean equals(Object object) {
            if (!(object instanceof Data)) {
                return false;
            }
            Data second = (Data)object;
            return Objects.equals(this.TEST_OBJECT, second.TEST_OBJECT) && Objects.equals(this.getMainClassName(), second.getMainClassName()) && Objects.equals(this.getPackageName(), second.getPackageName()) && Objects.equals(this.getMethodNameWithSignature(), second.getMethodNameWithSignature()) && Objects.equals(this.getWorkingDirectory(), second.getWorkingDirectory()) && Objects.equals(this.VM_PARAMETERS, second.VM_PARAMETERS) && Objects.equals(this.PARAMETERS, second.PARAMETERS) && Comparing.equal(this.myPattern, second.myPattern) && Objects.equals(this.FORK_MODE, second.FORK_MODE) && Objects.equals(this.DIR_NAME, second.DIR_NAME) && Objects.equals(this.CATEGORY_NAME, second.CATEGORY_NAME) && Arrays.equals(this.UNIQUE_ID, second.UNIQUE_ID) && Objects.equals(this.TAGS, second.TAGS) && Objects.equals(this.REPEAT_MODE, second.REPEAT_MODE) && this.REPEAT_COUNT == second.REPEAT_COUNT;
        }

        public int hashCode() {
            return Comparing.hashcode((Object)this.TEST_OBJECT) ^ Comparing.hashcode((Object)this.getMainClassName()) ^ Comparing.hashcode((Object)this.getPackageName()) ^ Comparing.hashcode((Object)this.getMethodNameWithSignature()) ^ Comparing.hashcode((Object)this.getWorkingDirectory()) ^ Comparing.hashcode((Object)this.VM_PARAMETERS) ^ Comparing.hashcode((Object)this.PARAMETERS) ^ Comparing.hashcode(this.myPattern) ^ Comparing.hashcode((Object)this.FORK_MODE) ^ Comparing.hashcode((Object)this.DIR_NAME) ^ Comparing.hashcode((Object)this.CATEGORY_NAME) ^ Comparing.hashcode((Object)this.UNIQUE_ID) ^ Comparing.hashcode((Object)this.TAGS) ^ Comparing.hashcode((Object)this.REPEAT_MODE) ^ Comparing.hashcode((Object)this.REPEAT_COUNT);
        }

        public TestSearchScope getScope() {
            return this.TEST_SEARCH_SCOPE.getScope();
        }

        public void setScope(TestSearchScope scope) {
            this.TEST_SEARCH_SCOPE.setScope(scope);
        }

        public Data clone() {
            try {
                Data data = (Data)super.clone();
                data.TEST_SEARCH_SCOPE = new TestSearchScope.Wrapper();
                data.setScope(this.getScope());
                data.myEnvs = new LinkedHashMap<String, String>(this.myEnvs);
                return data;
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }

        public String getVMParameters() {
            return this.VM_PARAMETERS;
        }

        public void setVMParameters(String value) {
            this.VM_PARAMETERS = value;
        }

        public String getProgramParameters() {
            return this.PARAMETERS;
        }

        public void setProgramParameters(String value) {
            this.PARAMETERS = value;
        }

        public String getWorkingDirectory() {
            return ExternalizablePath.localPathValue((String)this.WORKING_DIRECTORY);
        }

        public void setWorkingDirectory(String value) {
            this.WORKING_DIRECTORY = StringUtil.isEmptyOrSpaces((String)value) ? "" : FileUtilRt.toSystemIndependentName((String)value.trim());
        }

        public void setUniqueIds(String ... uniqueId) {
            this.UNIQUE_ID = uniqueId;
        }

        public String[] getUniqueIds() {
            return this.UNIQUE_ID;
        }

        public Module setTestMethod(Location<? extends PsiMethod> methodLocation) {
            PsiMethod method = (PsiMethod)methodLocation.getPsiElement();
            this.METHOD_NAME = Data.getMethodPresentation(method);
            this.TEST_OBJECT = "method";
            return this.setMainClass(methodLocation instanceof MethodLocation ? ((MethodLocation)methodLocation).getContainingClass() : method.getContainingClass());
        }

        public String getTags() {
            return this.TAGS;
        }

        public void setTags(String tags) {
            this.TAGS = tags;
        }

        public static String getMethodPresentation(PsiMethod method) {
            if (!method.getParameterList().isEmpty() && MetaAnnotationUtil.isMetaAnnotated((PsiModifierListOwner)method, (Collection)JUnitUtil.TEST5_ANNOTATIONS)) {
                return method.getName() + "(" + ClassUtil.getVMParametersMethodSignature((PsiMethod)method) + ")";
            }
            return method.getName();
        }

        public String getGeneratedName(JavaRunConfigurationModule configurationModule) {
            if (JUnitConfiguration.TEST_PACKAGE.equals(this.TEST_OBJECT) || JUnitConfiguration.TEST_DIRECTORY.equals(this.TEST_OBJECT)) {
                String packageName;
                if (this.TEST_SEARCH_SCOPE.getScope() == TestSearchScope.WHOLE_PROJECT) {
                    return JUnitBundle.message("default.junit.config.name.whole.project", new Object[0]);
                }
                String moduleName = this.TEST_SEARCH_SCOPE.getScope() == TestSearchScope.WHOLE_PROJECT ? "" : configurationModule.getModuleName();
                String string = packageName = JUnitConfiguration.TEST_PACKAGE.equals(this.TEST_OBJECT) ? this.getPackageName() : StringUtil.getShortName((String)FileUtil.toSystemIndependentName((String)this.getDirName()), (char)'/');
                if (packageName.length() == 0) {
                    if (moduleName.length() > 0) {
                        return JUnitBundle.message("default.junit.config.name.all.in.module", moduleName);
                    }
                    return JUnitConfiguration.getDefaultPackageName();
                }
                if (moduleName.length() > 0) {
                    return JUnitBundle.message("default.junit.config.name.all.in.package.in.module", packageName, moduleName);
                }
                return packageName;
            }
            if ("pattern".equals(this.TEST_OBJECT)) {
                int size = this.myPattern.size();
                if (size == 0) {
                    return "Temp suite";
                }
                String fqName = (String)this.myPattern.iterator().next();
                String firstName = fqName.contains("*") ? fqName : StringUtil.getShortName((String)(fqName.contains("(") ? StringUtil.getPackageName((String)fqName, (char)'(') : fqName));
                return firstName + (size > 1 ? " and " + (size - 1) + " more" : "");
            }
            if (JUnitConfiguration.TEST_CATEGORY.equals(this.TEST_OBJECT)) {
                return "@Category(" + (StringUtil.isEmpty((String)this.CATEGORY_NAME) ? "Invalid" : this.CATEGORY_NAME) + ")";
            }
            if (JUnitConfiguration.TEST_UNIQUE_ID.equals(this.TEST_OBJECT)) {
                return this.UNIQUE_ID != null && this.UNIQUE_ID.length > 0 ? StringUtil.join((String[])this.UNIQUE_ID, (String)" ") : "Temp suite";
            }
            if (JUnitConfiguration.TEST_TAGS.equals(this.TEST_OBJECT)) {
                return this.TAGS != null && this.TAGS.length() > 0 ? "Tags (" + StringUtil.join((String[])new String[]{this.TAGS, " "}) + ")" : "Temp suite";
            }
            String className = JavaExecutionUtil.getPresentableClassName((String)this.getMainClassName());
            if ("method".equals(this.TEST_OBJECT)) {
                return className + '.' + this.getMethodName();
            }
            return className;
        }

        public String getMainClassName() {
            return this.MAIN_CLASS_NAME != null ? this.MAIN_CLASS_NAME : "";
        }

        public String getPackageName() {
            return this.PACKAGE_NAME != null ? this.PACKAGE_NAME : "";
        }

        public String getMethodName() {
            String signature = this.getMethodNameWithSignature();
            int paramsIdx = signature.lastIndexOf("(");
            return paramsIdx > -1 ? signature.substring(0, paramsIdx) : signature;
        }

        public String getMethodNameWithSignature() {
            return this.METHOD_NAME != null ? this.METHOD_NAME : "";
        }

        public String getDirName() {
            return this.DIR_NAME != null ? this.DIR_NAME : "";
        }

        public void setDirName(String dirName) {
            this.DIR_NAME = dirName;
        }

        public Set<String> getPatterns() {
            return this.myPattern;
        }

        public void setPatterns(LinkedHashSet<String> pattern) {
            this.myPattern = pattern;
        }

        public String getPatternPresentation() {
            return StringUtil.join(this.myPattern, (String)"||");
        }

        public TestObject getTestObject(@NotNull JUnitConfiguration configuration) {
            ExecutionEnvironment environment;
            TestObject testObject;
            if (configuration == null) {
                Data.$$$reportNull$$$0(0);
            }
            return (testObject = TestObject.fromString(this.TEST_OBJECT, configuration, environment = ExecutionEnvironmentBuilder.create((Executor)DefaultRunExecutor.getRunExecutorInstance(), (RunConfiguration)configuration).build())) == null ? new UnknownTestTarget(configuration, environment) : testObject;
        }

        public Module setMainClass(PsiClass testClass) {
            this.MAIN_CLASS_NAME = JavaExecutionUtil.getRuntimeQualifiedName((PsiClass)testClass);
            PsiPackage containingPackage = JUnitUtil.getContainingPackage((PsiClass)testClass);
            this.PACKAGE_NAME = containingPackage != null ? containingPackage.getQualifiedName() : "";
            return JavaExecutionUtil.findModule((PsiClass)testClass);
        }

        public Map<String, String> getEnvs() {
            return this.myEnvs;
        }

        public void setEnvs(Map<String, String> envs) {
            this.myEnvs = envs;
        }

        public String getCategory() {
            return this.CATEGORY_NAME != null ? this.CATEGORY_NAME : "";
        }

        public void setCategoryName(String categoryName) {
            this.CATEGORY_NAME = categoryName;
        }

        public String getChangeList() {
            return this.myChangeList;
        }

        public void setChangeList(String changeList) {
            this.myChangeList = changeList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/execution/junit/JUnitConfiguration$Data", "getTestObject"));
        }
    }
}

