/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations.coverage;

import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.JavaCoverageEngine;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.coverage.CoverageClassFilterEditor;
import com.intellij.execution.configurations.coverage.CoverageConfigurable;
import com.intellij.execution.configurations.coverage.CoverageEnabledConfiguration;
import com.intellij.execution.configurations.coverage.JavaCoverageEnabledConfiguration;
import com.intellij.execution.ui.NestedGroupFragment;
import com.intellij.execution.ui.SettingsEditorFragment;
import com.intellij.java.coverage.JavaCoverageBundle;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.classFilter.ClassFilter;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class CoverageFragment<T extends RunConfigurationBase<?>>
extends NestedGroupFragment<T> {
    private final RunConfigurationBase<?> myConfiguration;

    public CoverageFragment(RunConfigurationBase<?> configuration) {
        super("coverage", JavaCoverageBundle.message("coverage.settings", new Object[0]), JavaCoverageBundle.message("coverage.settings.group", new Object[0]), p -> false);
        this.myConfiguration = configuration;
    }

    public String getChildrenGroupName() {
        return JavaCoverageBundle.message("coverage.settings.menu", new Object[0]);
    }

    protected List<SettingsEditorFragment<T, ?>> createChildren() {
        ArrayList fragments = new ArrayList();
        fragments.add(this.createFilterEditor("coverage.include", JavaCoverageBundle.message("record.coverage.filters.title", new Object[0]), true, JavaCoverageBundle.message("coverage.settings.include", new Object[0])));
        fragments.add(this.createFilterEditor("coverage.exclude", JavaCoverageBundle.message("exclude.coverage.filters.title", new Object[0]), false, JavaCoverageBundle.message("coverage.settings.exclude", new Object[0])));
        JavaCoverageEnabledConfiguration configuration = this.getConfiguration();
        fragments.add(this.createRunnerFragment());
        fragments.add(SettingsEditorFragment.createTag((String)"coverage.tracing", (String)JavaCoverageBundle.message("coverage.settings.tracing", new Object[0]), null, t -> !configuration.isSampling(), (t, value) -> configuration.setSampling(value == false)));
        fragments.add(SettingsEditorFragment.createTag((String)"coverage.test.folders", (String)JavaCoverageBundle.message("coverage.settings.test.folders", new Object[0]), null, t -> configuration.isTrackTestFolders(), (t, value) -> configuration.setTrackTestFolders((boolean)value)));
        return fragments;
    }

    @NotNull
    private SettingsEditorFragment<T, CoverageClassFilterEditor> createFilterEditor(String id, @NotNull String message, boolean included, @NotNull String optionName) {
        if (message == null) {
            CoverageFragment.$$$reportNull$$$0(0);
        }
        if (optionName == null) {
            CoverageFragment.$$$reportNull$$$0(1);
        }
        JavaCoverageEnabledConfiguration configuration = this.getConfiguration();
        CoverageClassFilterEditor filterEditor = new CoverageClassFilterEditor(this.myConfiguration.getProject());
        filterEditor.setBorder((Border)IdeBorderFactory.createTitledBorder((String)message, (boolean)false, (Insets)JBUI.emptyInsets()));
        filterEditor.setupEasyFocusTraversing();
        return new SettingsEditorFragment(id, optionName, null, (JComponent)((Object)filterEditor), (p, editor) -> editor.setFilters(CoverageConfigurable.getCoveragePatterns(configuration, included)), (p, editor) -> CoverageFragment.setCoveragePatterns(configuration, this.isSelected() && filterEditor.isVisible() ? editor.getFilters() : ClassFilter.EMPTY_ARRAY, included), p -> false);
    }

    @NotNull
    private JavaCoverageEnabledConfiguration getConfiguration() {
        JavaCoverageEnabledConfiguration javaCoverageEnabledConfiguration = (JavaCoverageEnabledConfiguration)CoverageEnabledConfiguration.getOrCreate(this.myConfiguration);
        if (javaCoverageEnabledConfiguration == null) {
            CoverageFragment.$$$reportNull$$$0(2);
        }
        return javaCoverageEnabledConfiguration;
    }

    private static void setCoveragePatterns(JavaCoverageEnabledConfiguration configuration, ClassFilter[] filters, boolean included) {
        Object[] patterns = CoverageConfigurable.getCoveragePatterns(configuration, !included);
        configuration.setCoveragePatterns((ClassFilter[])ArrayUtil.mergeArrays((Object[])filters, (Object[])patterns));
    }

    private SettingsEditorFragment<T, ?> createRunnerFragment() {
        DefaultComboBoxModel<CoverageRunner> model = new DefaultComboBoxModel<CoverageRunner>();
        ComboBox comboBox = new ComboBox(model);
        JavaCoverageEnabledConfiguration configuration = this.getConfiguration();
        JavaCoverageEngine provider = JavaCoverageEngine.getInstance();
        for (CoverageRunner runner : CoverageRunner.EP_NAME.getExtensionList()) {
            if (!runner.acceptsCoverageEngine((CoverageEngine)provider)) continue;
            model.addElement(runner);
        }
        comboBox.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((String)"", CoverageRunner::getPresentableName));
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)comboBox, "West");
        LabeledComponent component = LabeledComponent.create((JComponent)panel, (String)JavaCoverageBundle.message("run.configuration.choose.coverage.runner", new Object[0]), (String)"West");
        return new SettingsEditorFragment("coverage.runner", JavaCoverageBundle.message("coverage.settings.runner", new Object[0]), null, (JComponent)component, (t, c) -> comboBox.setItem((Object)configuration.getCoverageRunner()), (t, c) -> configuration.setCoverageRunner(this.isSelected() && component.isVisible() ? (CoverageRunner)comboBox.getItem() : (CoverageRunner)model.getElementAt(0)), t -> false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "optionName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/configurations/coverage/CoverageFragment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/configurations/coverage/CoverageFragment";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createFilterEditor";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

