/*
 * Decompiled with CFR 0.152.
 */
package com.github.markusbernhardt.proxy.selector.pac;

import com.github.markusbernhardt.proxy.selector.pac.PacScriptMethods;
import com.github.markusbernhardt.proxy.selector.pac.PacScriptParser;
import com.github.markusbernhardt.proxy.selector.pac.PacScriptSource;
import com.github.markusbernhardt.proxy.selector.pac.ProxyEvaluationException;
import com.github.markusbernhardt.proxy.selector.pac.ScriptMethods;
import com.github.markusbernhardt.proxy.util.Logger;
import delight.rhinosandox.RhinoSandbox;
import delight.rhinosandox.RhinoSandboxes;
import java.lang.reflect.Method;

public class JavaxPacScriptParser
implements PacScriptParser {
    static final String SCRIPT_METHODS_OBJECT = "__pacutil";
    static final String SOURCE_NAME = JavaxPacScriptParser.class.getName();
    private final PacScriptSource source;
    private final RhinoSandbox engine;

    public JavaxPacScriptParser(PacScriptSource source) throws ProxyEvaluationException {
        this.source = source;
        this.engine = this.setupEngine();
    }

    private RhinoSandbox setupEngine() throws ProxyEvaluationException {
        Method[] scriptMethods;
        RhinoSandbox engine = RhinoSandboxes.create();
        engine.inject(SCRIPT_METHODS_OBJECT, (Object)new PacScriptMethods());
        engine.allow(String.class);
        Class<ScriptMethods> scriptMethodsClazz = ScriptMethods.class;
        for (Method method : scriptMethods = scriptMethodsClazz.getMethods()) {
            String name = method.getName();
            int args = method.getParameterTypes().length;
            StringBuilder toEval = new StringBuilder(name).append(" = function(");
            for (int i = 0; i < args; ++i) {
                if (i > 0) {
                    toEval.append(",");
                }
                toEval.append("arg").append(i);
            }
            toEval.append(") {return ");
            String functionCall = this.buildFunctionCallCode(name, args);
            if (String.class.isAssignableFrom(method.getReturnType())) {
                functionCall = "String(" + functionCall + ")";
            }
            toEval.append(functionCall).append("; }");
            try {
                engine.evalWithGlobalScope(SOURCE_NAME, toEval.toString());
            }
            catch (Exception e) {
                Logger.log(this.getClass(), Logger.LogLevel.ERROR, "JS evaluation error when creating alias for " + name + ".", e);
                throw new ProxyEvaluationException("Error setting up script engine", e);
            }
        }
        return engine;
    }

    private String buildFunctionCallCode(String functionName, int args) {
        StringBuilder functionCall = new StringBuilder();
        functionCall.append(SCRIPT_METHODS_OBJECT).append(".").append(functionName).append("(");
        for (int i = 0; i < args; ++i) {
            if (i > 0) {
                functionCall.append(",");
            }
            functionCall.append("arg").append(i);
        }
        functionCall.append(")");
        return functionCall.toString();
    }

    @Override
    public PacScriptSource getScriptSource() {
        return this.source;
    }

    @Override
    public String evaluate(String url, String host) throws ProxyEvaluationException {
        try {
            StringBuilder script = new StringBuilder(this.source.getScriptContent());
            String evalMethod = " ;FindProxyForURL (\"" + url + "\",\"" + host + "\")";
            script.append(evalMethod);
            Object result = this.engine.eval(SOURCE_NAME, script.toString());
            return (String)result;
        }
        catch (Exception e) {
            Logger.log(this.getClass(), Logger.LogLevel.ERROR, "JS evaluation error.", e);
            throw new ProxyEvaluationException("Error while executing PAC script: " + e.getMessage(), e);
        }
    }
}

