/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.bugzilla;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tasks.Comment;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.TaskState;
import com.intellij.tasks.TaskType;
import com.intellij.tasks.bugzilla.BugzillaRepository;
import icons.TasksCoreIcons;
import java.util.Date;
import java.util.Hashtable;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BugzillaTask
extends Task {
    private final Hashtable<String, Object> myResponse;
    private final BugzillaRepository myRepository;

    public BugzillaTask(@NotNull Hashtable<String, Object> xmlRpcResponse, @NotNull BugzillaRepository repository) {
        if (xmlRpcResponse == null) {
            BugzillaTask.$$$reportNull$$$0(0);
        }
        if (repository == null) {
            BugzillaTask.$$$reportNull$$$0(1);
        }
        this.myResponse = xmlRpcResponse;
        this.myRepository = repository;
    }

    @NotNull
    public String getId() {
        String string = String.valueOf(this.myResponse.get("id"));
        if (string == null) {
            BugzillaTask.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getSummary() {
        String string = (String)this.myResponse.get("summary");
        if (string == null) {
            BugzillaTask.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    public String getDescription() {
        return null;
    }

    public Comment @NotNull [] getComments() {
        if (Comment.EMPTY_ARRAY == null) {
            BugzillaTask.$$$reportNull$$$0(4);
        }
        return Comment.EMPTY_ARRAY;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = TasksCoreIcons.Bugzilla;
        if (icon == null) {
            BugzillaTask.$$$reportNull$$$0(5);
        }
        return icon;
    }

    @NotNull
    public TaskType getType() {
        String severity = (String)this.myResponse.get("severity");
        TaskType taskType = severity.equalsIgnoreCase("enhancement") ? TaskType.FEATURE : TaskType.BUG;
        if (taskType == null) {
            BugzillaTask.$$$reportNull$$$0(6);
        }
        return taskType;
    }

    @Nullable
    public TaskState getState() {
        String status = (String)this.myResponse.get("status");
        if (status.equals("IN_PROGRESS")) {
            return TaskState.IN_PROGRESS;
        }
        if (status.equals("CONFIRMED")) {
            return TaskState.OPEN;
        }
        if (status.equals("UNCONFIRMED")) {
            return TaskState.SUBMITTED;
        }
        if (status.equals("RESOLVED")) {
            return TaskState.RESOLVED;
        }
        return TaskState.OTHER;
    }

    @Nullable
    public Date getUpdated() {
        return (Date)this.myResponse.get("last_change_time");
    }

    @Nullable
    public Date getCreated() {
        return (Date)this.myResponse.get("creation_time");
    }

    public boolean isClosed() {
        return (Boolean)this.myResponse.get("is_open") == false;
    }

    public boolean isIssue() {
        return true;
    }

    @Nullable
    public String getIssueUrl() {
        String repositoryUrl = this.myRepository.getUrl();
        repositoryUrl = StringUtil.trimEnd((String)repositoryUrl, (String)"xmlrpc.cgi");
        return repositoryUrl + "/show_bug.cgi?id=" + this.getId();
    }

    @Nullable
    public TaskRepository getRepository() {
        return this.myRepository;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlRpcResponse";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/tasks/bugzilla/BugzillaTask";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/tasks/bugzilla/BugzillaTask";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSummary";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getComments";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

