/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.xsltDebugger.rt.engine.remote;

import com.icl.saxon.TransformerFactoryImpl;
import java.io.File;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.List;
import javax.rmi.PortableRemoteObject;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.intellij.plugins.xsltDebugger.rt.engine.Debugger;
import org.intellij.plugins.xsltDebugger.rt.engine.Value;
import org.intellij.plugins.xsltDebugger.rt.engine.local.LocalDebugger;
import org.intellij.plugins.xsltDebugger.rt.engine.remote.RemoteBreakpointManager;
import org.intellij.plugins.xsltDebugger.rt.engine.remote.RemoteBreakpointManagerImpl;
import org.intellij.plugins.xsltDebugger.rt.engine.remote.RemoteDebugger;
import org.intellij.plugins.xsltDebugger.rt.engine.remote.RemoteEventQueueImpl;
import org.intellij.plugins.xsltDebugger.rt.engine.remote.RemoteFrameImpl;
import org.intellij.plugins.xsltDebugger.rt.engine.remote.RemoteVariableImpl;

public final class DebuggerServer
extends PortableRemoteObject
implements RemoteDebugger {
    private static final String XSLT_DEBUGGER = "XsltDebugger";
    private static final int PORT = 34275;
    private final Debugger myDebugger;
    private final RemoteBreakpointManagerImpl myBreakpointManager;
    private final RemoteEventQueueImpl myEventQueue;
    private final int myPort;
    private final String myAccessToken;

    private DebuggerServer(Transformer transformer, Source xml, Result out, int port) throws RemoteException {
        this.myPort = port;
        this.myAccessToken = System.getProperty("xslt.debugger.token");
        this.myDebugger = new LocalDebugger(transformer, xml, out){

            @Override
            public void stop(boolean b) {
                try {
                    super.stop(b);
                }
                finally {
                    if (b) {
                        System.exit(0);
                    }
                }
            }
        };
        this.myBreakpointManager = new RemoteBreakpointManagerImpl(this.myDebugger.getBreakpointManager());
        this.myEventQueue = new RemoteEventQueueImpl(this.myDebugger.getEventQueue());
    }

    public static DebuggerServer create(Transformer xsl, Source xml, Result out, int port) throws RemoteException {
        DebuggerServer server = new DebuggerServer(xsl, xml, out, port);
        Registry registry = LocateRegistry.createRegistry(port);
        registry.rebind(XSLT_DEBUGGER, (Remote)((Object)server));
        return server;
    }

    public static DebuggerServer create(File f, File x) throws TransformerConfigurationException, RemoteException {
        return DebuggerServer.create(new TransformerFactoryImpl().newTransformer((Source)new StreamSource(f)), new StreamSource(x), new StreamResult(), 34275);
    }

    public void stop(boolean force) throws RemoteException {
        this.myDebugger.stop(force);
        try {
            LocateRegistry.getRegistry(this.myPort).unbind(XSLT_DEBUGGER);
        }
        catch (NotBoundException notBoundException) {
            // empty catch block
        }
    }

    public boolean ping() {
        return this.myDebugger.ping();
    }

    public Debugger.State waitForStateChange(Debugger.State state) {
        return this.myDebugger.waitForStateChange(state);
    }

    public boolean waitForDebuggee() {
        return this.myDebugger.waitForDebuggee();
    }

    public boolean start() {
        return this.myDebugger.start();
    }

    public void step() {
        this.myDebugger.step();
    }

    public void stepInto() {
        this.myDebugger.stepInto();
    }

    public void resume() {
        this.myDebugger.resume();
    }

    public boolean isStopped() {
        return this.myDebugger.isStopped();
    }

    public RemoteDebugger.Frame getCurrentFrame() throws RemoteException {
        return RemoteFrameImpl.create((Debugger.Frame)this.myDebugger.getCurrentFrame(), (String)this.myAccessToken);
    }

    public RemoteDebugger.Frame getSourceFrame() throws RemoteException {
        return RemoteFrameImpl.create((Debugger.Frame)this.myDebugger.getSourceFrame(), (String)this.myAccessToken);
    }

    public Value eval(String expr, String accessToken) throws RemoteException, Debugger.EvaluationException {
        return this.getCurrentFrame().eval(expr, accessToken);
    }

    public List<RemoteDebugger.Variable> getGlobalVariables() throws RemoteException {
        return RemoteVariableImpl.convert((List)this.myDebugger.getGlobalVariables());
    }

    public RemoteBreakpointManager getBreakpointManager() {
        return this.myBreakpointManager;
    }

    public Debugger.State getState() {
        return this.myDebugger.getState();
    }

    public void pause() {
        this.myDebugger.pause();
    }

    public RemoteDebugger.EventQueue getEventQueue() {
        return this.myEventQueue;
    }
}

