/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.eclipse.config;

import com.intellij.configurationStore.SaveSession;
import com.intellij.configurationStore.SaveSessionProducer;
import com.intellij.configurationStore.StorageManagerFileWriteRequestor;
import com.intellij.configurationStore.StorageUtilKt;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.vfs.SafeWriteRequestor;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ThrowableRunnable;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jdom.output.EclipseJDOMUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.eclipse.config.CachedXmlDocumentSet;
import org.jetbrains.idea.eclipse.config.EclipseClasspathStorageProvider;
import org.jetbrains.idea.eclipse.conversion.DotProjectFileHelper;
import org.jetbrains.idea.eclipse.conversion.EclipseClasspathWriter;
import org.jetbrains.idea.eclipse.conversion.IdeaSpecificSettings;

final class ClasspathSaveSession
implements SaveSessionProducer,
SaveSession,
SafeWriteRequestor {
    private final Map<String, Element> modifiedContent;
    private final Set<String> deletedContent;
    private final Module module;

    ClasspathSaveSession(@NotNull Module module) {
        if (module == null) {
            ClasspathSaveSession.$$$reportNull$$$0(0);
        }
        this.modifiedContent = new THashMap();
        this.deletedContent = new THashSet();
        this.module = module;
    }

    private void update(@NotNull Element content, @NotNull String name) {
        if (content == null) {
            ClasspathSaveSession.$$$reportNull$$$0(1);
        }
        if (name == null) {
            ClasspathSaveSession.$$$reportNull$$$0(2);
        }
        this.modifiedContent.put(name, content);
        this.deletedContent.remove(name);
    }

    void delete(@NotNull String name) {
        if (name == null) {
            ClasspathSaveSession.$$$reportNull$$$0(3);
        }
        this.modifiedContent.remove(name);
        this.deletedContent.add(name);
    }

    public void setState(Object component, @NotNull String componentName, @Nullable Object state) throws IOException {
        Element oldClassPath;
        if (componentName == null) {
            ClasspathSaveSession.$$$reportNull$$$0(4);
        }
        CachedXmlDocumentSet fileSet = EclipseClasspathStorageProvider.getFileCache(this.module);
        try {
            oldClassPath = fileSet.load(".classpath", true);
        }
        catch (Exception e) {
            EclipseClasspathWriter.LOG.warn((Throwable)e);
            oldClassPath = null;
        }
        ModuleRootManager moduleRootManager = (ModuleRootManager)component;
        if (oldClassPath != null || moduleRootManager.getSourceRoots().length > 0 || moduleRootManager.getOrderEntries().length > 2) {
            Element newClassPathElement = new EclipseClasspathWriter().writeClasspath(oldClassPath, (ModuleRootModel)moduleRootManager);
            if (oldClassPath == null || !JDOMUtil.areElementsEqual((Element)newClassPathElement, (Element)oldClassPath)) {
                this.update(newClassPathElement, ".classpath");
            }
        }
        if (fileSet.getFile(".project", true) == null) {
            DotProjectFileHelper.saveDotProjectFile(this.module, fileSet.getParent(".project"));
        }
        Element ideaSpecific = new Element("component");
        String emlFilename = moduleRootManager.getModule().getName() + ".eml";
        if (IdeaSpecificSettings.writeIdeaSpecificClasspath(ideaSpecific, (ModuleRootModel)moduleRootManager)) {
            this.update(ideaSpecific, emlFilename);
        } else {
            this.delete(emlFilename);
        }
    }

    @Nullable
    public SaveSession createSaveSession() {
        return this.modifiedContent.isEmpty() && this.deletedContent.isEmpty() ? null : this;
    }

    public void save() throws IOException {
        CachedXmlDocumentSet fileSet = EclipseClasspathStorageProvider.getFileCache(this.module);
        ThrowableRunnable runnable = () -> {
            for (String key : this.modifiedContent.keySet()) {
                Element content = this.modifiedContent.get(key);
                VirtualFile virtualFile = StorageUtilKt.getOrCreateVirtualFile((Path)Paths.get(fileSet.getParent(key) + '/' + key, new String[0]), (StorageManagerFileWriteRequestor)this);
                try (OutputStreamWriter writer = new OutputStreamWriter(virtualFile.getOutputStream((Object)this), StandardCharsets.UTF_8);){
                    EclipseJDOMUtil.output(content, writer, this.module.getProject());
                }
            }
            if (this.deletedContent.isEmpty()) {
                return;
            }
            for (String deleted : this.deletedContent) {
                VirtualFile file = fileSet.getFile(deleted, false);
                if (file == null) continue;
                try {
                    file.delete((Object)this);
                }
                catch (IOException iOException) {}
            }
            this.deletedContent.clear();
        };
        Application app = ApplicationManager.getApplication();
        if (app.isWriteAccessAllowed()) {
            runnable.run();
        } else {
            WriteAction.run((ThrowableRunnable)runnable);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentName";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/eclipse/config/ClasspathSaveSession";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "delete";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "setState";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

