/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.eclipse.importer;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.SchemeImportException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.eclipse.importer.EclipseCodeStylePropertiesImporter;

public class EclipseProjectCodeStyleData
extends EclipseCodeStylePropertiesImporter {
    private static final Logger LOG = Logger.getInstance(EclipseProjectCodeStyleData.class);
    public static final String CORE_PREFS_FILE_NAME = "org.eclipse.jdt.core.prefs";
    public static final String UI_PREFS_FILE_NAME = "org.eclipse.jdt.ui.prefs";
    public static final String ECLIPSE_SETTINGS_SUBDIR = ".settings";
    private boolean myImportOrganizeImportsConfig;
    private static final Map<String, String> PREDEFINED_ECLIPSE_PROFILES = new HashMap<String, String>();
    @NotNull
    private final String myProjectPath;
    @Nullable
    private Properties myCorePreferences;
    @Nullable
    private Properties myUiPreferences;
    private final String myProjectName;

    public EclipseProjectCodeStyleData(@NotNull String projectName, @NotNull String projectPath) {
        if (projectName == null) {
            EclipseProjectCodeStyleData.$$$reportNull$$$0(0);
        }
        if (projectPath == null) {
            EclipseProjectCodeStyleData.$$$reportNull$$$0(1);
        }
        this.myProjectName = projectName;
        this.myProjectPath = projectPath;
    }

    public boolean loadEclipsePreferences() {
        try {
            this.myCorePreferences = this.loadProperties(CORE_PREFS_FILE_NAME);
            this.myUiPreferences = this.loadProperties(UI_PREFS_FILE_NAME);
            this.myImportOrganizeImportsConfig = this.isEclipseImportsConfigAvailable();
            return this.myCorePreferences != null && EclipseProjectCodeStyleData.formatterOptionsExist(this.myCorePreferences) && this.myUiPreferences != null;
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            return false;
        }
    }

    private Properties loadProperties(@NotNull String fileName) throws IOException {
        File prefsFile;
        if (fileName == null) {
            EclipseProjectCodeStyleData.$$$reportNull$$$0(2);
        }
        if ((prefsFile = this.getPreferencesFile(fileName)) != null) {
            Properties properties = new Properties();
            try (FileInputStream input = new FileInputStream(prefsFile);){
                properties.load(input);
            }
            return properties;
        }
        return null;
    }

    private static boolean formatterOptionsExist(@NotNull Properties eclipseProperties) {
        if (eclipseProperties == null) {
            EclipseProjectCodeStyleData.$$$reportNull$$$0(3);
        }
        for (String propertyKey : eclipseProperties.stringPropertyNames()) {
            if (!propertyKey.startsWith("org.eclipse.jdt.core.formatter")) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private File getPreferencesFile(@NotNull String fileName) {
        String filePath;
        File prefsFile;
        if (fileName == null) {
            EclipseProjectCodeStyleData.$$$reportNull$$$0(4);
        }
        return (prefsFile = new File(filePath = this.myProjectPath + File.separator + ECLIPSE_SETTINGS_SUBDIR + File.separator + fileName)).exists() ? prefsFile : null;
    }

    public String getProjectName() {
        return this.myProjectName;
    }

    public String toString() {
        String profileName = this.getFormatterProfileName();
        return this.myProjectName + (profileName != null ? ": " + profileName : "");
    }

    @Nullable
    private String getFormatterProfileName() {
        String rawName;
        String string = rawName = this.myUiPreferences != null ? this.myUiPreferences.getProperty("formatter_profile") : null;
        if (rawName != null) {
            if (PREDEFINED_ECLIPSE_PROFILES.containsKey(rawName)) {
                return PREDEFINED_ECLIPSE_PROFILES.get(rawName);
            }
            rawName = StringUtil.trimStart((String)rawName, (String)"_");
        }
        return rawName;
    }

    @Nullable
    public CodeStyleSettings importCodeStyle() throws SchemeImportException {
        if (this.myCorePreferences != null) {
            CodeStyleSettings settings = CodeStyleSettingsManager.getInstance().createSettings();
            this.importProperties(this.myCorePreferences, settings);
            if (this.myUiPreferences != null && this.myImportOrganizeImportsConfig) {
                this.importOptimizeImportsSettings(this.myUiPreferences, settings);
            }
            return settings;
        }
        return null;
    }

    public boolean isEclipseImportsConfigAvailable() {
        return this.myUiPreferences != null && this.myUiPreferences.getProperty("org.eclipse.jdt.ui.importorder") != null;
    }

    public boolean isImportOrganizeImportsConfig() {
        return this.isEclipseImportsConfigAvailable() && this.myImportOrganizeImportsConfig;
    }

    public void setImportOrganizeImportsConfig(boolean importOrganizeImportsConfig) {
        this.myImportOrganizeImportsConfig = importOrganizeImportsConfig;
    }

    static {
        PREDEFINED_ECLIPSE_PROFILES.put("org.eclipse.jdt.ui.default.eclipse_profile", "Eclipse [built-in]");
        PREDEFINED_ECLIPSE_PROFILES.put("org.eclipse.jdt.ui.default.sun_profile", "Java Conventions [built-in]");
        PREDEFINED_ECLIPSE_PROFILES.put("org.eclipse.jdt.ui.default_profile", "Eclipse 2.1 [built-in]");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eclipseProperties";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/eclipse/importer/EclipseProjectCodeStyleData";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "loadProperties";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "formatterOptionsExist";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getPreferencesFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

