/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.serviceContainer;

import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.serviceContainer.ComponentManagerImpl;
import com.intellij.serviceContainer.ComponentManagerImplKt;
import com.intellij.serviceContainer.ConstructorInjectionKt;
import com.intellij.serviceContainer.ConstructorParameterResolver;
import com.intellij.serviceContainer.NonInjectable;
import com.intellij.util.messages.MessageBus;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\u001am\u0010\u0003\u001a\u001c\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0002\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u00050\u00042\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u00062\u0010\u0010\b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a2\u0006\u0002\u0010\u0013\u001a#\u0010\u0014\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u00052\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0002\u00a2\u0006\u0002\u0010\u0016\u001a?\u0010\u0017\u001a\u0002H\u0018\"\u0004\b\u0000\u0010\u00182\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\u0010\u0019\u001a\u0014\u0010\u001a\u001a\u00020\u00122\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0000\"\u0018\u0010\u0000\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"constructorComparator", "Ljava/util/Comparator;", "Ljava/lang/reflect/Constructor;", "getGreediestSatisfiableConstructor", "Lkotlin/Pair;", "", "Ljava/lang/Class;", "aClass", "sortedMatchingConstructors", "requestorKey", "", "pluginId", "Lcom/intellij/openapi/extensions/PluginId;", "componentManager", "Lcom/intellij/serviceContainer/ComponentManagerImpl;", "parameterResolver", "Lcom/intellij/serviceContainer/ConstructorParameterResolver;", "isExtensionSupported", "", "(Ljava/lang/Class;[Ljava/lang/reflect/Constructor;Ljava/lang/Object;Lcom/intellij/openapi/extensions/PluginId;Lcom/intellij/serviceContainer/ComponentManagerImpl;Lcom/intellij/serviceContainer/ConstructorParameterResolver;Z)Lkotlin/Pair;", "getSortedMatchingConstructors", "componentImplementation", "(Ljava/lang/Class;)[Ljava/lang/reflect/Constructor;", "instantiateUsingPicoContainer", "T", "(Ljava/lang/Class;Ljava/lang/Object;Lcom/intellij/openapi/extensions/PluginId;Lcom/intellij/serviceContainer/ComponentManagerImpl;Lcom/intellij/serviceContainer/ConstructorParameterResolver;)Ljava/lang/Object;", "isNotApplicableClass", "type", "intellij.platform.serviceContainer"})
public final class ConstructorInjectionKt {
    private static final Comparator<Constructor<?>> constructorComparator = constructorComparator.1.INSTANCE;

    /*
     * WARNING - void declaration
     */
    public static final <T> T instantiateUsingPicoContainer(@NotNull Class<?> aClass, @NotNull Object requestorKey, @NotNull PluginId pluginId, @NotNull ComponentManagerImpl componentManager, @NotNull ConstructorParameterResolver parameterResolver) {
        Class<?>[] result;
        Intrinsics.checkParameterIsNotNull(aClass, (String)"aClass");
        Intrinsics.checkParameterIsNotNull((Object)requestorKey, (String)"requestorKey");
        Intrinsics.checkParameterIsNotNull((Object)pluginId, (String)"pluginId");
        Intrinsics.checkParameterIsNotNull((Object)((Object)componentManager), (String)"componentManager");
        Intrinsics.checkParameterIsNotNull((Object)parameterResolver, (String)"parameterResolver");
        Object[] sortedMatchingConstructors = ConstructorInjectionKt.getSortedMatchingConstructors(aClass);
        Class<?>[] parameterTypes = null;
        Constructor constructor = null;
        if (sortedMatchingConstructors.length == 1) {
            constructor = (Constructor)ArraysKt.first((Object[])sortedMatchingConstructors);
            Class<?>[] classArray = constructor.getParameterTypes();
            Intrinsics.checkExpressionValueIsNotNull(classArray, (String)"constructor.parameterTypes");
            parameterTypes = classArray;
        } else {
            result = ConstructorInjectionKt.getGreediestSatisfiableConstructor(aClass, sortedMatchingConstructors, requestorKey, pluginId, componentManager, parameterResolver, false);
            constructor = (Constructor)result.getFirst();
            parameterTypes = (Class[])result.getSecond();
        }
        try {
            Object[] objectArray;
            constructor.setAccessible(true);
            result = parameterTypes;
            int n = 0;
            if (result.length == 0) {
                return constructor.newInstance(new Object[0]);
            }
            boolean isErrorLogged = false;
            n = parameterTypes.length;
            Constructor constructor2 = constructor;
            Object[] objectArray2 = new Object[n];
            for (int i = 0; i < n; ++i) {
                Object object;
                void it;
                int n2 = i;
                int n3 = i;
                objectArray = objectArray2;
                boolean bl = false;
                Class<?> parameterType = parameterTypes[it];
                if (!isErrorLogged && !ComponentManager.class.isAssignableFrom(parameterType) && Intrinsics.areEqual(parameterType, MessageBus.class) ^ true) {
                    isErrorLogged = true;
                    if (Intrinsics.areEqual((Object)pluginId.getIdString(), (Object)"org.jetbrains.kotlin") ^ true) {
                        ComponentManagerImplKt.getLOG().warn("Do not use constructor injection (requestorClass=" + aClass.getName() + ')');
                    }
                }
                objectArray[n3] = object = parameterResolver.resolveInstance(componentManager, requestorKey, aClass, constructor, parameterType, pluginId);
            }
            objectArray = objectArray2;
            return constructor2.newInstance(objectArray);
        }
        catch (InvocationTargetException e) {
            Throwable throwable = e.getCause();
            if (throwable == null) {
                throwable = e;
            }
            throw throwable;
        }
        catch (InstantiationException e) {
            throw (Throwable)new RuntimeException("Cannot create class " + aClass, e);
        }
    }

    public static final boolean isNotApplicableClass(@NotNull Class<?> type) {
        Intrinsics.checkParameterIsNotNull(type, (String)"type");
        return type.isPrimitive() || type.isEnum() || type.isArray() || Collection.class.isAssignableFrom(type) || Map.class.isAssignableFrom(type) || type == String.class || type == File.class || type == Path.class;
    }

    /*
     * WARNING - void declaration
     */
    private static final Pair<Constructor<?>, Class<?>[]> getGreediestSatisfiableConstructor(Class<?> aClass, Constructor<?>[] sortedMatchingConstructors, Object requestorKey, PluginId pluginId, ComponentManagerImpl componentManager, ConstructorParameterResolver parameterResolver, boolean isExtensionSupported) {
        Set conflicts = null;
        Set unsatisfiableDependencyTypes = null;
        Constructor<?> greediestConstructor = null;
        Class[] greediestConstructorParameterTypes = null;
        int lastSatisfiableConstructorSize = -1;
        Class<?> unsatisfiedDependencyType = null;
        int lastIndex = sortedMatchingConstructors.length - 1;
        boolean someConstructorWasChecked = false;
        int n = 0;
        int n2 = lastIndex;
        if (n <= n2) {
            while (true) {
                void index;
                Constructor<?> constructor;
                if (!(constructor = sortedMatchingConstructors[index]).isSynthetic()) {
                    boolean bl;
                    int n3;
                    Class<?>[] classArray;
                    Class<?>[] parameterTypes;
                    boolean failedDependency;
                    block23: {
                        failedDependency = false;
                        parameterTypes = constructor.getParameterTypes();
                        Intrinsics.checkExpressionValueIsNotNull(parameterTypes, (String)"parameterTypes");
                        Class<?>[] $this$any$iv = parameterTypes;
                        boolean $i$f$any = false;
                        classArray = $this$any$iv;
                        n3 = classArray.length;
                        for (int i = 0; i < n3; ++i) {
                            Class<?> element$iv;
                            Class<?> p1 = element$iv = classArray[i];
                            boolean bl2 = false;
                            if (!ConstructorInjectionKt.isNotApplicableClass(p1)) continue;
                            bl = true;
                            break block23;
                        }
                        bl = false;
                    }
                    if (!bl) {
                        if (!someConstructorWasChecked && index == lastIndex) {
                            return new Pair(constructor, parameterTypes);
                        }
                        if (lastIndex <= 0 || !constructor.isAnnotationPresent(NonInjectable.class) && !constructor.isAnnotationPresent(Deprecated.class)) {
                            Collection collection;
                            int n4;
                            someConstructorWasChecked = true;
                            classArray = parameterTypes;
                            n3 = classArray.length;
                            for (n4 = 0; n4 < n3; ++n4) {
                                Class<?> expectedType;
                                Class<?> clazz = expectedType = classArray[n4];
                                Intrinsics.checkExpressionValueIsNotNull(clazz, (String)"expectedType");
                                if (parameterResolver.isResolvable(componentManager, requestorKey, aClass, constructor, clazz, pluginId, isExtensionSupported)) continue;
                                if (unsatisfiableDependencyTypes == null) {
                                    unsatisfiableDependencyTypes = new HashSet();
                                }
                                unsatisfiableDependencyTypes.add(parameterTypes);
                                unsatisfiedDependencyType = expectedType;
                                failedDependency = true;
                                break;
                            }
                            if (greediestConstructor != null && parameterTypes.length != lastSatisfiableConstructorSize) {
                                collection = conflicts;
                                n4 = 0;
                                boolean bl3 = false;
                                if (collection == null || collection.isEmpty()) {
                                    if (greediestConstructorParameterTypes == null) {
                                        Intrinsics.throwNpe();
                                    }
                                    return new Pair(greediestConstructor, (Object)greediestConstructorParameterTypes);
                                }
                                conflicts.add(constructor);
                            } else if (!failedDependency && lastSatisfiableConstructorSize == parameterTypes.length) {
                                if (conflicts == null) {
                                    conflicts = new HashSet();
                                }
                                conflicts.add(constructor);
                                if (greediestConstructor != null) {
                                    n4 = 0;
                                    boolean bl4 = false;
                                    Collection it = collection;
                                    boolean bl5 = false;
                                    conflicts.add(it);
                                }
                            } else if (!failedDependency) {
                                greediestConstructor = constructor;
                                greediestConstructorParameterTypes = parameterTypes;
                                lastSatisfiableConstructorSize = parameterTypes.length;
                            }
                        }
                    }
                }
                if (index == n2) break;
                ++index;
            }
        }
        Collection collection = conflicts;
        n2 = 0;
        boolean bl = false;
        if (!(collection == null || collection.isEmpty())) {
            throw (Throwable)new PluginException("Too many satisfiable constructors: " + ArraysKt.joinToString$default((Object[])sortedMatchingConstructors, null, null, null, (int)0, null, (Function1)getGreediestSatisfiableConstructor.3.INSTANCE, (int)31, null), pluginId);
        }
        if (greediestConstructor != null) {
            if (greediestConstructorParameterTypes == null) {
                Intrinsics.throwNpe();
            }
            return new Pair((Object)greediestConstructor, (Object)greediestConstructorParameterTypes);
        }
        collection = unsatisfiableDependencyTypes;
        n2 = 0;
        bl = false;
        if (!(collection == null || collection.isEmpty())) {
            if (isExtensionSupported) {
                throw (Throwable)new PluginException(aClass.getName() + " has unsatisfied dependency: " + unsatisfiedDependencyType + " among unsatisfiable dependencies: " + unsatisfiableDependencyTypes + " where " + (Object)((Object)componentManager) + " was the leaf container being asked for dependencies.", pluginId);
            }
            return ConstructorInjectionKt.getGreediestSatisfiableConstructor(aClass, sortedMatchingConstructors, requestorKey, pluginId, componentManager, parameterResolver, true);
        }
        StringBuilder stringBuilder = new StringBuilder().append("The specified parameters not match any of the following constructors: ");
        Object[] objectArray = aClass.getDeclaredConstructors();
        Intrinsics.checkExpressionValueIsNotNull(objectArray, (String)"aClass.declaredConstructors");
        throw (Throwable)new PluginException(stringBuilder.append(ArraysKt.joinToString$default((Object[])objectArray, (CharSequence)"\n", null, null, (int)0, null, (Function1)getGreediestSatisfiableConstructor.4.INSTANCE, (int)30, null)).append('\n').append("for ").append(aClass).toString(), pluginId);
    }

    private static final Constructor<?>[] getSortedMatchingConstructors(Class<?> componentImplementation) {
        Object[] declaredConstructors = componentImplementation.getDeclaredConstructors();
        Intrinsics.checkExpressionValueIsNotNull(declaredConstructors, (String)"declaredConstructors");
        ArraysKt.sortWith((Object[])declaredConstructors, constructorComparator);
        return declaredConstructors;
    }
}

