/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.gradle.model.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.BuildTargetLoader;
import org.jetbrains.jps.builders.ModuleBasedBuildTargetType;
import org.jetbrains.jps.gradle.model.JpsGradleExtensionService;
import org.jetbrains.jps.gradle.model.impl.GradleResourcesTarget;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.module.JpsModule;

public class GradleResourcesTargetType
extends ModuleBasedBuildTargetType<GradleResourcesTarget> {
    public static final GradleResourcesTargetType PRODUCTION = new GradleResourcesTargetType("gradle-resources-production", false);
    public static final GradleResourcesTargetType TEST = new GradleResourcesTargetType("gradle-resources-test", true);
    private final boolean myIsTests;

    private GradleResourcesTargetType(String typeId, boolean isTests) {
        super(typeId, true);
        this.myIsTests = isTests;
    }

    public boolean isTests() {
        return this.myIsTests;
    }

    @NotNull
    public List<GradleResourcesTarget> computeAllTargets(@NotNull JpsModel model) {
        if (model == null) {
            GradleResourcesTargetType.$$$reportNull$$$0(0);
        }
        ArrayList<GradleResourcesTarget> targets = new ArrayList<GradleResourcesTarget>();
        for (JpsModule module : model.getProject().getModules()) {
            if (JpsGradleExtensionService.getInstance().getExtension(module) == null) continue;
            targets.add(new GradleResourcesTarget(this, module));
        }
        ArrayList<GradleResourcesTarget> arrayList = targets;
        if (arrayList == null) {
            GradleResourcesTargetType.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @NotNull
    public BuildTargetLoader<GradleResourcesTarget> createLoader(@NotNull JpsModel model) {
        if (model == null) {
            GradleResourcesTargetType.$$$reportNull$$$0(2);
        }
        final HashMap<String, JpsModule> modules = new HashMap<String, JpsModule>();
        for (JpsModule module : model.getProject().getModules()) {
            modules.put(module.getName(), module);
        }
        return new BuildTargetLoader<GradleResourcesTarget>(){

            @Nullable
            public GradleResourcesTarget createTarget(@NotNull String targetId) {
                JpsModule module;
                if (targetId == null) {
                    1.$$$reportNull$$$0(0);
                }
                return (module = (JpsModule)modules.get(targetId)) != null ? new GradleResourcesTarget(GradleResourcesTargetType.this, module) : null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetId", "org/jetbrains/jps/gradle/model/impl/GradleResourcesTargetType$1", "createTarget"));
            }
        };
    }

    public static List<GradleResourcesTarget> buildModuleTargets(@NotNull JpsModule module, boolean includeTest) {
        if (module == null) {
            GradleResourcesTargetType.$$$reportNull$$$0(3);
        }
        ArrayList<GradleResourcesTarget> targets = new ArrayList<GradleResourcesTarget>();
        targets.add(new GradleResourcesTarget(PRODUCTION, module));
        if (includeTest) {
            targets.add(new GradleResourcesTarget(TEST, module));
        }
        return targets;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/gradle/model/impl/GradleResourcesTargetType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/gradle/model/impl/GradleResourcesTargetType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "computeAllTargets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "computeAllTargets";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createLoader";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "buildModuleTargets";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

